/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ltch.core.rules;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.ltch.api.v2.LtchClaimData;
import gov.cms.fiss.pricers.ltch.api.v2.LtchClaimPricingRequest;
import gov.cms.fiss.pricers.ltch.api.v2.LtchClaimPricingResponse;
import gov.cms.fiss.pricers.ltch.api.v2.LtchPaymentData;
import gov.cms.fiss.pricers.ltch.core.LtchPricerContext;
import gov.cms.fiss.pricers.ltch.core.codes.ErrorCode;
import gov.cms.fiss.pricers.ltch.core.codes.PaymentType;
import gov.cms.fiss.pricers.ltch.core.codes.SecondaryPaymentTypeSiteNeutral;
import gov.cms.fiss.pricers.ltch.core.codes.SecondaryPaymentTypeStandard;
import java.math.BigDecimal;
import java.math.RoundingMode;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalculateHighCostOutlierBlend
implements CalculationRule<LtchClaimPricingRequest, LtchClaimPricingResponse, LtchPricerContext> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CalculateHighCostOutlierBlend.class);
    private static final String ONE = "1";

    @Override
    public void calculate(LtchPricerContext calculationContext) {
        PaymentType paymentType = calculationContext.getPaymentType();
        SecondaryPaymentTypeStandard secondaryPaymentTypeStandard = calculationContext.getSecondaryPaymentTypeStandard();
        SecondaryPaymentTypeSiteNeutral secondaryPaymentTypeSiteNeutral = calculationContext.getSecondaryPaymentTypeSiteNeutral();
        LtchPaymentData paymentData = calculationContext.getPaymentData();
        LtchClaimData claimData = calculationContext.getClaimData();
        if (this.isOutlierAndSuccessful(calculationContext)) {
            if (paymentType.equals((Object)PaymentType.BLEND)) {
                this.calculateStandardOutlierThreshold(calculationContext, secondaryPaymentTypeStandard, paymentData);
                if (secondaryPaymentTypeSiteNeutral.equals((Object)SecondaryPaymentTypeSiteNeutral.IPPS)) {
                    paymentData.setOutlierThresholdAmount(paymentData.getSiteNeutralIppsPayment().add(calculationContext.getFixedLossAmountSiteNeutral()));
                }
                if (BigDecimalUtils.isGreaterThan(paymentData.getFacilityCosts(), calculationContext.getHoldOutlierThresholdStandard())) {
                    calculationContext.setHoldOutlierPayAmountStandard(paymentData.getFacilityCosts().subtract(calculationContext.getHoldOutlierThresholdStandard()).multiply(new BigDecimal("0.8")).multiply(calculationContext.getHoldBlendStandard()).setScale(2, RoundingMode.HALF_UP));
                }
                if (secondaryPaymentTypeSiteNeutral.equals((Object)SecondaryPaymentTypeSiteNeutral.IPPS) && BigDecimalUtils.isGreaterThan(paymentData.getFacilityCosts(), paymentData.getOutlierThresholdAmount())) {
                    calculationContext.setHoldOutlierPayAmountSiteNeutral(paymentData.getFacilityCosts().subtract(paymentData.getOutlierThresholdAmount()).multiply(new BigDecimal("0.8")).multiply(calculationContext.getHoldBlendSiteNeutral()).setScale(2, RoundingMode.HALF_UP));
                }
                paymentData.setOutlierPayment(calculationContext.getHoldOutlierPayAmountSiteNeutral().multiply(calculationContext.getHoldSiteNeutralIppsAdj()).add(calculationContext.getHoldOutlierPayAmountStandard()).setScale(2, RoundingMode.HALF_UP));
            }
            if (ONE.equals(claimData.getOutlierSpecialPaymentIndicator())) {
                paymentData.setOutlierPayment(BigDecimal.ZERO);
            }
        }
    }

    private void calculateStandardOutlierThreshold(LtchPricerContext calculationContext, SecondaryPaymentTypeStandard secondaryPaymentTypeStandard, LtchPaymentData paymentData) {
        if (secondaryPaymentTypeStandard.equals((Object)SecondaryPaymentTypeStandard.FULL)) {
            calculationContext.setHoldOutlierThresholdStandard(paymentData.getStandardFullPayment().add(calculationContext.getFixedLossAmountStandard()));
        } else {
            calculationContext.setHoldOutlierThresholdStandard(paymentData.getStandardShortStayOutlierPayment().add(calculationContext.getFixedLossAmountStandard()));
        }
    }

    private boolean isOutlierAndSuccessful(LtchPricerContext calculationContext) {
        return calculationContext.getCalculateOutliers() != false && !ErrorCode.isErrorCode(calculationContext.getReturnCode());
    }
}

