/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ltch.core.rules;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.ltch.api.v2.LtchClaimPricingRequest;
import gov.cms.fiss.pricers.ltch.api.v2.LtchClaimPricingResponse;
import gov.cms.fiss.pricers.ltch.core.LtchPricerContext;
import gov.cms.fiss.pricers.ltch.core.codes.CbsaProviderType;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class CalculateOperatingDshAmount
implements CalculationRule<LtchClaimPricingRequest, LtchClaimPricingResponse, LtchPricerContext> {
    private static final String RURAL_BEDS = "500";
    private static final String URBAN_BEDS = "100";

    @Override
    public void calculate(LtchPricerContext calculationContext) {
        CbsaProviderType cbsaProviderType = calculationContext.getCbsaProviderType();
        switch (this.determineGeographicalClass(cbsaProviderType, calculationContext)) {
            case "TWO": {
                calculationContext.setHoldOperatingDshAmount(this.getOperatingDshAmount(calculationContext));
                break;
            }
            case "THREE": {
                calculationContext.setHoldOperatingDshAmount(this.getOperatingDshAmount(calculationContext));
                if (!BigDecimalUtils.isGreaterThan(calculationContext.getHoldOperatingDshAmount(), new BigDecimal("0.12"))) break;
                calculationContext.setHoldOperatingDshAmount(new BigDecimal("0.12").setScale(4, RoundingMode.HALF_UP));
                break;
            }
            case "FOUR": {
                calculationContext.setHoldOperatingDshAmount(BigDecimal.ZERO.setScale(4, RoundingMode.HALF_UP));
                break;
            }
        }
        calculationContext.setHoldOperatingDshAmount(calculationContext.getHoldOperatingDshAmount().multiply(calculationContext.getOperatingDshReductionFactor()).setScale(4, RoundingMode.HALF_UP));
    }

    private BigDecimal getOperatingDshAmount(LtchPricerContext calculationContext) {
        BigDecimal operatingMin = new BigDecimal("0.15");
        BigDecimal operatingMax = new BigDecimal("0.202");
        BigDecimal operatingDshAmount = BigDecimalUtils.isGreaterThanOrEqualTo(calculationContext.getHoldOperatingDshPercent(), operatingMin) && BigDecimalUtils.isLessThanOrEqualTo(calculationContext.getHoldOperatingDshPercent(), operatingMax) ? calculationContext.getHoldOperatingDshPercent().subtract(operatingMin).multiply(new BigDecimal("0.65")).add(new BigDecimal("0.025")) : (BigDecimalUtils.isGreaterThan(calculationContext.getHoldOperatingDshPercent(), operatingMax) ? calculationContext.getHoldOperatingDshPercent().subtract(operatingMax).multiply(new BigDecimal("0.825")).add(new BigDecimal("0.0588")) : BigDecimal.ZERO);
        return operatingDshAmount.setScale(4, RoundingMode.HALF_UP);
    }

    private String determineGeographicalClass(CbsaProviderType cbsaProviderType, LtchPricerContext calculationContext) {
        String geographicalClass = "FOUR";
        BigDecimal minimumOperatingDshPercentage = new BigDecimal("0.15");
        BigDecimal urbanBeds = new BigDecimal(URBAN_BEDS);
        BigDecimal ruralBeds = new BigDecimal(RURAL_BEDS);
        if (BigDecimalUtils.isGreaterThanOrEqualTo(calculationContext.getHoldOperatingDshPercent(), minimumOperatingDshPercentage)) {
            if (cbsaProviderType.equals((Object)CbsaProviderType.URBAN) && BigDecimalUtils.isLessThan(calculationContext.getHoldBedSize(), urbanBeds) || cbsaProviderType.equals((Object)CbsaProviderType.RURAL) && BigDecimalUtils.isLessThan(calculationContext.getHoldBedSize(), ruralBeds)) {
                geographicalClass = "THREE";
            } else if (cbsaProviderType.equals((Object)CbsaProviderType.URBAN) && BigDecimalUtils.isGreaterThanOrEqualTo(calculationContext.getHoldBedSize(), urbanBeds) || cbsaProviderType.equals((Object)CbsaProviderType.RURAL) && BigDecimalUtils.isGreaterThanOrEqualTo(calculationContext.getHoldBedSize(), ruralBeds)) {
                geographicalClass = "TWO";
            }
        }
        return geographicalClass;
    }
}

