/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ltch.core.rules;

import ch.obermuhlner.math.big.BigDecimalMath;
import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.ltch.api.v2.LtchClaimPricingRequest;
import gov.cms.fiss.pricers.ltch.api.v2.LtchClaimPricingResponse;
import gov.cms.fiss.pricers.ltch.core.LtchPricerContext;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;

public class CalculatePerDiem
implements CalculationRule<LtchClaimPricingRequest, LtchClaimPricingResponse, LtchPricerContext> {
    @Override
    public void calculate(LtchPricerContext calculationContext) {
        calculationContext.setHoldLargeUrbanAddon(BigDecimal.ONE);
        calculationContext.setHoldCapitalGeographicAreaFactor(BigDecimalMath.pow(calculationContext.getHoldProvIppsCBSA().getGeographicWageIndex(), new BigDecimal("0.6848"), new MathContext(10)).setScale(4, RoundingMode.HALF_UP));
        calculationContext.setHoldCapitalPayment(calculationContext.getIppsCapitalStandardFedRate().multiply(calculationContext.getHoldIppsDrgWeight()).multiply(calculationContext.getHoldCapitalGeographicAreaFactor()).multiply(calculationContext.getHoldLargeUrbanAddon()).multiply(calculationContext.getHoldCapitalCola()).multiply(BigDecimal.ONE.add(calculationContext.getHoldCapitalImeTeach()).add(calculationContext.getHoldCapitalDsh())).setScale(2, RoundingMode.HALF_UP));
        calculationContext.setHoldIppsPayAmount(calculationContext.getHoldStandardAmountOperatingPayment().add(calculationContext.getHoldCapitalPayment()).setScale(2, RoundingMode.HALF_UP));
        calculationContext.setHoldIppsPerDiem(calculationContext.getHoldIppsPayAmount().divide(calculationContext.getHoldIppsDrgALengthOfStay(), 3, RoundingMode.DOWN).multiply(calculationContext.getHoldLengthOfStay()).setScale(2, RoundingMode.HALF_UP));
        if (BigDecimalUtils.isGreaterThan(calculationContext.getHoldIppsPerDiem(), calculationContext.getHoldIppsPayAmount())) {
            calculationContext.setHoldIppsPerDiem(calculationContext.getHoldIppsPayAmount().setScale(2, RoundingMode.HALF_UP));
        }
    }
}

