/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ltch.core.rules;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.ltch.api.v2.LtchClaimPricingRequest;
import gov.cms.fiss.pricers.ltch.api.v2.LtchClaimPricingResponse;
import gov.cms.fiss.pricers.ltch.api.v2.LtchPaymentData;
import gov.cms.fiss.pricers.ltch.core.LtchPricerContext;
import java.math.BigDecimal;
import java.math.RoundingMode;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalculateShortStay
implements CalculationRule<LtchClaimPricingRequest, LtchClaimPricingResponse, LtchPricerContext> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CalculateShortStay.class);

    @Override
    public boolean shouldExecute(LtchPricerContext calculationContext) {
        return calculationContext.isPaymentStandardOrBlend() && BigDecimalUtils.isLessThanOrEqualTo(calculationContext.getHoldLengthOfStay(), calculationContext.getHoldShortStayOutlierThreshold());
    }

    @Override
    public void calculate(LtchPricerContext calculationContext) {
        LtchPaymentData paymentData = calculationContext.getPaymentData();
        calculationContext.setHoldShortStayPayAmount(paymentData.getAdjustedPayment().divide(paymentData.getAverageLengthOfStay(), 3, RoundingMode.DOWN).multiply(calculationContext.getHoldLengthOfStay()).multiply(new BigDecimal("1.2")).setScale(2, RoundingMode.HALF_UP));
    }
}

