/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ltch.core.rules;

import gov.cms.fiss.pricers.common.api.InpatientProviderData;
import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.common.util.LocalDateUtils;
import gov.cms.fiss.pricers.ltch.api.v2.LtchClaimData;
import gov.cms.fiss.pricers.ltch.api.v2.LtchClaimPricingRequest;
import gov.cms.fiss.pricers.ltch.api.v2.LtchClaimPricingResponse;
import gov.cms.fiss.pricers.ltch.api.v2.LtchPaymentData;
import gov.cms.fiss.pricers.ltch.core.LtchPricerContext;
import gov.cms.fiss.pricers.ltch.core.codes.ReturnCode;
import gov.cms.fiss.pricers.ltch.core.models.LtchWageIndexTableEntry;
import gov.cms.fiss.pricers.ltch.core.tables.CbsaWageIndexEntry;
import gov.cms.fiss.pricers.ltch.core.tables.DataTables;
import java.time.LocalDate;
import org.apache.commons.lang3.StringUtils;

public class DetermineLtchWageIndex
implements CalculationRule<LtchClaimPricingRequest, LtchClaimPricingResponse, LtchPricerContext> {
    @Override
    public void calculate(LtchPricerContext calculationContext) {
        String trimmedGeolocation;
        LtchClaimData claimData = calculationContext.getClaimData();
        InpatientProviderData providerData = calculationContext.getProviderData();
        LtchPaymentData paymentData = calculationContext.getPaymentData();
        LocalDate fyBegin = calculationContext.getFyBegin();
        LocalDate fyEnd = calculationContext.getFyEnd();
        LtchWageIndexTableEntry wageIndexTable = calculationContext.getLtchWageIndexTableEntry();
        DataTables dataTables = calculationContext.getDataTables();
        boolean specialWageIndexSet = false;
        if (calculationContext.isSpecialPaymentIndicatorSpecial(providerData.getSpecialPaymentIndicator())) {
            if (BigDecimalUtils.isGreaterThanZero(providerData.getSpecialWageIndex()) && LocalDateUtils.inRange(providerData.getEffectiveDate(), fyBegin, fyEnd)) {
                wageIndexTable.setCbsa(0);
                wageIndexTable.setEffectiveDate(providerData.getEffectiveDate());
                wageIndexTable.setLtchWageIndex1(providerData.getSpecialWageIndex());
                wageIndexTable.setLtchWageIndex2(providerData.getSpecialWageIndex());
                wageIndexTable.setLtchWageIndex3(providerData.getSpecialWageIndex());
                specialWageIndexSet = true;
            } else {
                calculationContext.applyReturnCode(ReturnCode.INVALID_WAGE_INDEX_52);
            }
        }
        if ("00".equalsIgnoreCase(trimmedGeolocation = providerData.getCbsaActualGeographicLocation() != null ? providerData.getCbsaActualGeographicLocation().trim() : "")) {
            trimmedGeolocation = "03";
        }
        CbsaWageIndexEntry cbsaIndex = dataTables.getCbsaWageIndexEntry(trimmedGeolocation, providerData.getEffectiveDate());
        if (!specialWageIndexSet && cbsaIndex != null && LocalDateUtils.isAfterOrEqual(claimData.getDischargeDate(), cbsaIndex.getEffectiveDate()) && (StringUtils.equalsAny(trimmedGeolocation, "98", "99") || LocalDateUtils.inRange(cbsaIndex.getEffectiveDate(), fyBegin, fyEnd))) {
            wageIndexTable.setCbsa(Integer.valueOf(trimmedGeolocation));
            wageIndexTable.setEffectiveDate(cbsaIndex.getEffectiveDate());
            wageIndexTable.setLtchWageIndex1(BigDecimalUtils.ZERO);
            wageIndexTable.setLtchWageIndex2(BigDecimalUtils.ZERO);
            wageIndexTable.setLtchWageIndex3(cbsaIndex.getGeographicWageIndex());
        } else if (cbsaIndex == null) {
            calculationContext.applyReturnCode(ReturnCode.CBSA_WAGE_INDEX_NOT_FOUND_60);
        }
        calculationContext.setPaymentData(paymentData);
        calculationContext.setLtchWageIndexTableEntry(wageIndexTable);
    }
}

