/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ltch.core.rules;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.ltch.api.v1.InpatientDrgsTableEntry;
import gov.cms.fiss.pricers.ltch.api.v2.LtchClaimData;
import gov.cms.fiss.pricers.ltch.api.v2.LtchClaimPricingRequest;
import gov.cms.fiss.pricers.ltch.api.v2.LtchClaimPricingResponse;
import gov.cms.fiss.pricers.ltch.api.v2.LtchPaymentData;
import gov.cms.fiss.pricers.ltch.core.LtchPricerContext;
import gov.cms.fiss.pricers.ltch.core.codes.ReturnCode;

public class EditIppsDrgCode
implements CalculationRule<LtchClaimPricingRequest, LtchClaimPricingResponse, LtchPricerContext> {
    @Override
    public void calculate(LtchPricerContext calculationContext) {
        LtchClaimData claimData = calculationContext.getClaimData();
        LtchPaymentData paymentData = calculationContext.getPaymentData();
        String drgCode = claimData.getDiagnosisRelatedGroup();
        InpatientDrgsTableEntry entry = calculationContext.getDataTables().getInpatientDrgEntry(drgCode, claimData.getDischargeDate());
        if (entry == null || drgCode == null) {
            calculationContext.applyReturnCode(ReturnCode.DRG_NOT_FOUND_54);
            calculationContext.setPaymentData(paymentData);
            return;
        }
        calculationContext.setHoldIppsDrgWeight(entry.getWeight());
        calculationContext.setHoldIppsDrgALengthOfStay(entry.getGeometricMeanLengthOfStay());
        calculationContext.setHoldIppsArithALengthOfStay(entry.getArithmeticMeanLengthOfStay());
    }
}

