/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ltch.core.rules;

import gov.cms.fiss.pricers.common.application.rules.CalculationEvaluator;
import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.ltch.api.v2.LtchClaimPricingRequest;
import gov.cms.fiss.pricers.ltch.api.v2.LtchClaimPricingResponse;
import gov.cms.fiss.pricers.ltch.core.LtchPricerContext;
import gov.cms.fiss.pricers.ltch.core.codes.ReturnCode;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class SkipOnErrorCode
implements CalculationRule<LtchClaimPricingRequest, LtchClaimPricingResponse, LtchPricerContext> {
    private final CalculationEvaluator<LtchClaimPricingRequest, LtchClaimPricingResponse, LtchPricerContext> evaluator;

    public SkipOnErrorCode(List<CalculationRule<LtchClaimPricingRequest, LtchClaimPricingResponse, LtchPricerContext>> rules) {
        this.evaluator = new CalculationEvaluator(rules.stream().map(Mutator::new).collect(Collectors.toList()));
    }

    public SkipOnErrorCode(CalculationRule<LtchClaimPricingRequest, LtchClaimPricingResponse, LtchPricerContext> rule) {
        this.evaluator = new CalculationEvaluator(List.of(new Mutator(rule)));
    }

    @Override
    public void calculate(LtchPricerContext pricerContext) {
        this.evaluator.evaluateRulesForContext(pricerContext);
    }

    private static class Mutator
    implements CalculationRule<LtchClaimPricingRequest, LtchClaimPricingResponse, LtchPricerContext> {
        private final CalculationRule<LtchClaimPricingRequest, LtchClaimPricingResponse, LtchPricerContext> rule;

        public Mutator(CalculationRule<LtchClaimPricingRequest, LtchClaimPricingResponse, LtchPricerContext> rule) {
            this.rule = rule;
        }

        @Override
        public boolean shouldExecute(LtchPricerContext calculationContext) {
            return StringUtils.equals(ReturnCode.NORMAL_DRG_00.getCode(), calculationContext.getReturnCode()) && this.rule.shouldExecute(calculationContext);
        }

        @Override
        public void calculate(LtchPricerContext calculationContext) {
            this.rule.calculate(calculationContext);
        }
    }
}

