/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ltch.core.rules;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.ltch.api.v2.LtchClaimPricingRequest;
import gov.cms.fiss.pricers.ltch.api.v2.LtchClaimPricingResponse;
import gov.cms.fiss.pricers.ltch.core.LtchPricerContext;
import gov.cms.fiss.pricers.ltch.core.codes.ReturnCode;
import gov.cms.fiss.pricers.ltch.core.tables.CbsaWageIndexEntry;

public class SupplementalWageIndexToIppsWageIndex
implements CalculationRule<LtchClaimPricingRequest, LtchClaimPricingResponse, LtchPricerContext> {
    @Override
    public void calculate(LtchPricerContext calculationContext) {
        if ("2".equals(calculationContext.getSupplementalWageIndexIndicator()) && calculationContext.getSupplementalWageIndex() != null) {
            if (BigDecimalUtils.isGreaterThanZero(calculationContext.getSupplementalWageIndex()) && calculationContext.getHoldProvIppsCBSA() != null) {
                CbsaWageIndexEntry entry = calculationContext.getHoldProvIppsCBSA().copyBuilder().geographicWageIndex(calculationContext.getSupplementalWageIndex()).build();
                calculationContext.setHoldProvIppsCBSA(entry);
            } else {
                calculationContext.applyReturnCode(ReturnCode.INVALID_WAGE_INDEX_52);
            }
        }
    }
}

