// Generated by delombok at Thu Sep 11 13:52:26 UTC 2025
package gov.cms.fiss.pricers.ltch.core.rules;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.ltch.api.v2.LtchClaimPricingRequest;
import gov.cms.fiss.pricers.ltch.api.v2.LtchClaimPricingResponse;
import gov.cms.fiss.pricers.ltch.core.LtchPricerContext;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;

public class CalculateShortStayBlendedPayment implements CalculationRule<LtchClaimPricingRequest, LtchClaimPricingResponse, LtchPricerContext> {
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(CalculateShortStayBlendedPayment.class);

  @Override
  public boolean shouldExecute(LtchPricerContext calculationContext) {
    return calculationContext.isPaymentStandardOrBlend() && BigDecimalUtils.isLessThanOrEqualTo(calculationContext.getHoldLengthOfStay(), calculationContext.getHoldShortStayOutlierThreshold());
  }

  /**
   * <pre>
   * ***************************************************************
   * *    CALCULATE THE SHORT STAY BLENDED PAYMENT ALTERNATIVE     *
   * *       THIS PAYMENT IS A BLEND OF 120% OF THE SHORT STAY     *
   * *       PER DIEM (SHORT STAY PAYMENT AMT) AND 100% OF THE     *
   * *       IPPS COMPARABLE PER DIEM PAYMENT AMT                  *
   * ***************************************************************
   * </pre>
   *
   * Converted from {@code 3600-SS-BLENDED-PMT}.
   */
  @Override
  public void calculate(LtchPricerContext calculationContext) {
    // IF H-LOS <= H-SSOT
    // IF PMT-STANDARD-NEW OR PMT-BLEND
    // *** ------------------------------------------------------ ***
    // *** CALCULATE THE BLEND PERCENTAGE OF LTC-DRG PER DIEM     ***
    // *** ------------------------------------------------------ ***
    // MathContext(7) was used to match the COBOL more closely
    if (BigDecimalUtils.isLessThan(calculationContext.getHoldShortStayOutlierThreshold(), new BigDecimal("25"))) {
      // COMPUTE H-LTCH-BLEND-PCT ROUNDED =
      //          H-LOS / H-SSOT
      calculationContext.setHoldLtchBlendPercentage(calculationContext.getHoldLengthOfStay().divide(calculationContext.getHoldShortStayOutlierThreshold(), new MathContext(7)));
    } else {
      // COMPUTE H-LTCH-BLEND-PCT ROUNDED =
      //          H-LOS / 25
      calculationContext.setHoldLtchBlendPercentage(calculationContext.getHoldLengthOfStay().divide(new BigDecimal("25"), new MathContext(7)));
    }
    // IF H-LTCH-BLEND-PCT > 1
    if (BigDecimalUtils.isGreaterThan(calculationContext.getHoldLtchBlendPercentage(), BigDecimal.ONE)) {
      //   MOVE 1 TO H-LTCH-BLEND-PCT
      calculationContext.setHoldLtchBlendPercentage(BigDecimal.ONE);
    }
    // END-IF.
    calculationContext.setHoldLtchBlendPercentage(calculationContext.getHoldLtchBlendPercentage().setScale(4, RoundingMode.HALF_UP));
    // *** ------------------------------------------------------ ***
    // *** CALCULATE THE BLEND AMOUNT OF LTC-DRG PER DIEM         ***
    // *** ------------------------------------------------------ ***
    // COMPUTE H-LTCH-BLEND-AMT ROUNDED =
    //        H-SS-PAY-AMT * H-LTCH-BLEND-PCT.
    calculationContext.setHoldLtchBlendAmount(calculationContext.getHoldShortStayPayAmount().multiply(calculationContext.getHoldLtchBlendPercentage()).setScale(2, RoundingMode.HALF_UP));
  }
}
