// Generated by delombok at Thu Sep 11 13:51:57 UTC 2025
package gov.cms.fiss.pricers.ltch.api.v2;

import gov.cms.fiss.pricers.common.api.ClaimData;
import gov.cms.fiss.pricers.common.api.serialization.BigDecimalScale;
import gov.cms.fiss.pricers.common.api.serialization.StrictLocalDate;
import gov.cms.fiss.pricers.common.api.validation.ValidDiagnosisRelatedGroup;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.*;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;

@Schema(description = "The LTCH claim data.", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "BILL-NEW-DATA", value = "<structure>")})})
public class LtchClaimData extends ClaimData {
  @Max(999)
  @Min(0)
  @Schema(description = "The number of cost report days.", example = "10", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "B-CST-RPT-DAYS", value = "PIC 9(03)")})})
  private int costReportDays;
  @BigDecimalScale
  @DecimalMax("999999999.99")
  @DecimalMin("0")
  @Digits(integer = 9, fraction = 2)
  @NotNull
  @Schema(description = "The covered charges.", example = "950.80", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "B-COV-CHARGES", value = "PIC 9(07)V9(02)")})})
  private BigDecimal coveredCharges;
  @Max(999)
  @Min(0)
  @NotNull
  @Schema(description = "The number of covered days.", example = "23", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "B-COV-DAYS", value = "PIC 9(03)")})})
  private Integer coveredDays;
  @ArraySchema(arraySchema = @Schema(description = "The diagnosis codes related to this code.", example = "[ \"N390\", \"B952\", \"I130\", \"I5032\", \"N179\", \"M25511\", \"M549\" ]"), extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "B-DIAGNOSIS-CODE-TABLE", value = "B-DIAGNOSIS-CODE  PIC X(07) OCCURS 25 TIMES")})})
  @Size(max = 25, min = 1)
  private List<@Pattern(regexp = "[A-Z\\d]{1,7}", message = "must be between one and seven characters") String> diagnosisCodes;
  @NotNull
  @Schema(description = "The diagnosis-related group.", example = "003", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "B-DRG-CODE", value = "PIC 9(03)")})})
  @ValidDiagnosisRelatedGroup
  private String diagnosisRelatedGroup;
  @Pattern(regexp = "[A-Z\\d]", message = "must be an alphanumeric character")
  @Schema(description = "The diagnosis-related group severity.", example = "1")
  private String diagnosisRelatedGroupSeverity;
  @NotNull
  @Schema(description = "The discharge date.", example = "2020-05-13", format = "yyyy-MM-dd", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "B-DISCHARGE-DATE", value = "B-DISCHG-CC  PIC 9(02)\n" + "B-DISCHG-YY  PIC 9(02)\n" + "B-DISCHG-MM  PIC 9(02)\n" + "B-DISCHG-DD  PIC 9(02)")})})
  @StrictLocalDate
  private LocalDate dischargeDate;
  @Max(999)
  @Min(0)
  @NotNull
  @Schema(description = "The length of stay (LOS).", example = "5", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "B-LOS", value = "PIC 9(03)")})})
  private Integer lengthOfStay;
  @Max(99)
  @Min(0)
  @NotNull
  @Schema(description = "The number of lifetime reserve days.", example = "6", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "B-LTR-DAYS", value = "PIC 9(02)")})})
  private Integer lifetimeReserveDays;
  @Pattern(regexp = "1", message = "must be `1` if present")
  @Schema(description = "The outlier special payment indicator.", example = "1", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "B-SPEC-PAY-IND", value = "PIC X(01)")})})
  private String outlierSpecialPaymentIndicator;
  @NotNull
  @Pattern(regexp = "\\d{2}", message = "must be two digits")
  @Schema(description = "The patient status.", example = "02", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "B-PATIENT-STATUS", value = "PIC X(02)")})})
  private String patientStatus;
  @ArraySchema(arraySchema = @Schema(description = "The procedure codes related to this claim.", example = "[\"04VD3FZ\", \"XNS0032\", \"XW033F3\", \"3E0J7U1\"]"), extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "B-PROCEDURE-CODE-TABLE", value = "B-PROCEDURE-CODE  PIC " + "X(07) OCCURS 25 TIMES")})})
  @Size(max = 25, min = 1)
  private List<@Pattern(regexp = "[A-Z\\d]{7}", message = "must be seven characters") String> procedureCodes;
  @NotNull
  @Pattern(regexp = "\\d{2}", message = "must be two digits")
  @Schema(description = "The code documenting the state of claim review.", example = "07", extensions = @Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "B-REVIEW-CODE", value = "PIC 9(02)")}))
  private String reviewCode;

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int getCostReportDays() {
    return this.costReportDays;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getCoveredCharges() {
    return this.coveredCharges;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Integer getCoveredDays() {
    return this.coveredDays;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public List<@Pattern(regexp = "[A-Z\\d]{1,7}", message = "must be between one and seven characters") String> getDiagnosisCodes() {
    return this.diagnosisCodes;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getDiagnosisRelatedGroup() {
    return this.diagnosisRelatedGroup;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getDiagnosisRelatedGroupSeverity() {
    return this.diagnosisRelatedGroupSeverity;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public LocalDate getDischargeDate() {
    return this.dischargeDate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Integer getLengthOfStay() {
    return this.lengthOfStay;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Integer getLifetimeReserveDays() {
    return this.lifetimeReserveDays;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getOutlierSpecialPaymentIndicator() {
    return this.outlierSpecialPaymentIndicator;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getPatientStatus() {
    return this.patientStatus;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public List<@Pattern(regexp = "[A-Z\\d]{7}", message = "must be seven characters") String> getProcedureCodes() {
    return this.procedureCodes;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getReviewCode() {
    return this.reviewCode;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCostReportDays(final int costReportDays) {
    this.costReportDays = costReportDays;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCoveredCharges(final BigDecimal coveredCharges) {
    this.coveredCharges = coveredCharges;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCoveredDays(final Integer coveredDays) {
    this.coveredDays = coveredDays;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDiagnosisCodes(final List<@Pattern(regexp = "[A-Z\\d]{1,7}", message = "must be between one and seven characters") String> diagnosisCodes) {
    this.diagnosisCodes = diagnosisCodes;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDiagnosisRelatedGroup(final String diagnosisRelatedGroup) {
    this.diagnosisRelatedGroup = diagnosisRelatedGroup;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDiagnosisRelatedGroupSeverity(final String diagnosisRelatedGroupSeverity) {
    this.diagnosisRelatedGroupSeverity = diagnosisRelatedGroupSeverity;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDischargeDate(final LocalDate dischargeDate) {
    this.dischargeDate = dischargeDate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLengthOfStay(final Integer lengthOfStay) {
    this.lengthOfStay = lengthOfStay;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLifetimeReserveDays(final Integer lifetimeReserveDays) {
    this.lifetimeReserveDays = lifetimeReserveDays;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOutlierSpecialPaymentIndicator(final String outlierSpecialPaymentIndicator) {
    this.outlierSpecialPaymentIndicator = outlierSpecialPaymentIndicator;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPatientStatus(final String patientStatus) {
    this.patientStatus = patientStatus;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setProcedureCodes(final List<@Pattern(regexp = "[A-Z\\d]{7}", message = "must be seven characters") String> procedureCodes) {
    this.procedureCodes = procedureCodes;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setReviewCode(final String reviewCode) {
    this.reviewCode = reviewCode;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof LtchClaimData)) return false;
    final LtchClaimData other = (LtchClaimData) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    if (!super.equals(o)) return false;
    if (this.getCostReportDays() != other.getCostReportDays()) return false;
    final java.lang.Object this$coveredDays = this.getCoveredDays();
    final java.lang.Object other$coveredDays = other.getCoveredDays();
    if (this$coveredDays == null ? other$coveredDays != null : !this$coveredDays.equals(other$coveredDays)) return false;
    final java.lang.Object this$lengthOfStay = this.getLengthOfStay();
    final java.lang.Object other$lengthOfStay = other.getLengthOfStay();
    if (this$lengthOfStay == null ? other$lengthOfStay != null : !this$lengthOfStay.equals(other$lengthOfStay)) return false;
    final java.lang.Object this$lifetimeReserveDays = this.getLifetimeReserveDays();
    final java.lang.Object other$lifetimeReserveDays = other.getLifetimeReserveDays();
    if (this$lifetimeReserveDays == null ? other$lifetimeReserveDays != null : !this$lifetimeReserveDays.equals(other$lifetimeReserveDays)) return false;
    final java.lang.Object this$coveredCharges = this.getCoveredCharges();
    final java.lang.Object other$coveredCharges = other.getCoveredCharges();
    if (this$coveredCharges == null ? other$coveredCharges != null : !this$coveredCharges.equals(other$coveredCharges)) return false;
    final java.lang.Object this$diagnosisCodes = this.getDiagnosisCodes();
    final java.lang.Object other$diagnosisCodes = other.getDiagnosisCodes();
    if (this$diagnosisCodes == null ? other$diagnosisCodes != null : !this$diagnosisCodes.equals(other$diagnosisCodes)) return false;
    final java.lang.Object this$diagnosisRelatedGroup = this.getDiagnosisRelatedGroup();
    final java.lang.Object other$diagnosisRelatedGroup = other.getDiagnosisRelatedGroup();
    if (this$diagnosisRelatedGroup == null ? other$diagnosisRelatedGroup != null : !this$diagnosisRelatedGroup.equals(other$diagnosisRelatedGroup)) return false;
    final java.lang.Object this$diagnosisRelatedGroupSeverity = this.getDiagnosisRelatedGroupSeverity();
    final java.lang.Object other$diagnosisRelatedGroupSeverity = other.getDiagnosisRelatedGroupSeverity();
    if (this$diagnosisRelatedGroupSeverity == null ? other$diagnosisRelatedGroupSeverity != null : !this$diagnosisRelatedGroupSeverity.equals(other$diagnosisRelatedGroupSeverity)) return false;
    final java.lang.Object this$dischargeDate = this.getDischargeDate();
    final java.lang.Object other$dischargeDate = other.getDischargeDate();
    if (this$dischargeDate == null ? other$dischargeDate != null : !this$dischargeDate.equals(other$dischargeDate)) return false;
    final java.lang.Object this$outlierSpecialPaymentIndicator = this.getOutlierSpecialPaymentIndicator();
    final java.lang.Object other$outlierSpecialPaymentIndicator = other.getOutlierSpecialPaymentIndicator();
    if (this$outlierSpecialPaymentIndicator == null ? other$outlierSpecialPaymentIndicator != null : !this$outlierSpecialPaymentIndicator.equals(other$outlierSpecialPaymentIndicator)) return false;
    final java.lang.Object this$patientStatus = this.getPatientStatus();
    final java.lang.Object other$patientStatus = other.getPatientStatus();
    if (this$patientStatus == null ? other$patientStatus != null : !this$patientStatus.equals(other$patientStatus)) return false;
    final java.lang.Object this$procedureCodes = this.getProcedureCodes();
    final java.lang.Object other$procedureCodes = other.getProcedureCodes();
    if (this$procedureCodes == null ? other$procedureCodes != null : !this$procedureCodes.equals(other$procedureCodes)) return false;
    final java.lang.Object this$reviewCode = this.getReviewCode();
    final java.lang.Object other$reviewCode = other.getReviewCode();
    if (this$reviewCode == null ? other$reviewCode != null : !this$reviewCode.equals(other$reviewCode)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof LtchClaimData;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = super.hashCode();
    result = result * PRIME + this.getCostReportDays();
    final java.lang.Object $coveredDays = this.getCoveredDays();
    result = result * PRIME + ($coveredDays == null ? 43 : $coveredDays.hashCode());
    final java.lang.Object $lengthOfStay = this.getLengthOfStay();
    result = result * PRIME + ($lengthOfStay == null ? 43 : $lengthOfStay.hashCode());
    final java.lang.Object $lifetimeReserveDays = this.getLifetimeReserveDays();
    result = result * PRIME + ($lifetimeReserveDays == null ? 43 : $lifetimeReserveDays.hashCode());
    final java.lang.Object $coveredCharges = this.getCoveredCharges();
    result = result * PRIME + ($coveredCharges == null ? 43 : $coveredCharges.hashCode());
    final java.lang.Object $diagnosisCodes = this.getDiagnosisCodes();
    result = result * PRIME + ($diagnosisCodes == null ? 43 : $diagnosisCodes.hashCode());
    final java.lang.Object $diagnosisRelatedGroup = this.getDiagnosisRelatedGroup();
    result = result * PRIME + ($diagnosisRelatedGroup == null ? 43 : $diagnosisRelatedGroup.hashCode());
    final java.lang.Object $diagnosisRelatedGroupSeverity = this.getDiagnosisRelatedGroupSeverity();
    result = result * PRIME + ($diagnosisRelatedGroupSeverity == null ? 43 : $diagnosisRelatedGroupSeverity.hashCode());
    final java.lang.Object $dischargeDate = this.getDischargeDate();
    result = result * PRIME + ($dischargeDate == null ? 43 : $dischargeDate.hashCode());
    final java.lang.Object $outlierSpecialPaymentIndicator = this.getOutlierSpecialPaymentIndicator();
    result = result * PRIME + ($outlierSpecialPaymentIndicator == null ? 43 : $outlierSpecialPaymentIndicator.hashCode());
    final java.lang.Object $patientStatus = this.getPatientStatus();
    result = result * PRIME + ($patientStatus == null ? 43 : $patientStatus.hashCode());
    final java.lang.Object $procedureCodes = this.getProcedureCodes();
    result = result * PRIME + ($procedureCodes == null ? 43 : $procedureCodes.hashCode());
    final java.lang.Object $reviewCode = this.getReviewCode();
    result = result * PRIME + ($reviewCode == null ? 43 : $reviewCode.hashCode());
    return result;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public java.lang.String toString() {
    return "LtchClaimData(costReportDays=" + this.getCostReportDays() + ", coveredCharges=" + this.getCoveredCharges() + ", coveredDays=" + this.getCoveredDays() + ", diagnosisCodes=" + this.getDiagnosisCodes() + ", diagnosisRelatedGroup=" + this.getDiagnosisRelatedGroup() + ", diagnosisRelatedGroupSeverity=" + this.getDiagnosisRelatedGroupSeverity() + ", dischargeDate=" + this.getDischargeDate() + ", lengthOfStay=" + this.getLengthOfStay() + ", lifetimeReserveDays=" + this.getLifetimeReserveDays() + ", outlierSpecialPaymentIndicator=" + this.getOutlierSpecialPaymentIndicator() + ", patientStatus=" + this.getPatientStatus() + ", procedureCodes=" + this.getProcedureCodes() + ", reviewCode=" + this.getReviewCode() + ")";
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public LtchClaimData() {
  }
}
