/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.common.application.filters;

import ch.qos.logback.classic.Logger;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import gov.cms.fiss.pricers.common.application.filters.LogContent;
import gov.cms.fiss.pricers.common.application.filters.LogFilterConfiguration;
import gov.cms.fiss.pricers.common.application.filters.PricerContentLogFilter;
import jakarta.annotation.Priority;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.ext.Provider;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

@Priority(value=5000)
@Provider
public class PricerResponseLogFilter
extends PricerContentLogFilter
implements ContainerResponseFilter {
    private static final Logger LOGGER = (Logger)LoggerFactory.getLogger(PricerResponseLogFilter.class);
    private final String[] responseCapturePaths;

    public PricerResponseLogFilter(ObjectMapper mapper, LogFilterConfiguration logFilterConfiguration) {
        super(LOGGER, mapper, logFilterConfiguration);
        this.responseCapturePaths = logFilterConfiguration.getResponseCapturePaths().toArray(new String[0]);
    }

    private static String cleanContent(String responseBodyContent) {
        return responseBodyContent.replace("\n|\\n|\n", "");
    }

    @Override
    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws JsonProcessingException {
        String stTime = MDC.get("startTime");
        long executionTime = 0L;
        if (StringUtils.isNotEmpty(stTime)) {
            executionTime = System.currentTimeMillis() - Long.parseLong(stTime);
        }
        MDC.put("executionTime", String.valueOf(executionTime));
        MDC.put("statusCode", String.valueOf(responseContext.getStatus()));
        responseContext.getHeaders().add("cms-pricer-tx-id", MDC.get("transactionID"));
        if (null != MDC.get("documentControlNumber")) {
            responseContext.getHeaders().add("cms-dcn", MDC.get("documentControlNumber"));
        }
        if (null != MDC.get("requestIdentifier")) {
            responseContext.getHeaders().add("cms-pricer-request-id", MDC.get("requestIdentifier"));
        }
        String headerJSON = this.mapper.writeValueAsString(this.constrainObjectMap(responseContext.getHeaders()));
        LogContent logContent = new LogContent("Request finished");
        logContent.setHeaders(headerJSON);
        if (StringUtils.endsWithAny(MDC.get("uri"), this.responseCapturePaths)) {
            String responseBody = this.readResponseEntity(responseContext);
            logContent.setResponseBody(responseBody);
        }
        String convertedLogContent = this.mapper.writeValueAsString(logContent);
        switch (responseContext.getStatusInfo().getFamily()) {
            case SERVER_ERROR: {
                LOGGER.error("{}", (Object)convertedLogContent);
                break;
            }
            case CLIENT_ERROR: {
                LOGGER.warn("{}", (Object)convertedLogContent);
                break;
            }
            default: {
                LOGGER.info("{}", (Object)convertedLogContent);
            }
        }
        MDC.clear();
    }

    private String readResponseEntity(ContainerResponseContext responseContext) {
        Object output = responseContext.getEntity();
        if (output == null) {
            return null;
        }
        if (output instanceof String) {
            return PricerResponseLogFilter.cleanContent((String)output);
        }
        try {
            return PricerResponseLogFilter.cleanContent(this.mapper.writeValueAsString(output));
        }
        catch (JsonProcessingException jpe) {
            return PricerResponseLogFilter.cleanContent(output.toString());
        }
    }
}

