// Generated by delombok at Thu Sep 11 13:51:57 UTC 2025
package gov.cms.fiss.pricers.ltch.api.v1;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import gov.cms.fiss.pricers.ltch.api.v1.LtchDrgsTableEntry.Fields;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.DecimalMax;
import jakarta.validation.constraints.DecimalMin;
import jakarta.validation.constraints.Digits;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.math.BigDecimal;

@JsonPropertyOrder({Fields.DIAGNOSTIC_RELATED_GROUP, Fields.RELATIVE_WEIGHT, Fields.ARITHMETIC_MEAN_LENGTH_OF_STAY})
@Schema(description = "The long-term care diagnostic-related group (DRG) information.")
public class LtchDrgsTableEntry {
  @DecimalMax("99.9")
  @DecimalMin("0")
  @Digits(integer = 2, fraction = 1)
  @NotNull
  @Schema(description = "Arithmetic mean length of stay.", example = "1.2", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "WWM-ALOS", value = "PIC 9(02)V9(01)")})})
  private BigDecimal arithmeticMeanLengthOfStay;
  @NotNull
  @Pattern(regexp = "\\d{3}")
  @Schema(description = "Diagnostic-related group.", example = "077", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "WWM-DRG", value = "PIC X(3)")})})
  private String diagnosticRelatedGroup;
  @DecimalMax("9.9999")
  @DecimalMin("0")
  @Digits(integer = 1, fraction = 4)
  @Schema(description = "Relative group weight.", example = "3.3326", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "WWM-RELWT", value = "PIC 9(01)V9(04)")})})
  private BigDecimal relativeWeight;

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public LtchDrgsTableEntry() {
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getArithmeticMeanLengthOfStay() {
    return this.arithmeticMeanLengthOfStay;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getDiagnosticRelatedGroup() {
    return this.diagnosticRelatedGroup;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getRelativeWeight() {
    return this.relativeWeight;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setArithmeticMeanLengthOfStay(final BigDecimal arithmeticMeanLengthOfStay) {
    this.arithmeticMeanLengthOfStay = arithmeticMeanLengthOfStay;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDiagnosticRelatedGroup(final String diagnosticRelatedGroup) {
    this.diagnosticRelatedGroup = diagnosticRelatedGroup;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setRelativeWeight(final BigDecimal relativeWeight) {
    this.relativeWeight = relativeWeight;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof LtchDrgsTableEntry)) return false;
    final LtchDrgsTableEntry other = (LtchDrgsTableEntry) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$arithmeticMeanLengthOfStay = this.getArithmeticMeanLengthOfStay();
    final java.lang.Object other$arithmeticMeanLengthOfStay = other.getArithmeticMeanLengthOfStay();
    if (this$arithmeticMeanLengthOfStay == null ? other$arithmeticMeanLengthOfStay != null : !this$arithmeticMeanLengthOfStay.equals(other$arithmeticMeanLengthOfStay)) return false;
    final java.lang.Object this$diagnosticRelatedGroup = this.getDiagnosticRelatedGroup();
    final java.lang.Object other$diagnosticRelatedGroup = other.getDiagnosticRelatedGroup();
    if (this$diagnosticRelatedGroup == null ? other$diagnosticRelatedGroup != null : !this$diagnosticRelatedGroup.equals(other$diagnosticRelatedGroup)) return false;
    final java.lang.Object this$relativeWeight = this.getRelativeWeight();
    final java.lang.Object other$relativeWeight = other.getRelativeWeight();
    if (this$relativeWeight == null ? other$relativeWeight != null : !this$relativeWeight.equals(other$relativeWeight)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof LtchDrgsTableEntry;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $arithmeticMeanLengthOfStay = this.getArithmeticMeanLengthOfStay();
    result = result * PRIME + ($arithmeticMeanLengthOfStay == null ? 43 : $arithmeticMeanLengthOfStay.hashCode());
    final java.lang.Object $diagnosticRelatedGroup = this.getDiagnosticRelatedGroup();
    result = result * PRIME + ($diagnosticRelatedGroup == null ? 43 : $diagnosticRelatedGroup.hashCode());
    final java.lang.Object $relativeWeight = this.getRelativeWeight();
    result = result * PRIME + ($relativeWeight == null ? 43 : $relativeWeight.hashCode());
    return result;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public java.lang.String toString() {
    return "LtchDrgsTableEntry(arithmeticMeanLengthOfStay=" + this.getArithmeticMeanLengthOfStay() + ", diagnosticRelatedGroup=" + this.getDiagnosticRelatedGroup() + ", relativeWeight=" + this.getRelativeWeight() + ")";
  }


  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public static final class Fields {
    public static final java.lang.String ARITHMETIC_MEAN_LENGTH_OF_STAY = "arithmeticMeanLengthOfStay";
    public static final java.lang.String DIAGNOSTIC_RELATED_GROUP = "diagnosticRelatedGroup";
    public static final java.lang.String RELATIVE_WEIGHT = "relativeWeight";
  }
}
