// Generated by delombok at Thu Sep 11 13:52:26 UTC 2025
package gov.cms.fiss.pricers.ltch;

import gov.cms.fiss.pricers.common.application.OpenApiPricerApplication;
import gov.cms.fiss.pricers.common.application.contract.OpenApiCustomizer;
import gov.cms.fiss.pricers.common.application.resources.CbsaWageIndexResource;
import gov.cms.fiss.pricers.ltch.core.Ltch2020PricerContext;
import gov.cms.fiss.pricers.ltch.core.Ltch2021PricerContext;
import gov.cms.fiss.pricers.ltch.core.Ltch2022PricerContext;
import gov.cms.fiss.pricers.ltch.core.Ltch2023PricerContext;
import gov.cms.fiss.pricers.ltch.core.Ltch2024PricerContext;
import gov.cms.fiss.pricers.ltch.core.Ltch2025PricerContext;
import gov.cms.fiss.pricers.ltch.core.LtchPricerDispatch;
import gov.cms.fiss.pricers.ltch.resources.InpatientDrgEntryResource;
import gov.cms.fiss.pricers.ltch.resources.LtchClaimPricingResource;
import gov.cms.fiss.pricers.ltch.resources.LtchDrgEntryResource;
import gov.cms.fiss.pricers.ltch.resources.LtchExtractionUtil;
import io.dropwizard.core.setup.Environment;
import io.swagger.v3.oas.models.info.Info;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class LtchPricerApplication extends OpenApiPricerApplication<LtchPricerConfiguration> {
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(LtchPricerApplication.class);

  public static void main(String[] args) throws Exception {
    new LtchPricerApplication().run(args);
  }

  @Override
  protected void configureApplication(LtchPricerConfiguration pricerConfiguration, Environment environment) {
    final LtchClaimPricingResource v2Resource = new LtchClaimPricingResource(new LtchPricerDispatch(pricerConfiguration));
    environment.jersey().register(v2Resource);
    environment.jersey().register(new InpatientDrgEntryResource(pricerConfiguration));
    environment.jersey().register(new LtchDrgEntryResource(pricerConfiguration));
    environment.jersey().register(new CbsaWageIndexResource(pricerConfiguration, LtchExtractionUtil.CBSA_EXTRACTOR));
  }

  @Override
  protected List<OpenApiCustomizer> getContractCustomizers() {
    final List<OpenApiCustomizer> customizers = new ArrayList<>(super.getContractCustomizers());
    customizers.add((configuration, environment, oas) -> oas.info(new Info().title("LTCH Pricer").version("v1")));
    return customizers;
  }

  @Override
  public String getName() {
    return "ltch-pricer";
  }

  @Override
  protected List<Package> getResourcePackages() {
    return Collections.singletonList(LtchClaimPricingResource.class.getPackage());
  }

  @Override
  protected Map<Integer, String> getCalculationVersions() {
    return Map.of(2020, Ltch2020PricerContext.CALCULATION_VERSION_2020, 2021, Ltch2021PricerContext.CALCULATION_VERSION_2021, 2022, Ltch2022PricerContext.CALCULATION_VERSION_2022, 2023, Ltch2023PricerContext.CALCULATION_VERSION_2023, 2024, Ltch2024PricerContext.CALCULATION_VERSION_2024, 2025, Ltch2025PricerContext.CALCULATION_VERSION_2025);
  }
}
