// Generated by delombok at Thu Sep 11 13:52:26 UTC 2025
package gov.cms.fiss.pricers.ltch.core.rules;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.ltch.api.v2.LtchClaimPricingRequest;
import gov.cms.fiss.pricers.ltch.api.v2.LtchClaimPricingResponse;
import gov.cms.fiss.pricers.ltch.api.v2.LtchPaymentData;
import gov.cms.fiss.pricers.ltch.core.LtchPricerContext;
import gov.cms.fiss.pricers.ltch.core.codes.ErrorCode;
import gov.cms.fiss.pricers.ltch.core.codes.PaymentType;
import gov.cms.fiss.pricers.ltch.core.codes.SecondaryPaymentTypeSiteNeutral;
import gov.cms.fiss.pricers.ltch.core.codes.SecondaryPaymentTypeStandard;
import java.math.BigDecimal;
import java.math.RoundingMode;

/**
 * Calculates the high-cost outlier.
 *
 * <pre>
 * ***************************************************************
 * *   CALCULATE THE OUTLIER THRESHOLD                           *
 * *   CALCULATE THE OUTLIER PAYMENT AMOUNT IF THE FACILTY COST  *
 * *     IS GREATER THAN THE OUTLIER THRESHOLD                   *
 * *   SET RETURN CODE                                           *
 * *   CALCULATE THE CHARGE THRESHOLD IF APPLICABLE              *
 * ***************************************************************
 * </pre>
 *
 * <p>Converted from {@code 6000-CALC-HIGH-COST-OUTLIER} in the COBOL code.
 */
public class CalculateHighCostOutlier implements CalculationRule<LtchClaimPricingRequest, LtchClaimPricingResponse, LtchPricerContext> {
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(CalculateHighCostOutlier.class);

  @Override
  public void calculate(LtchPricerContext calculationContext) {
    final LtchPaymentData paymentData = calculationContext.getPaymentData();
    final PaymentType paymentType = calculationContext.getPaymentType();
    final SecondaryPaymentTypeStandard secondaryPaymentTypeStandard = calculationContext.getSecondaryPaymentTypeStandard();
    final SecondaryPaymentTypeSiteNeutral secondaryPaymentTypeSiteNeutral = calculationContext.getSecondaryPaymentTypeSiteNeutral();
    // IF NOT OLD-ERROR-CODE AND NOT NEW-ERROR-CODE
    if (isOutlierAndIsNotErrorCode(calculationContext)) {
      // *-------------------------------------------------------------*
      // * FOR NON-BLENDED PAYMENT CLAIMS:                             *
      // *-------------------------------------------------------------*
      // * - DETERMINE WHICH PAYMENT TO USE TO CALC OUTLIER THRESHOLD  *
      // *   BASED ON CLAIMS'S PAYMENT TYPE & PAYMENT FIELD VALUES     *
      // * - CALCULATE OUTLIER THRESHOLD                               *
      // *-------------------------------------------------------------*
      // IF PMT-STANDARD-OLD
      if (paymentType.equals(PaymentType.STANDARD_OLD)) {
        // COMPUTE PPS-OUTLIER-THRESHOLD ROUNDED =
        //                PPS-DRG-ADJ-PAY-AMT + H-FIXED-LOSS-AMT-STD
        paymentData.setOutlierThresholdAmount(paymentData.getAdjustedPayment().add(calculationContext.getFixedLossAmountStandard()));
      }
      // IF PMT-STANDARD-NEW
      if (paymentType.equals(PaymentType.STANDARD_NEW)) {
        // IF PMT-STANDARD-FULL
        if (secondaryPaymentTypeStandard.equals(SecondaryPaymentTypeStandard.FULL)) {
          // COMPUTE PPS-OUTLIER-THRESHOLD ROUNDED =
          //                   PPS-STANDARD-FULL-PMT + H-FIXED-LOSS-AMT-STD
          paymentData.setOutlierThresholdAmount(paymentData.getStandardFullPayment().add(calculationContext.getFixedLossAmountStandard()));
        } else {
          // COMPUTE PPS-OUTLIER-THRESHOLD ROUNDED =
          //                   PPS-STANDARD-SSO-PMT + H-FIXED-LOSS-AMT-STD
          paymentData.setOutlierThresholdAmount(paymentData.getStandardShortStayOutlierPayment().add(calculationContext.getFixedLossAmountStandard()));
        }
      }
      // IF PMT-SITE-NEUTRAL AND PMT-SITE-NEUT-IPPS
      if (paymentType.equals(PaymentType.SITE_NEUTRAL) && secondaryPaymentTypeSiteNeutral.equals(SecondaryPaymentTypeSiteNeutral.IPPS)) {
        // COMPUTE PPS-OUTLIER-THRESHOLD ROUNDED =
        //                PPS-SITE-NEUTRAL-IPPS-PMT + H-FIXED-LOSS-AMT-SNT
        paymentData.setOutlierThresholdAmount(paymentData.getSiteNeutralIppsPayment().add(calculationContext.getFixedLossAmountSiteNeutral()));
      }
      // *-------------------------------------------------------------*
      // * CALCULATE HIGH-COST OUTLIER IF COSTS EXCEED THRESHOLD       *
      // *-------------------------------------------------------------*
      // IF NOT PMT-BLEND AND
      //   NOT (PMT-SITE-NEUTRAL AND PMT-SITE-NEUT-COST)
      //   IF PPS-FAC-COSTS > PPS-OUTLIER-THRESHOLD
      if (isNonBlendNonSiteNeutralCostPayment(paymentData, paymentType, secondaryPaymentTypeSiteNeutral)) {
        // COMPUTE PPS-OUTLIER-PAY-AMT ROUNDED =
        //                   (PPS-FAC-COSTS - PPS-OUTLIER-THRESHOLD) * .8
        paymentData.setOutlierPayment(new BigDecimal("0.8").multiply(paymentData.getFacilityCosts().subtract(paymentData.getOutlierThresholdAmount())).setScale(2, RoundingMode.HALF_UP));
      }
    }
  }

  private boolean isNonBlendNonSiteNeutralCostPayment(LtchPaymentData paymentData, PaymentType paymentType, SecondaryPaymentTypeSiteNeutral secondaryPaymentTypeSiteNeutral) {
    // IF NOT PMT-BLEND AND
    //   NOT (PMT-SITE-NEUTRAL AND PMT-SITE-NEUT-COST)
    //   IF PPS-FAC-COSTS > PPS-OUTLIER-THRESHOLD
    return !paymentType.equals(PaymentType.BLEND) && !(paymentType.equals(PaymentType.SITE_NEUTRAL) && secondaryPaymentTypeSiteNeutral.equals(SecondaryPaymentTypeSiteNeutral.COST)) && BigDecimalUtils.isGreaterThan(paymentData.getFacilityCosts(), paymentData.getOutlierThresholdAmount());
  }

  private boolean isOutlierAndIsNotErrorCode(LtchPricerContext calculationContext) {
    return 
    // IF NOT OLD-ERROR-CODE AND NOT NEW-ERROR-CODE
    calculationContext.getCalculateOutliers() && ErrorCode.isNotNewCodeAndNotOldCode(calculationContext.getReturnCode());
  }
}
