/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.common.application;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.dropwizard.configuration.ConfigurationSourceProvider;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class MergingConfigurationSourceProvider
implements ConfigurationSourceProvider {
    private final ConfigurationSourceProvider defaultSourceProvider;
    private final ConfigurationSourceProvider applicationSourceProvider;
    private final String defaultPath;
    private final JsonFactory parserFactory;
    private final ObjectMapper objectMapper;

    public MergingConfigurationSourceProvider(ConfigurationSourceProvider defaultSourceProvider, String defaultPath, ConfigurationSourceProvider applicationSourceProvider, JsonFactory parserFactory, ObjectMapper objectMapper) {
        this.defaultSourceProvider = defaultSourceProvider;
        this.defaultPath = defaultPath;
        this.applicationSourceProvider = applicationSourceProvider;
        this.parserFactory = parserFactory;
        this.objectMapper = objectMapper.copy();
    }

    @Override
    public InputStream open(String path) throws IOException {
        ObjectNode mergedConfiguration = this.convertConfiguration(this.defaultSourceProvider.open(this.defaultPath));
        ObjectNode applicationConfiguration = this.convertConfiguration(this.applicationSourceProvider.open(path));
        this.objectMapper.readerForUpdating(mergedConfiguration).readValue(applicationConfiguration);
        return new ByteArrayInputStream(this.objectMapper.writeValueAsBytes(mergedConfiguration));
    }

    protected ObjectNode convertConfiguration(InputStream input) throws IOException {
        JsonParser parser = this.parserFactory.createParser(input);
        return (ObjectNode)this.objectMapper.readTree(parser);
    }
}

