/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ltch.core;

import com.fasterxml.jackson.annotation.JsonIgnore;
import gov.cms.fiss.pricers.common.api.InpatientProviderData;
import gov.cms.fiss.pricers.common.api.ReturnCodeData;
import gov.cms.fiss.pricers.common.api.annotations.FixedValue;
import gov.cms.fiss.pricers.common.application.rules.CalculationContext;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.ltch.api.v2.LtchClaimData;
import gov.cms.fiss.pricers.ltch.api.v2.LtchClaimPricingRequest;
import gov.cms.fiss.pricers.ltch.api.v2.LtchClaimPricingResponse;
import gov.cms.fiss.pricers.ltch.api.v2.LtchPaymentData;
import gov.cms.fiss.pricers.ltch.core.codes.CbsaProviderType;
import gov.cms.fiss.pricers.ltch.core.codes.PaymentType;
import gov.cms.fiss.pricers.ltch.core.codes.ReturnCode;
import gov.cms.fiss.pricers.ltch.core.codes.SecondaryPaymentTypeSiteNeutral;
import gov.cms.fiss.pricers.ltch.core.codes.SecondaryPaymentTypeStandard;
import gov.cms.fiss.pricers.ltch.core.models.LtchWageIndexTableEntry;
import gov.cms.fiss.pricers.ltch.core.tables.CbsaWageIndexEntry;
import gov.cms.fiss.pricers.ltch.core.tables.DataTables;
import gov.cms.fiss.pricers.ltch.core.tables.WageIppsIndexRuralEntry;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public abstract class LtchPricerContext
extends CalculationContext<LtchClaimPricingRequest, LtchClaimPricingResponse> {
    private static final EnumSet<PaymentType> STANDARD_OR_BLEND_TYPES = EnumSet.of(PaymentType.STANDARD_NEW, PaymentType.STANDARD_OLD, PaymentType.BLEND);
    private static final EnumSet<PaymentType> STANDARD_NEW_SITE_NEUTRAL_OR_BLEND_TYPES = EnumSet.of(PaymentType.STANDARD_NEW, PaymentType.SITE_NEUTRAL, PaymentType.BLEND);
    private static final LocalDate PUBLIC_HEALTH_EMERGENCY_LAST_DAY = LocalDate.of(2023, 5, 11);
    private static final List<String> PSYCH_REHAB_DRUGS = Arrays.asList("876", "880", "881", "882", "883", "884", "885", "887", "886", "894", "895", "896", "897", "945", "946");
    @JsonIgnore
    private final DataTables dataTables;
    private WageIppsIndexRuralEntry wageIndexFloor = WageIppsIndexRuralEntry.DEFAULT.build();
    private LtchWageIndexTableEntry ltchWageIndexTableEntry = new LtchWageIndexTableEntry();
    @FixedValue
    private BigDecimal holdLaborPortionRounded;
    @FixedValue
    private BigDecimal holdNonLaborPortionRounded;
    @FixedValue
    private BigDecimal holdBudgetNeutralFactor = new BigDecimal("0.949").setScale(6, RoundingMode.HALF_UP);
    @FixedValue
    private BigDecimal holdSiteNeutralIppsAdj = new BigDecimal("0.954").setScale(6, RoundingMode.HALF_UP);
    private Boolean pcPricer = false;
    private Boolean ippsComparablePayment = false;
    private Boolean calculateOutliers = false;
    private String ventilationIcd10Code = "5A1955Z";
    protected String calculationVersion;
    BigDecimal holdLtchBlendPercentage;
    private PaymentType paymentType;
    private CbsaWageIndexEntry ruralWageIndexFloor;
    private CbsaWageIndexEntry imputedWageIndexFloor;
    private LocalDate fyBegin;
    private LocalDate fyEnd;
    private LtchPaymentData paymentData;
    private WageIppsIndexRuralEntry holdProvIppsCbsaRural;
    private CbsaWageIndexEntry holdProvIppsCBSA;
    private BigDecimal holdCapitalTeachingAdjustmentRatio;
    private BigDecimal holdOperatingDshPercent;
    private BigDecimal holdBedSize;
    private BigDecimal holdOperatingDshAmount;
    private BigDecimal holdIppsWageIndex;
    @FixedValue
    private BigDecimal holdIppsNationalLaborShare;
    private BigDecimal holdStandardAmountOperatingPayment;
    private BigDecimal holdIppsNationalNonLaborShare;
    private BigDecimal holdIppsDrgWeight;
    private BigDecimal holdCapitalCola;
    private BigDecimal holdCapitalGeographicAreaFactor;
    private BigDecimal holdCapitalPayment;
    private BigDecimal holdCapitalImeTeach;
    private BigDecimal holdCapitalDsh;
    private BigDecimal holdIppsPayAmount;
    private BigDecimal holdIppsDrgALengthOfStay;
    private BigDecimal holdIppsArithALengthOfStay;
    private BigDecimal holdLengthOfStay;
    private BigDecimal holdIppsPerDiem;
    private BigDecimal holdShortStayOutlierThreshold;
    private BigDecimal holdLtchBlendAmount;
    private BigDecimal holdShortStayPayAmount;
    private BigDecimal holdIppsBlendPercentage;
    private BigDecimal holdIppsBlendAmount;
    private BigDecimal holdShortStayBlendedPayment;
    private BigDecimal holdOutlierThresholdStandard;
    private BigDecimal holdOutlierPayAmountStandard = BigDecimal.ZERO;
    private BigDecimal holdOutlierPayAmountSiteNeutral = BigDecimal.ZERO;
    private BigDecimal holdOutlierIppsComparable;
    private BigDecimal holdSnCostComparison;
    private BigDecimal holdSnIppsComparison;
    @FixedValue
    private BigDecimal holdBlendStandard;
    @FixedValue
    private BigDecimal holdBlendSiteNeutral;
    private String holdShortStayBlendIndicator;
    private String holdShortStayCostIndicator;
    private String holdShortStayPerDiemIndicator;
    private String holdShortStayIppsCompIndicator;
    private BigDecimal holdBlendRtc;
    private BigDecimal holdLargeUrbanAddon;
    private int holdRegularDays;
    private int holdTotalDays;
    private LocalDate holdAdmissionDate;
    private LocalDate holdDischargeDate;
    private BigDecimal holdIPPSLikeAmt;
    private BigDecimal holdIPPSOutlier = BigDecimal.ZERO;
    private BigDecimal holdPreDPPPay;
    private SecondaryPaymentTypeStandard secondaryPaymentTypeStandard;
    private SecondaryPaymentTypeSiteNeutral secondaryPaymentTypeSiteNeutral;
    private String returnCodePart1;
    private String returnCodePart2;

    protected LtchPricerContext(LtchClaimPricingRequest input, LtchClaimPricingResponse output, DataTables dataTables) {
        super(input, output);
        this.dataTables = dataTables;
        this.paymentData = (LtchPaymentData)((LtchClaimPricingResponse)this.getOutput()).getPaymentData();
        this.initialize();
    }

    private void initialize() {
        ((LtchClaimPricingResponse)this.getOutput()).setReturnCodeData(new ReturnCodeData());
        ((LtchClaimPricingResponse)this.getOutput()).getReturnCodeData().setCode("00");
        ((LtchPaymentData)((LtchClaimPricingResponse)this.getOutput()).getPaymentData()).setTotalPayment(BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP));
    }

    public LtchClaimData getClaimData() {
        return (LtchClaimData)((LtchClaimPricingRequest)this.getInput()).getClaimData();
    }

    public InpatientProviderData getProviderData() {
        return (InpatientProviderData)((LtchClaimPricingRequest)this.getInput()).getProviderData();
    }

    public String getReturnCode() {
        return ((LtchClaimPricingResponse)this.getOutput()).getReturnCodeData().getCode();
    }

    public boolean isPsychRehabDrg() {
        return PSYCH_REHAB_DRUGS.contains(this.getPaymentData().getSubmittedDiagnosisRelatedGroup());
    }

    public void applyReturnCode(ReturnCode code) {
        ((LtchClaimPricingResponse)this.getOutput()).setReturnCodeData(code.toReturnCodeData());
    }

    public void applyReturnCodeFromTwoPartCode() {
        ReturnCode code = ReturnCode.fromCode(this.returnCodePart1 + this.returnCodePart2);
        if (code != null) {
            this.applyReturnCode(code);
        }
    }

    public Integer getReviewCodeAsInt() {
        return Integer.parseInt(this.getClaimData().getReviewCode());
    }

    public boolean isSpecialPaymentIndicatorEmpty(String specialPaymentIndicator) {
        return StringUtils.isEmpty(specialPaymentIndicator) || "0".equals(specialPaymentIndicator);
    }

    public boolean isSpecialPaymentIndicatorSpecial(String specialPaymentIndicator) {
        return !this.isSpecialPaymentIndicatorEmpty(specialPaymentIndicator) && StringUtils.equalsAny(specialPaymentIndicator, "1", "2");
    }

    public boolean isPaymentBlendOrSiteNeutral() {
        return this.paymentType == PaymentType.BLEND || this.paymentType == PaymentType.SITE_NEUTRAL;
    }

    public boolean isPaymentStandardNewSiteNeutralOrBlendTypes() {
        return STANDARD_NEW_SITE_NEUTRAL_OR_BLEND_TYPES.contains((Object)this.paymentType);
    }

    public boolean isPaymentStandardOrBlend() {
        return STANDARD_OR_BLEND_TYPES.contains((Object)this.paymentType);
    }

    public LocalDate getPublicHealthEmergencyLastDay() {
        return PUBLIC_HEALTH_EMERGENCY_LAST_DAY;
    }

    public String getSupplementalWageIndexIndicator() {
        return this.getProviderData().getSupplementalWageIndexIndicator();
    }

    public BigDecimal getSupplementalWageIndex() {
        return this.getProviderData().getSupplementalWageIndex();
    }

    public CbsaProviderType getCbsaProviderType() {
        switch (this.getHoldProvIppsCBSA().getSize()) {
            case "R": {
                return CbsaProviderType.RURAL;
            }
        }
        return CbsaProviderType.URBAN;
    }

    public abstract @FixedValue BigDecimal getStandardQualityFedRate();

    public abstract @FixedValue BigDecimal getStandardFedRate();

    public abstract @FixedValue BigDecimal getNationalLaborPercent();

    public abstract @FixedValue BigDecimal getNationalNonLaborPercent();

    public abstract @FixedValue BigDecimal getHighIppsNationalLaborShare();

    public abstract @FixedValue BigDecimal getLowIppsNationalLaborShare();

    public abstract @FixedValue BigDecimal getHighIppsNationalNonLaborShare();

    public abstract @FixedValue BigDecimal getLowIppsNationalNonLaborShare();

    public abstract @FixedValue BigDecimal getFixedLossAmountStandard();

    public abstract @FixedValue BigDecimal getFixedLossAmountSiteNeutral();

    public abstract @FixedValue BigDecimal getOperatingDshReductionFactor();

    public abstract @FixedValue BigDecimal getIppsCapitalStandardFedRate();

    public boolean isStandardPaymentNew() {
        LtchClaimData claimData = this.getClaimData();
        return StringUtils.equals(claimData.getReviewCode(), "01") && !this.isPsychRehabDrg() || StringUtils.equalsAny(claimData.getReviewCode(), "04", "05");
    }

    public void calculateIppsLaborShares() {
        CbsaWageIndexEntry entry = this.getHoldProvIppsCBSA();
        if (entry != null && BigDecimalUtils.isGreaterThan(entry.getGeographicWageIndex(), BigDecimal.ONE)) {
            this.setHoldIppsNationalLaborShare(this.getHighIppsNationalLaborShare());
            this.setHoldIppsNationalNonLaborShare(this.getHighIppsNationalNonLaborShare());
        } else {
            this.setHoldIppsNationalLaborShare(this.getLowIppsNationalLaborShare());
            this.setHoldIppsNationalNonLaborShare(this.getLowIppsNationalNonLaborShare());
        }
    }

    @Generated
    public DataTables getDataTables() {
        return this.dataTables;
    }

    @Generated
    public WageIppsIndexRuralEntry getWageIndexFloor() {
        return this.wageIndexFloor;
    }

    @Generated
    public LtchWageIndexTableEntry getLtchWageIndexTableEntry() {
        return this.ltchWageIndexTableEntry;
    }

    @Generated
    public BigDecimal getHoldLaborPortionRounded() {
        return this.holdLaborPortionRounded;
    }

    @Generated
    public BigDecimal getHoldNonLaborPortionRounded() {
        return this.holdNonLaborPortionRounded;
    }

    @Generated
    public BigDecimal getHoldBudgetNeutralFactor() {
        return this.holdBudgetNeutralFactor;
    }

    @Generated
    public BigDecimal getHoldSiteNeutralIppsAdj() {
        return this.holdSiteNeutralIppsAdj;
    }

    @Generated
    public Boolean getPcPricer() {
        return this.pcPricer;
    }

    @Generated
    public Boolean getIppsComparablePayment() {
        return this.ippsComparablePayment;
    }

    @Generated
    public Boolean getCalculateOutliers() {
        return this.calculateOutliers;
    }

    @Generated
    public String getVentilationIcd10Code() {
        return this.ventilationIcd10Code;
    }

    @Generated
    public String getCalculationVersion() {
        return this.calculationVersion;
    }

    @Generated
    public BigDecimal getHoldLtchBlendPercentage() {
        return this.holdLtchBlendPercentage;
    }

    @Generated
    public PaymentType getPaymentType() {
        return this.paymentType;
    }

    @Generated
    public CbsaWageIndexEntry getRuralWageIndexFloor() {
        return this.ruralWageIndexFloor;
    }

    @Generated
    public CbsaWageIndexEntry getImputedWageIndexFloor() {
        return this.imputedWageIndexFloor;
    }

    @Generated
    public LocalDate getFyBegin() {
        return this.fyBegin;
    }

    @Generated
    public LocalDate getFyEnd() {
        return this.fyEnd;
    }

    @Generated
    public LtchPaymentData getPaymentData() {
        return this.paymentData;
    }

    @Generated
    public WageIppsIndexRuralEntry getHoldProvIppsCbsaRural() {
        return this.holdProvIppsCbsaRural;
    }

    @Generated
    public CbsaWageIndexEntry getHoldProvIppsCBSA() {
        return this.holdProvIppsCBSA;
    }

    @Generated
    public BigDecimal getHoldCapitalTeachingAdjustmentRatio() {
        return this.holdCapitalTeachingAdjustmentRatio;
    }

    @Generated
    public BigDecimal getHoldOperatingDshPercent() {
        return this.holdOperatingDshPercent;
    }

    @Generated
    public BigDecimal getHoldBedSize() {
        return this.holdBedSize;
    }

    @Generated
    public BigDecimal getHoldOperatingDshAmount() {
        return this.holdOperatingDshAmount;
    }

    @Generated
    public BigDecimal getHoldIppsWageIndex() {
        return this.holdIppsWageIndex;
    }

    @Generated
    public BigDecimal getHoldIppsNationalLaborShare() {
        return this.holdIppsNationalLaborShare;
    }

    @Generated
    public BigDecimal getHoldStandardAmountOperatingPayment() {
        return this.holdStandardAmountOperatingPayment;
    }

    @Generated
    public BigDecimal getHoldIppsNationalNonLaborShare() {
        return this.holdIppsNationalNonLaborShare;
    }

    @Generated
    public BigDecimal getHoldIppsDrgWeight() {
        return this.holdIppsDrgWeight;
    }

    @Generated
    public BigDecimal getHoldCapitalCola() {
        return this.holdCapitalCola;
    }

    @Generated
    public BigDecimal getHoldCapitalGeographicAreaFactor() {
        return this.holdCapitalGeographicAreaFactor;
    }

    @Generated
    public BigDecimal getHoldCapitalPayment() {
        return this.holdCapitalPayment;
    }

    @Generated
    public BigDecimal getHoldCapitalImeTeach() {
        return this.holdCapitalImeTeach;
    }

    @Generated
    public BigDecimal getHoldCapitalDsh() {
        return this.holdCapitalDsh;
    }

    @Generated
    public BigDecimal getHoldIppsPayAmount() {
        return this.holdIppsPayAmount;
    }

    @Generated
    public BigDecimal getHoldIppsDrgALengthOfStay() {
        return this.holdIppsDrgALengthOfStay;
    }

    @Generated
    public BigDecimal getHoldIppsArithALengthOfStay() {
        return this.holdIppsArithALengthOfStay;
    }

    @Generated
    public BigDecimal getHoldLengthOfStay() {
        return this.holdLengthOfStay;
    }

    @Generated
    public BigDecimal getHoldIppsPerDiem() {
        return this.holdIppsPerDiem;
    }

    @Generated
    public BigDecimal getHoldShortStayOutlierThreshold() {
        return this.holdShortStayOutlierThreshold;
    }

    @Generated
    public BigDecimal getHoldLtchBlendAmount() {
        return this.holdLtchBlendAmount;
    }

    @Generated
    public BigDecimal getHoldShortStayPayAmount() {
        return this.holdShortStayPayAmount;
    }

    @Generated
    public BigDecimal getHoldIppsBlendPercentage() {
        return this.holdIppsBlendPercentage;
    }

    @Generated
    public BigDecimal getHoldIppsBlendAmount() {
        return this.holdIppsBlendAmount;
    }

    @Generated
    public BigDecimal getHoldShortStayBlendedPayment() {
        return this.holdShortStayBlendedPayment;
    }

    @Generated
    public BigDecimal getHoldOutlierThresholdStandard() {
        return this.holdOutlierThresholdStandard;
    }

    @Generated
    public BigDecimal getHoldOutlierPayAmountStandard() {
        return this.holdOutlierPayAmountStandard;
    }

    @Generated
    public BigDecimal getHoldOutlierPayAmountSiteNeutral() {
        return this.holdOutlierPayAmountSiteNeutral;
    }

    @Generated
    public BigDecimal getHoldOutlierIppsComparable() {
        return this.holdOutlierIppsComparable;
    }

    @Generated
    public BigDecimal getHoldSnCostComparison() {
        return this.holdSnCostComparison;
    }

    @Generated
    public BigDecimal getHoldSnIppsComparison() {
        return this.holdSnIppsComparison;
    }

    @Generated
    public BigDecimal getHoldBlendStandard() {
        return this.holdBlendStandard;
    }

    @Generated
    public BigDecimal getHoldBlendSiteNeutral() {
        return this.holdBlendSiteNeutral;
    }

    @Generated
    public String getHoldShortStayBlendIndicator() {
        return this.holdShortStayBlendIndicator;
    }

    @Generated
    public String getHoldShortStayCostIndicator() {
        return this.holdShortStayCostIndicator;
    }

    @Generated
    public String getHoldShortStayPerDiemIndicator() {
        return this.holdShortStayPerDiemIndicator;
    }

    @Generated
    public String getHoldShortStayIppsCompIndicator() {
        return this.holdShortStayIppsCompIndicator;
    }

    @Generated
    public BigDecimal getHoldBlendRtc() {
        return this.holdBlendRtc;
    }

    @Generated
    public BigDecimal getHoldLargeUrbanAddon() {
        return this.holdLargeUrbanAddon;
    }

    @Generated
    public int getHoldRegularDays() {
        return this.holdRegularDays;
    }

    @Generated
    public int getHoldTotalDays() {
        return this.holdTotalDays;
    }

    @Generated
    public LocalDate getHoldAdmissionDate() {
        return this.holdAdmissionDate;
    }

    @Generated
    public LocalDate getHoldDischargeDate() {
        return this.holdDischargeDate;
    }

    @Generated
    public BigDecimal getHoldIPPSLikeAmt() {
        return this.holdIPPSLikeAmt;
    }

    @Generated
    public BigDecimal getHoldIPPSOutlier() {
        return this.holdIPPSOutlier;
    }

    @Generated
    public BigDecimal getHoldPreDPPPay() {
        return this.holdPreDPPPay;
    }

    @Generated
    public SecondaryPaymentTypeStandard getSecondaryPaymentTypeStandard() {
        return this.secondaryPaymentTypeStandard;
    }

    @Generated
    public SecondaryPaymentTypeSiteNeutral getSecondaryPaymentTypeSiteNeutral() {
        return this.secondaryPaymentTypeSiteNeutral;
    }

    @Generated
    public String getReturnCodePart1() {
        return this.returnCodePart1;
    }

    @Generated
    public String getReturnCodePart2() {
        return this.returnCodePart2;
    }

    @Generated
    public void setWageIndexFloor(WageIppsIndexRuralEntry wageIndexFloor) {
        this.wageIndexFloor = wageIndexFloor;
    }

    @Generated
    public void setLtchWageIndexTableEntry(LtchWageIndexTableEntry ltchWageIndexTableEntry) {
        this.ltchWageIndexTableEntry = ltchWageIndexTableEntry;
    }

    @Generated
    public void setHoldLaborPortionRounded(BigDecimal holdLaborPortionRounded) {
        this.holdLaborPortionRounded = holdLaborPortionRounded;
    }

    @Generated
    public void setHoldNonLaborPortionRounded(BigDecimal holdNonLaborPortionRounded) {
        this.holdNonLaborPortionRounded = holdNonLaborPortionRounded;
    }

    @Generated
    public void setHoldBudgetNeutralFactor(BigDecimal holdBudgetNeutralFactor) {
        this.holdBudgetNeutralFactor = holdBudgetNeutralFactor;
    }

    @Generated
    public void setHoldSiteNeutralIppsAdj(BigDecimal holdSiteNeutralIppsAdj) {
        this.holdSiteNeutralIppsAdj = holdSiteNeutralIppsAdj;
    }

    @Generated
    public void setPcPricer(Boolean pcPricer) {
        this.pcPricer = pcPricer;
    }

    @Generated
    public void setIppsComparablePayment(Boolean ippsComparablePayment) {
        this.ippsComparablePayment = ippsComparablePayment;
    }

    @Generated
    public void setCalculateOutliers(Boolean calculateOutliers) {
        this.calculateOutliers = calculateOutliers;
    }

    @Generated
    public void setVentilationIcd10Code(String ventilationIcd10Code) {
        this.ventilationIcd10Code = ventilationIcd10Code;
    }

    @Generated
    public void setCalculationVersion(String calculationVersion) {
        this.calculationVersion = calculationVersion;
    }

    @Generated
    public void setHoldLtchBlendPercentage(BigDecimal holdLtchBlendPercentage) {
        this.holdLtchBlendPercentage = holdLtchBlendPercentage;
    }

    @Generated
    public void setPaymentType(PaymentType paymentType) {
        this.paymentType = paymentType;
    }

    @Generated
    public void setRuralWageIndexFloor(CbsaWageIndexEntry ruralWageIndexFloor) {
        this.ruralWageIndexFloor = ruralWageIndexFloor;
    }

    @Generated
    public void setImputedWageIndexFloor(CbsaWageIndexEntry imputedWageIndexFloor) {
        this.imputedWageIndexFloor = imputedWageIndexFloor;
    }

    @Generated
    public void setFyBegin(LocalDate fyBegin) {
        this.fyBegin = fyBegin;
    }

    @Generated
    public void setFyEnd(LocalDate fyEnd) {
        this.fyEnd = fyEnd;
    }

    @Generated
    public void setPaymentData(LtchPaymentData paymentData) {
        this.paymentData = paymentData;
    }

    @Generated
    public void setHoldProvIppsCbsaRural(WageIppsIndexRuralEntry holdProvIppsCbsaRural) {
        this.holdProvIppsCbsaRural = holdProvIppsCbsaRural;
    }

    @Generated
    public void setHoldProvIppsCBSA(CbsaWageIndexEntry holdProvIppsCBSA) {
        this.holdProvIppsCBSA = holdProvIppsCBSA;
    }

    @Generated
    public void setHoldCapitalTeachingAdjustmentRatio(BigDecimal holdCapitalTeachingAdjustmentRatio) {
        this.holdCapitalTeachingAdjustmentRatio = holdCapitalTeachingAdjustmentRatio;
    }

    @Generated
    public void setHoldOperatingDshPercent(BigDecimal holdOperatingDshPercent) {
        this.holdOperatingDshPercent = holdOperatingDshPercent;
    }

    @Generated
    public void setHoldBedSize(BigDecimal holdBedSize) {
        this.holdBedSize = holdBedSize;
    }

    @Generated
    public void setHoldOperatingDshAmount(BigDecimal holdOperatingDshAmount) {
        this.holdOperatingDshAmount = holdOperatingDshAmount;
    }

    @Generated
    public void setHoldIppsWageIndex(BigDecimal holdIppsWageIndex) {
        this.holdIppsWageIndex = holdIppsWageIndex;
    }

    @Generated
    public void setHoldIppsNationalLaborShare(BigDecimal holdIppsNationalLaborShare) {
        this.holdIppsNationalLaborShare = holdIppsNationalLaborShare;
    }

    @Generated
    public void setHoldStandardAmountOperatingPayment(BigDecimal holdStandardAmountOperatingPayment) {
        this.holdStandardAmountOperatingPayment = holdStandardAmountOperatingPayment;
    }

    @Generated
    public void setHoldIppsNationalNonLaborShare(BigDecimal holdIppsNationalNonLaborShare) {
        this.holdIppsNationalNonLaborShare = holdIppsNationalNonLaborShare;
    }

    @Generated
    public void setHoldIppsDrgWeight(BigDecimal holdIppsDrgWeight) {
        this.holdIppsDrgWeight = holdIppsDrgWeight;
    }

    @Generated
    public void setHoldCapitalCola(BigDecimal holdCapitalCola) {
        this.holdCapitalCola = holdCapitalCola;
    }

    @Generated
    public void setHoldCapitalGeographicAreaFactor(BigDecimal holdCapitalGeographicAreaFactor) {
        this.holdCapitalGeographicAreaFactor = holdCapitalGeographicAreaFactor;
    }

    @Generated
    public void setHoldCapitalPayment(BigDecimal holdCapitalPayment) {
        this.holdCapitalPayment = holdCapitalPayment;
    }

    @Generated
    public void setHoldCapitalImeTeach(BigDecimal holdCapitalImeTeach) {
        this.holdCapitalImeTeach = holdCapitalImeTeach;
    }

    @Generated
    public void setHoldCapitalDsh(BigDecimal holdCapitalDsh) {
        this.holdCapitalDsh = holdCapitalDsh;
    }

    @Generated
    public void setHoldIppsPayAmount(BigDecimal holdIppsPayAmount) {
        this.holdIppsPayAmount = holdIppsPayAmount;
    }

    @Generated
    public void setHoldIppsDrgALengthOfStay(BigDecimal holdIppsDrgALengthOfStay) {
        this.holdIppsDrgALengthOfStay = holdIppsDrgALengthOfStay;
    }

    @Generated
    public void setHoldIppsArithALengthOfStay(BigDecimal holdIppsArithALengthOfStay) {
        this.holdIppsArithALengthOfStay = holdIppsArithALengthOfStay;
    }

    @Generated
    public void setHoldLengthOfStay(BigDecimal holdLengthOfStay) {
        this.holdLengthOfStay = holdLengthOfStay;
    }

    @Generated
    public void setHoldIppsPerDiem(BigDecimal holdIppsPerDiem) {
        this.holdIppsPerDiem = holdIppsPerDiem;
    }

    @Generated
    public void setHoldShortStayOutlierThreshold(BigDecimal holdShortStayOutlierThreshold) {
        this.holdShortStayOutlierThreshold = holdShortStayOutlierThreshold;
    }

    @Generated
    public void setHoldLtchBlendAmount(BigDecimal holdLtchBlendAmount) {
        this.holdLtchBlendAmount = holdLtchBlendAmount;
    }

    @Generated
    public void setHoldShortStayPayAmount(BigDecimal holdShortStayPayAmount) {
        this.holdShortStayPayAmount = holdShortStayPayAmount;
    }

    @Generated
    public void setHoldIppsBlendPercentage(BigDecimal holdIppsBlendPercentage) {
        this.holdIppsBlendPercentage = holdIppsBlendPercentage;
    }

    @Generated
    public void setHoldIppsBlendAmount(BigDecimal holdIppsBlendAmount) {
        this.holdIppsBlendAmount = holdIppsBlendAmount;
    }

    @Generated
    public void setHoldShortStayBlendedPayment(BigDecimal holdShortStayBlendedPayment) {
        this.holdShortStayBlendedPayment = holdShortStayBlendedPayment;
    }

    @Generated
    public void setHoldOutlierThresholdStandard(BigDecimal holdOutlierThresholdStandard) {
        this.holdOutlierThresholdStandard = holdOutlierThresholdStandard;
    }

    @Generated
    public void setHoldOutlierPayAmountStandard(BigDecimal holdOutlierPayAmountStandard) {
        this.holdOutlierPayAmountStandard = holdOutlierPayAmountStandard;
    }

    @Generated
    public void setHoldOutlierPayAmountSiteNeutral(BigDecimal holdOutlierPayAmountSiteNeutral) {
        this.holdOutlierPayAmountSiteNeutral = holdOutlierPayAmountSiteNeutral;
    }

    @Generated
    public void setHoldOutlierIppsComparable(BigDecimal holdOutlierIppsComparable) {
        this.holdOutlierIppsComparable = holdOutlierIppsComparable;
    }

    @Generated
    public void setHoldSnCostComparison(BigDecimal holdSnCostComparison) {
        this.holdSnCostComparison = holdSnCostComparison;
    }

    @Generated
    public void setHoldSnIppsComparison(BigDecimal holdSnIppsComparison) {
        this.holdSnIppsComparison = holdSnIppsComparison;
    }

    @Generated
    public void setHoldBlendStandard(BigDecimal holdBlendStandard) {
        this.holdBlendStandard = holdBlendStandard;
    }

    @Generated
    public void setHoldBlendSiteNeutral(BigDecimal holdBlendSiteNeutral) {
        this.holdBlendSiteNeutral = holdBlendSiteNeutral;
    }

    @Generated
    public void setHoldShortStayBlendIndicator(String holdShortStayBlendIndicator) {
        this.holdShortStayBlendIndicator = holdShortStayBlendIndicator;
    }

    @Generated
    public void setHoldShortStayCostIndicator(String holdShortStayCostIndicator) {
        this.holdShortStayCostIndicator = holdShortStayCostIndicator;
    }

    @Generated
    public void setHoldShortStayPerDiemIndicator(String holdShortStayPerDiemIndicator) {
        this.holdShortStayPerDiemIndicator = holdShortStayPerDiemIndicator;
    }

    @Generated
    public void setHoldShortStayIppsCompIndicator(String holdShortStayIppsCompIndicator) {
        this.holdShortStayIppsCompIndicator = holdShortStayIppsCompIndicator;
    }

    @Generated
    public void setHoldBlendRtc(BigDecimal holdBlendRtc) {
        this.holdBlendRtc = holdBlendRtc;
    }

    @Generated
    public void setHoldLargeUrbanAddon(BigDecimal holdLargeUrbanAddon) {
        this.holdLargeUrbanAddon = holdLargeUrbanAddon;
    }

    @Generated
    public void setHoldRegularDays(int holdRegularDays) {
        this.holdRegularDays = holdRegularDays;
    }

    @Generated
    public void setHoldTotalDays(int holdTotalDays) {
        this.holdTotalDays = holdTotalDays;
    }

    @Generated
    public void setHoldAdmissionDate(LocalDate holdAdmissionDate) {
        this.holdAdmissionDate = holdAdmissionDate;
    }

    @Generated
    public void setHoldDischargeDate(LocalDate holdDischargeDate) {
        this.holdDischargeDate = holdDischargeDate;
    }

    @Generated
    public void setHoldIPPSLikeAmt(BigDecimal holdIPPSLikeAmt) {
        this.holdIPPSLikeAmt = holdIPPSLikeAmt;
    }

    @Generated
    public void setHoldIPPSOutlier(BigDecimal holdIPPSOutlier) {
        this.holdIPPSOutlier = holdIPPSOutlier;
    }

    @Generated
    public void setHoldPreDPPPay(BigDecimal holdPreDPPPay) {
        this.holdPreDPPPay = holdPreDPPPay;
    }

    @Generated
    public void setSecondaryPaymentTypeStandard(SecondaryPaymentTypeStandard secondaryPaymentTypeStandard) {
        this.secondaryPaymentTypeStandard = secondaryPaymentTypeStandard;
    }

    @Generated
    public void setSecondaryPaymentTypeSiteNeutral(SecondaryPaymentTypeSiteNeutral secondaryPaymentTypeSiteNeutral) {
        this.secondaryPaymentTypeSiteNeutral = secondaryPaymentTypeSiteNeutral;
    }

    @Generated
    public void setReturnCodePart1(String returnCodePart1) {
        this.returnCodePart1 = returnCodePart1;
    }

    @Generated
    public void setReturnCodePart2(String returnCodePart2) {
        this.returnCodePart2 = returnCodePart2;
    }
}

