/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ltch.core.rules;

import ch.obermuhlner.math.big.BigDecimalMath;
import gov.cms.fiss.pricers.common.api.InpatientProviderData;
import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.ltch.api.v2.LtchClaimPricingRequest;
import gov.cms.fiss.pricers.ltch.api.v2.LtchClaimPricingResponse;
import gov.cms.fiss.pricers.ltch.core.LtchPricerContext;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;

public class CalculateCapitalRate
implements CalculationRule<LtchClaimPricingRequest, LtchClaimPricingResponse, LtchPricerContext> {
    @Override
    public void calculate(LtchPricerContext calculationContext) {
        InpatientProviderData providerData = calculationContext.getProviderData();
        BigDecimal operatingCola = "02".equals(providerData.getStateCode()) || "12".equals(providerData.getStateCode()) ? providerData.getCostOfLivingAdjustment() : BigDecimal.ONE;
        BigDecimal internRatio = BigDecimalMath.pow(providerData.getInternsToBedsRatio().add(BigDecimal.ONE), new BigDecimal("0.405"), new MathContext(10));
        BigDecimal operatingTeachingAdjustment = new BigDecimal("1.35").multiply(internRatio.subtract(BigDecimal.ONE)).setScale(9, RoundingMode.HALF_UP);
        BigDecimal teachDsh = BigDecimal.ONE.add(operatingTeachingAdjustment).add(calculationContext.getHoldOperatingDshAmount());
        calculationContext.setHoldStandardAmountOperatingPayment(calculationContext.getHoldIppsNationalLaborShare().multiply(calculationContext.getHoldProvIppsCBSA().getGeographicWageIndex()).add(calculationContext.getHoldIppsNationalNonLaborShare().multiply(operatingCola)).multiply(calculationContext.getHoldIppsDrgWeight()).multiply(teachDsh).setScale(2, RoundingMode.HALF_UP));
        calculationContext.setHoldCapitalCola(new BigDecimal("0.3152").multiply(operatingCola.subtract(BigDecimal.ONE)).add(BigDecimal.ONE).setScale(3, RoundingMode.HALF_UP));
    }
}

