/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ltch.core.rules;

import ch.obermuhlner.math.big.BigDecimalMath;
import gov.cms.fiss.pricers.common.api.InpatientProviderData;
import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.ltch.api.v2.LtchClaimPricingRequest;
import gov.cms.fiss.pricers.ltch.api.v2.LtchClaimPricingResponse;
import gov.cms.fiss.pricers.ltch.core.LtchPricerContext;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;

public class CalculateHoldValues
implements CalculationRule<LtchClaimPricingRequest, LtchClaimPricingResponse, LtchPricerContext> {
    @Override
    public void calculate(LtchPricerContext calculationContext) {
        InpatientProviderData providerData = calculationContext.getProviderData();
        calculationContext.setIppsComparablePayment(false);
        if (BigDecimalUtils.isGreaterThan(calculationContext.getHoldCapitalTeachingAdjustmentRatio(), new BigDecimal("1.5"))) {
            calculationContext.setHoldCapitalTeachingAdjustmentRatio(new BigDecimal("1.5").setScale(4, RoundingMode.HALF_UP));
        }
        calculationContext.setHoldCapitalImeTeach(BigDecimalMath.pow(new BigDecimal("2.7183"), new BigDecimal("0.2822").multiply(calculationContext.getHoldCapitalTeachingAdjustmentRatio()), new MathContext(10)).subtract(BigDecimal.ONE).setScale(9, RoundingMode.HALF_UP));
        calculationContext.setHoldOperatingDshPercent(providerData.getSupplementalSecurityIncomeRatio().add(providerData.getMedicaidRatio()).setScale(4, RoundingMode.HALF_UP));
    }
}

