/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ltch.core.rules;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.ltch.api.v2.LtchClaimPricingRequest;
import gov.cms.fiss.pricers.ltch.api.v2.LtchClaimPricingResponse;
import gov.cms.fiss.pricers.ltch.core.LtchPricerContext;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalculateShortStayBlendedPayment
implements CalculationRule<LtchClaimPricingRequest, LtchClaimPricingResponse, LtchPricerContext> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CalculateShortStayBlendedPayment.class);

    @Override
    public boolean shouldExecute(LtchPricerContext calculationContext) {
        return calculationContext.isPaymentStandardOrBlend() && BigDecimalUtils.isLessThanOrEqualTo(calculationContext.getHoldLengthOfStay(), calculationContext.getHoldShortStayOutlierThreshold());
    }

    @Override
    public void calculate(LtchPricerContext calculationContext) {
        if (BigDecimalUtils.isLessThan(calculationContext.getHoldShortStayOutlierThreshold(), new BigDecimal("25"))) {
            calculationContext.setHoldLtchBlendPercentage(calculationContext.getHoldLengthOfStay().divide(calculationContext.getHoldShortStayOutlierThreshold(), new MathContext(7)));
        } else {
            calculationContext.setHoldLtchBlendPercentage(calculationContext.getHoldLengthOfStay().divide(new BigDecimal("25"), new MathContext(7)));
        }
        if (BigDecimalUtils.isGreaterThan(calculationContext.getHoldLtchBlendPercentage(), BigDecimal.ONE)) {
            calculationContext.setHoldLtchBlendPercentage(BigDecimal.ONE);
        }
        calculationContext.setHoldLtchBlendPercentage(calculationContext.getHoldLtchBlendPercentage().setScale(4, RoundingMode.HALF_UP));
        calculationContext.setHoldLtchBlendAmount(calculationContext.getHoldShortStayPayAmount().multiply(calculationContext.getHoldLtchBlendPercentage()).setScale(2, RoundingMode.HALF_UP));
    }
}

