/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ltch.core.rules;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.ltch.api.v2.LtchClaimPricingRequest;
import gov.cms.fiss.pricers.ltch.api.v2.LtchClaimPricingResponse;
import gov.cms.fiss.pricers.ltch.api.v2.LtchPaymentData;
import gov.cms.fiss.pricers.ltch.core.LtchPricerContext;
import gov.cms.fiss.pricers.ltch.core.codes.SecondaryPaymentTypeSiteNeutral;
import java.math.BigDecimal;
import java.math.RoundingMode;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalculateSiteNeutralPayment
implements CalculationRule<LtchClaimPricingRequest, LtchClaimPricingResponse, LtchPricerContext> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CalculateSiteNeutralPayment.class);

    @Override
    public boolean shouldExecute(LtchPricerContext calculationContext) {
        return calculationContext.isPaymentBlendOrSiteNeutral();
    }

    @Override
    public void calculate(LtchPricerContext calculationContext) {
        LtchPaymentData paymentData = calculationContext.getPaymentData();
        paymentData.setOutlierPayment(paymentData.getOutlierPayment().multiply(calculationContext.getHoldSiteNeutralIppsAdj()));
        calculationContext.setHoldOutlierIppsComparable(paymentData.getOutlierPayment());
        paymentData.setSiteNeutralIppsPayment(BigDecimal.ZERO);
        paymentData.setOutlierPayment(BigDecimal.ZERO);
        calculationContext.setHoldOutlierIppsComparable(paymentData.getOutlierPayment());
        calculationContext.setHoldSnCostComparison(paymentData.getFacilityCosts());
        calculationContext.setHoldSnIppsComparison(calculationContext.getHoldIppsPerDiem().add(calculationContext.getHoldOutlierIppsComparable()).multiply(calculationContext.getHoldSiteNeutralIppsAdj()).setScale(2, RoundingMode.HALF_UP));
        if (BigDecimalUtils.isLessThan(calculationContext.getHoldSnCostComparison(), calculationContext.getHoldSnIppsComparison())) {
            calculationContext.setSecondaryPaymentTypeSiteNeutral(SecondaryPaymentTypeSiteNeutral.COST);
            paymentData.setSiteNeutralCostPayment(paymentData.getFacilityCosts());
        } else {
            calculationContext.setSecondaryPaymentTypeSiteNeutral(SecondaryPaymentTypeSiteNeutral.IPPS);
            paymentData.setSiteNeutralIppsPayment(calculationContext.getHoldIppsPerDiem());
        }
    }
}

