/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ltch.core.rules;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.ltch.api.v2.LtchClaimPricingRequest;
import gov.cms.fiss.pricers.ltch.api.v2.LtchClaimPricingResponse;
import gov.cms.fiss.pricers.ltch.api.v2.LtchPaymentData;
import gov.cms.fiss.pricers.ltch.core.LtchPricerContext;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;

public class CalculateStandardPayment
implements CalculationRule<LtchClaimPricingRequest, LtchClaimPricingResponse, LtchPricerContext> {
    @Override
    public boolean shouldExecute(LtchPricerContext calculationContext) {
        return calculationContext.isPaymentStandardOrBlend();
    }

    @Override
    public void calculate(LtchPricerContext calculationContext) {
        LtchPaymentData paymentData = calculationContext.getPaymentData();
        calculationContext.setIppsComparablePayment(Boolean.TRUE);
        calculationContext.setHoldLaborPortionRounded(paymentData.getFederalRatePercent().multiply(paymentData.getNationalLaborPercent()).multiply(paymentData.getFinalWageIndex()).setScale(6, RoundingMode.HALF_UP));
        calculationContext.setHoldNonLaborPortionRounded(paymentData.getFederalRatePercent().multiply(paymentData.getNationalNonLaborPercent()).multiply(paymentData.getCostOfLivingAdjustmentPercent()).setScale(6, RoundingMode.HALF_UP));
        paymentData.setFederalPayment(calculationContext.getHoldLaborPortionRounded().add(calculationContext.getHoldNonLaborPortionRounded()).setScale(2, RoundingMode.HALF_UP));
        paymentData.setAdjustedPayment(paymentData.getFederalPayment().multiply(paymentData.getDrgRelativeWeight()).setScale(2, RoundingMode.HALF_UP));
        calculationContext.setHoldShortStayOutlierThreshold(paymentData.getAverageLengthOfStay().divide(new BigDecimal("6"), new MathContext(10)).multiply(new BigDecimal("5")).setScale(1, RoundingMode.HALF_UP));
    }
}

