/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ltch.core.rules;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.ltch.api.v2.LtchClaimPricingRequest;
import gov.cms.fiss.pricers.ltch.api.v2.LtchClaimPricingResponse;
import gov.cms.fiss.pricers.ltch.core.LtchPricerContext;
import java.math.BigDecimal;
import java.math.RoundingMode;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CleanupShortStayBlendedPayment
implements CalculationRule<LtchClaimPricingRequest, LtchClaimPricingResponse, LtchPricerContext> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CleanupShortStayBlendedPayment.class);

    @Override
    public boolean shouldExecute(LtchPricerContext calculationContext) {
        return calculationContext.isPaymentStandardOrBlend() && BigDecimalUtils.isLessThanOrEqualTo(calculationContext.getHoldLengthOfStay(), calculationContext.getHoldShortStayOutlierThreshold());
    }

    @Override
    public void calculate(LtchPricerContext calculationContext) {
        calculationContext.setHoldIppsBlendPercentage(BigDecimal.ONE.subtract(calculationContext.getHoldLtchBlendPercentage()).setScale(4, RoundingMode.HALF_UP));
        calculationContext.setHoldIppsBlendAmount(calculationContext.getHoldIppsPerDiem().multiply(calculationContext.getHoldIppsBlendPercentage()).setScale(2, RoundingMode.HALF_UP));
        calculationContext.setHoldShortStayBlendedPayment(calculationContext.getHoldLtchBlendAmount().add(calculationContext.getHoldIppsBlendAmount()).setScale(2, RoundingMode.HALF_UP));
    }
}

