/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ltch.core.rules;

import gov.cms.fiss.pricers.common.api.InpatientProviderData;
import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.LocalDateUtils;
import gov.cms.fiss.pricers.ltch.api.v2.LtchClaimData;
import gov.cms.fiss.pricers.ltch.api.v2.LtchClaimPricingRequest;
import gov.cms.fiss.pricers.ltch.api.v2.LtchClaimPricingResponse;
import gov.cms.fiss.pricers.ltch.api.v2.LtchPaymentData;
import gov.cms.fiss.pricers.ltch.core.LtchPricerContext;
import gov.cms.fiss.pricers.ltch.core.codes.PaymentType;
import gov.cms.fiss.pricers.ltch.core.codes.ReturnCode;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;

public class DeterminePaymentType
implements CalculationRule<LtchClaimPricingRequest, LtchClaimPricingResponse, LtchPricerContext> {
    @Override
    public void calculate(LtchPricerContext calculationContext) {
        PaymentType returnPaymentType = null;
        LtchClaimData claimData = calculationContext.getClaimData();
        LtchPaymentData paymentData = calculationContext.getPaymentData();
        InpatientProviderData providerData = calculationContext.getProviderData();
        paymentData.setFacilityCosts(providerData.getOperatingCostToChargeRatio().multiply(claimData.getCoveredCharges()).setScale(2, RoundingMode.HALF_UP));
        int reviewCode = calculationContext.getReviewCodeAsInt();
        if (reviewCode == 0) {
            returnPaymentType = PaymentType.STANDARD_OLD;
        } else if (calculationContext.isStandardPaymentNew()) {
            returnPaymentType = PaymentType.STANDARD_NEW;
        } else if (reviewCode == 1 && calculationContext.isPsychRehabDrg() || Arrays.asList(2, 3, 6, 7, 8).contains(reviewCode)) {
            LocalDate admissionDate = claimData.getDischargeDate().minus(claimData.getLengthOfStay().intValue(), ChronoUnit.DAYS);
            if (LocalDateUtils.inRange(admissionDate, LocalDate.of(2020, 1, 26), false, calculationContext.getPublicHealthEmergencyLastDay(), true)) {
                calculationContext.setPaymentType(PaymentType.STANDARD_NEW);
                return;
            }
            returnPaymentType = this.getReturnPaymentType(calculationContext, paymentData);
        }
        if (returnPaymentType == null) {
            calculationContext.applyReturnCode(ReturnCode.INVALID_BLEND_IND_OR_REVIEW_CODE_72);
        }
        calculationContext.setPaymentType(returnPaymentType);
    }

    private PaymentType getReturnPaymentType(LtchPricerContext calculationContext, LtchPaymentData paymentData) {
        PaymentType returnPaymentType = null;
        if (paymentData.getBlendYear() == 8) {
            returnPaymentType = PaymentType.SITE_NEUTRAL;
        } else if (paymentData.getBlendYear() == 6 || paymentData.getBlendYear() == 7) {
            returnPaymentType = PaymentType.BLEND;
            calculationContext.setHoldBlendStandard(new BigDecimal("0.5").setScale(1, RoundingMode.HALF_UP));
            calculationContext.setHoldBlendSiteNeutral(new BigDecimal("0.5").setScale(1, RoundingMode.HALF_UP));
        }
        return returnPaymentType;
    }
}

