/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ltch.core.tables;

import gov.cms.fiss.pricers.common.csv.CsvIngestionConfiguration;
import gov.cms.fiss.pricers.ltch.LtchPricerConfiguration;
import gov.cms.fiss.pricers.ltch.api.v1.InpatientDrgsTableEntry;
import gov.cms.fiss.pricers.ltch.api.v1.LtchDrgsTableEntry;
import gov.cms.fiss.pricers.ltch.core.tables.CbsaWageIndexEntry;
import gov.cms.fiss.pricers.ltch.core.tables.CbsaWageIndexLookupGenerator;
import gov.cms.fiss.pricers.ltch.core.tables.InpatientDrgsTableLookupGenerator;
import gov.cms.fiss.pricers.ltch.core.tables.IppsCbsaWageIndexLookupGenerator;
import gov.cms.fiss.pricers.ltch.core.tables.LtchDrgsTableLookupGenerator;
import gov.cms.fiss.pricers.ltch.core.tables.WageIppsIndexRuralEntry;
import gov.cms.fiss.pricers.ltch.core.tables.WageIppsIndexRuralLookupGenerator;
import java.time.LocalDate;
import java.util.Map;
import java.util.NavigableMap;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class DataTables {
    private static final Map<Integer, DataTables> YEAR_LOOKUP = new ConcurrentHashMap<Integer, DataTables>();
    private final Map<String, NavigableMap<LocalDate, CbsaWageIndexEntry>> cbsaTable;
    private final Map<String, NavigableMap<LocalDate, WageIppsIndexRuralEntry>> wageIppsIndexRuralMap;
    private final Map<String, NavigableMap<LocalDate, CbsaWageIndexEntry>> ippsCbsaTable;
    private final Map<String, NavigableMap<LocalDate, InpatientDrgsTableEntry>> ippsDrgsMap;
    private final Map<String, LtchDrgsTableEntry> ltchDrgsMap;

    public DataTables(Map<String, NavigableMap<LocalDate, CbsaWageIndexEntry>> cbsaTable, Map<String, NavigableMap<LocalDate, WageIppsIndexRuralEntry>> wageIppsIndexRuralMap, Map<String, NavigableMap<LocalDate, CbsaWageIndexEntry>> ippsCbsaTable, Map<String, NavigableMap<LocalDate, InpatientDrgsTableEntry>> ippsDrgsMap, Map<String, LtchDrgsTableEntry> ltchDrgsMap) {
        this.cbsaTable = cbsaTable;
        this.wageIppsIndexRuralMap = wageIppsIndexRuralMap;
        this.ippsCbsaTable = ippsCbsaTable;
        this.ippsDrgsMap = ippsDrgsMap;
        this.ltchDrgsMap = ltchDrgsMap;
    }

    public static DataTables forYear(int pricerYear) {
        return YEAR_LOOKUP.get(pricerYear);
    }

    public static void loadDataTables(LtchPricerConfiguration pricerConfiguration) {
        CsvIngestionConfiguration csvIngestionConfiguration = pricerConfiguration.getCsvIngestionConfiguration();
        CbsaWageIndexLookupGenerator cbsaTableLookupGenerator = new CbsaWageIndexLookupGenerator(csvIngestionConfiguration);
        WageIppsIndexRuralLookupGenerator wageIppsIndexRuralLookupGenerator = new WageIppsIndexRuralLookupGenerator(csvIngestionConfiguration);
        IppsCbsaWageIndexLookupGenerator ippsCbsaWageIndexLookupGenerator = new IppsCbsaWageIndexLookupGenerator(csvIngestionConfiguration);
        InpatientDrgsTableLookupGenerator inpatientDrgsTableLookupGenerator = new InpatientDrgsTableLookupGenerator();
        LtchDrgsTableLookupGenerator ltchDrgsTableLookupGenerator = new LtchDrgsTableLookupGenerator();
        for (int pricerYear : pricerConfiguration.getSupportedYears()) {
            Map<String, NavigableMap<LocalDate, CbsaWageIndexEntry>> cbsaMap = cbsaTableLookupGenerator.generate(pricerYear);
            Map<String, NavigableMap<LocalDate, WageIppsIndexRuralEntry>> wageIppsIndexRuralMap = wageIppsIndexRuralLookupGenerator.generate();
            Map<String, NavigableMap<LocalDate, CbsaWageIndexEntry>> ippsCbsaMap = ippsCbsaWageIndexLookupGenerator.generate(pricerYear);
            Map<String, NavigableMap<LocalDate, InpatientDrgsTableEntry>> ippsDrgsMap = inpatientDrgsTableLookupGenerator.generate(pricerYear);
            Map<String, LtchDrgsTableEntry> ltchDrgsMap = ltchDrgsTableLookupGenerator.generate(pricerYear);
            YEAR_LOOKUP.put(pricerYear, new DataTables(cbsaMap, wageIppsIndexRuralMap, ippsCbsaMap, ippsDrgsMap, ltchDrgsMap));
        }
    }

    public WageIppsIndexRuralEntry getWageIppsIndexRural(String cbsa, LocalDate effectiveDate) {
        if (cbsa == null) {
            return null;
        }
        NavigableMap<LocalDate, WageIppsIndexRuralEntry> entries = this.wageIppsIndexRuralMap.get(cbsa.trim());
        return DataTables.getEntry(effectiveDate, entries);
    }

    public CbsaWageIndexEntry getCbsaWageIndexEntry(String cbsa, LocalDate effectiveDate) {
        NavigableMap<LocalDate, CbsaWageIndexEntry> entries = this.cbsaTable.get(cbsa);
        return DataTables.getEntry(effectiveDate, entries);
    }

    public CbsaWageIndexEntry getIppsCbsaWageIndex(String cbsa, LocalDate effectiveDate) {
        if (cbsa == null) {
            return null;
        }
        NavigableMap<LocalDate, CbsaWageIndexEntry> entries = this.ippsCbsaTable.get(cbsa.trim());
        return DataTables.getEntry(effectiveDate, entries);
    }

    private static <T> T getEntry(LocalDate effectiveDate, NavigableMap<LocalDate, T> map) {
        if (map == null) {
            return null;
        }
        Map.Entry<LocalDate, T> floorEntry = map.floorEntry(effectiveDate);
        if (floorEntry == null) {
            return null;
        }
        return floorEntry.getValue();
    }

    public InpatientDrgsTableEntry getInpatientDrgEntry(String code, LocalDate effectiveDate) {
        NavigableMap<LocalDate, InpatientDrgsTableEntry> entries = this.ippsDrgsMap.get(StringUtils.leftPad(code, 3, "0"));
        if (entries != null) {
            Map.Entry<LocalDate, InpatientDrgsTableEntry> entry = entries.floorEntry(effectiveDate);
            return null == entry ? null : entry.getValue();
        }
        return null;
    }

    public LtchDrgsTableEntry getLtchDrgsEntry(String code) {
        return this.ltchDrgsMap.get(code);
    }

    @Generated
    public Map<String, NavigableMap<LocalDate, CbsaWageIndexEntry>> getCbsaTable() {
        return this.cbsaTable;
    }

    @Generated
    public Map<String, NavigableMap<LocalDate, InpatientDrgsTableEntry>> getIppsDrgsMap() {
        return this.ippsDrgsMap;
    }

    @Generated
    public Map<String, LtchDrgsTableEntry> getLtchDrgsMap() {
        return this.ltchDrgsMap;
    }
}

