/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ltch.core.tables;

import com.fasterxml.jackson.dataformat.csv.CsvParser;
import gov.cms.fiss.pricers.common.csv.CsvContentReader;
import gov.cms.fiss.pricers.common.csv.LookupGenerator;
import gov.cms.fiss.pricers.ltch.api.v1.InpatientDrgsTableEntry;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public class InpatientDrgsTableLookupGenerator {
    private static final String CSV_FILE_PATTERN = "/ipdrgstable-%d.csv";
    private final CsvContentReader<InpatientDrgsTableEntry> contentProvider = new CsvContentReader<InpatientDrgsTableEntry>(InpatientDrgsTableEntry.class).customizeSchema(CsvContentReader.HEADER_ROW_CUSTOMIZER).customizeMapper(m4 -> m4.enable(CsvParser.Feature.TRIM_SPACES));

    public Map<String, NavigableMap<LocalDate, InpatientDrgsTableEntry>> generate(int pricerYear) {
        List<InpatientDrgsTableEntry> content = this.contentProvider.read(String.format(CSV_FILE_PATTERN, pricerYear));
        BinaryOperator comparator = BinaryOperator.maxBy((a, b) -> 0);
        Collector<InpatientDrgsTableEntry, ?, NavigableMap> collector = Collectors.toMap(InpatientDrgsTableEntry::getEffectiveDate, Function.identity(), comparator, TreeMap::new);
        return LookupGenerator.generateCrossReferenceToMap(InpatientDrgsTableEntry::getDiagnosticRelatedGroup, content, HashMap::new, collector);
    }
}

