/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jersey.params;

import io.dropwizard.jersey.errors.ErrorMessage;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractParam<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractParam.class);
    private final String parameterName;
    private final T value;

    protected AbstractParam(@Nullable String input) {
        this(input, "Parameter");
    }

    protected AbstractParam(@Nullable String input, String parameterName) {
        this.parameterName = parameterName;
        try {
            this.value = this.parse(input);
        }
        catch (Exception e) {
            ErrorMessage message = this.generateErrorMessage(input, e);
            throw new WebApplicationException(message.getMessage(), (int)message.getCode());
        }
    }

    protected ErrorMessage generateErrorMessage(@Nullable String input, Exception e) {
        Response response = this.error(input, e);
        if (response != null) {
            throw new WebApplicationException(response);
        }
        LOGGER.debug("Invalid input received: {}", (Object)input);
        String errorMessage = this.errorMessage(e);
        if (errorMessage.contains("%s")) {
            errorMessage = String.format(errorMessage, this.parameterName);
        }
        return new ErrorMessage(this.getErrorStatus().getStatusCode(), errorMessage);
    }

    @Deprecated
    protected @Nullable Response error(@Nullable String input, Exception e) {
        return null;
    }

    @Deprecated
    protected MediaType mediaType() {
        return MediaType.APPLICATION_JSON_TYPE;
    }

    protected String errorMessage(Exception e) {
        return String.format("%s is invalid: %s", this.parameterName, e.getMessage());
    }

    protected Response.Status getErrorStatus() {
        return Response.Status.BAD_REQUEST;
    }

    protected abstract T parse(@Nullable String var1) throws Exception;

    public T get() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractParam that = (AbstractParam)obj;
        return this.value.equals(that.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        return this.value.toString();
    }
}

