/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import org.assertj.core.api.AssertionInfo;
import org.assertj.core.error.ShouldBeFinite;
import org.assertj.core.error.ShouldBeInfinite;
import org.assertj.core.error.ShouldNotBeFinite;
import org.assertj.core.error.ShouldNotBeInfinite;
import org.assertj.core.internal.ComparisonStrategy;
import org.assertj.core.internal.Numbers;

public abstract class RealNumbers<NUMBER extends Number>
extends Numbers<NUMBER> {
    public RealNumbers() {
    }

    public RealNumbers(ComparisonStrategy comparisonStrategy) {
        super(comparisonStrategy);
    }

    public void assertIsNaN(AssertionInfo info, NUMBER actual) {
        this.assertEqualByComparison(info, actual, this.NaN());
    }

    protected abstract NUMBER NaN();

    public void assertIsNotNaN(AssertionInfo info, NUMBER actual) {
        this.assertNotEqualByComparison(info, actual, this.NaN());
    }

    @Override
    protected boolean isGreaterThan(NUMBER value, NUMBER other) {
        return ((Comparable)value).compareTo(other) > 0;
    }

    public void assertIsFinite(AssertionInfo info, NUMBER actual) {
        RealNumbers.assertNotNull(info, actual);
        if (this.isFinite(actual)) {
            return;
        }
        throw this.failures.failure(info, ShouldBeFinite.shouldBeFinite(actual));
    }

    protected abstract boolean isFinite(NUMBER var1);

    public void assertIsNotFinite(AssertionInfo info, NUMBER actual) {
        RealNumbers.assertNotNull(info, actual);
        if (this.isNotFinite(actual)) {
            return;
        }
        throw this.failures.failure(info, ShouldNotBeFinite.shouldNotBeFinite(actual));
    }

    protected abstract boolean isNotFinite(NUMBER var1);

    public void assertIsInfinite(AssertionInfo info, NUMBER actual) {
        RealNumbers.assertNotNull(info, actual);
        if (this.isInfinite(actual)) {
            return;
        }
        throw this.failures.failure(info, ShouldBeInfinite.shouldBeInfinite(actual));
    }

    protected abstract boolean isInfinite(NUMBER var1);

    public void assertIsNotInfinite(AssertionInfo info, NUMBER actual) {
        RealNumbers.assertNotNull(info, actual);
        if (this.isNotInfinite(actual)) {
            return;
        }
        throw this.failures.failure(info, ShouldNotBeInfinite.shouldNotBeInfinite(actual));
    }

    protected abstract boolean isNotInfinite(NUMBER var1);
}

