/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.descriptor;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestInstances;
import org.junit.jupiter.engine.config.JupiterConfiguration;
import org.junit.jupiter.engine.descriptor.AbstractExtensionContext;
import org.junit.jupiter.engine.descriptor.TestTemplateTestDescriptor;
import org.junit.jupiter.engine.extension.ExtensionRegistry;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.support.hierarchical.Node;

final class TestTemplateExtensionContext
extends AbstractExtensionContext<TestTemplateTestDescriptor> {
    private final TestInstances testInstances;

    TestTemplateExtensionContext(ExtensionContext parent, EngineExecutionListener engineExecutionListener, TestTemplateTestDescriptor testDescriptor, JupiterConfiguration configuration, ExtensionRegistry extensionRegistry, TestInstances testInstances) {
        super(parent, engineExecutionListener, testDescriptor, configuration, extensionRegistry);
        this.testInstances = testInstances;
    }

    @Override
    public Optional<AnnotatedElement> getElement() {
        return Optional.of(((TestTemplateTestDescriptor)this.getTestDescriptor()).getTestMethod());
    }

    @Override
    public Optional<Class<?>> getTestClass() {
        return Optional.of(((TestTemplateTestDescriptor)this.getTestDescriptor()).getTestClass());
    }

    @Override
    public List<Class<?>> getEnclosingTestClasses() {
        return ((TestTemplateTestDescriptor)this.getTestDescriptor()).getEnclosingTestClasses();
    }

    @Override
    public Optional<TestInstance.Lifecycle> getTestInstanceLifecycle() {
        return this.getParent().flatMap(ExtensionContext::getTestInstanceLifecycle);
    }

    @Override
    public Optional<Object> getTestInstance() {
        return this.getTestInstances().map(TestInstances::getInnermostInstance);
    }

    @Override
    public Optional<TestInstances> getTestInstances() {
        return Optional.ofNullable(this.testInstances);
    }

    @Override
    public Optional<Method> getTestMethod() {
        return Optional.of(((TestTemplateTestDescriptor)this.getTestDescriptor()).getTestMethod());
    }

    @Override
    public Optional<Throwable> getExecutionException() {
        return Optional.empty();
    }

    @Override
    protected Node.ExecutionMode getPlatformExecutionMode() {
        return ((TestTemplateTestDescriptor)this.getTestDescriptor()).getExecutionMode();
    }
}

