/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.execution;

import java.util.function.Function;
import java.util.function.Supplier;
import org.apiguardian.api.API;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ExtensionContextException;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.support.store.NamespacedHierarchicalStore;
import org.junit.platform.engine.support.store.NamespacedHierarchicalStoreException;

@API(status=API.Status.INTERNAL, since="5.0")
public class NamespaceAwareStore
implements ExtensionContext.Store {
    private final NamespacedHierarchicalStore<ExtensionContext.Namespace> valuesStore;
    private final ExtensionContext.Namespace namespace;

    public NamespaceAwareStore(NamespacedHierarchicalStore<ExtensionContext.Namespace> valuesStore, ExtensionContext.Namespace namespace) {
        this.valuesStore = valuesStore;
        this.namespace = namespace;
    }

    @Override
    public Object get(Object key) {
        Preconditions.notNull(key, "key must not be null");
        return this.accessStore(() -> this.valuesStore.get((Object)this.namespace, key));
    }

    public <T> T get(Object key, Class<T> requiredType) {
        Preconditions.notNull(key, "key must not be null");
        Preconditions.notNull(requiredType, "requiredType must not be null");
        return (T)this.accessStore(() -> this.valuesStore.get((Object)this.namespace, key, requiredType));
    }

    @Override
    public <K, V> Object getOrComputeIfAbsent(K key, Function<K, V> defaultCreator) {
        Preconditions.notNull(key, "key must not be null");
        Preconditions.notNull(defaultCreator, "defaultCreator function must not be null");
        return this.accessStore(() -> this.valuesStore.getOrComputeIfAbsent((Object)this.namespace, key, defaultCreator));
    }

    @Override
    public <K, V> V getOrComputeIfAbsent(K key, Function<K, V> defaultCreator, Class<V> requiredType) {
        Preconditions.notNull(key, "key must not be null");
        Preconditions.notNull(defaultCreator, "defaultCreator function must not be null");
        Preconditions.notNull(requiredType, "requiredType must not be null");
        return (V)this.accessStore(() -> this.valuesStore.getOrComputeIfAbsent((Object)this.namespace, key, defaultCreator, requiredType));
    }

    @Override
    public void put(Object key, Object value) {
        Preconditions.notNull(key, "key must not be null");
        this.accessStore(() -> this.valuesStore.put((Object)this.namespace, key, value));
    }

    @Override
    public Object remove(Object key) {
        Preconditions.notNull(key, "key must not be null");
        return this.accessStore(() -> this.valuesStore.remove((Object)this.namespace, key));
    }

    public <T> T remove(Object key, Class<T> requiredType) {
        Preconditions.notNull(key, "key must not be null");
        Preconditions.notNull(requiredType, "requiredType must not be null");
        return (T)this.accessStore(() -> this.valuesStore.remove((Object)this.namespace, key, requiredType));
    }

    private <T> T accessStore(Supplier<T> action) {
        try {
            return action.get();
        }
        catch (NamespacedHierarchicalStoreException e) {
            throw new ExtensionContextException(e.getMessage(), e);
        }
    }
}

