// Generated by delombok at Thu Sep 11 13:51:57 UTC 2025
package gov.cms.fiss.pricers.ltch.api.v2;

import gov.cms.fiss.pricers.common.api.PaymentData;
import gov.cms.fiss.pricers.common.api.annotations.FixedValue;
import gov.cms.fiss.pricers.common.api.serialization.BigDecimalScale;
import gov.cms.fiss.pricers.common.api.validation.ValidDecimalOutputWithFiveFractionDigits;
import gov.cms.fiss.pricers.common.api.validation.ValidDecimalOutputWithTwoFractionDigits;
import gov.cms.fiss.pricers.common.api.validation.ValidDiagnosisRelatedGroup;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.DecimalMax;
import jakarta.validation.constraints.DecimalMin;
import jakarta.validation.constraints.Digits;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.math.BigDecimal;
import java.math.RoundingMode;

@Schema(description = "The LTCH payment information.", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-DATA-ALL", value = "<structure>")})})
public class LtchPaymentData extends PaymentData {
  @BigDecimalScale
  @DecimalMin("0")
  @DecimalMax("9999999.99")
  @Digits(integer = 7, fraction = 2)
  @Schema(description = "The adjusted payment.", example = "3523.99", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-DRG-ADJ-PAY-AMT", value = "PIC 9(07)V9(02)")})})
  @FixedValue
  private BigDecimal adjustedPayment = BigDecimalUtils.ZERO;
  @BigDecimalScale(scale = 1)
  @DecimalMin("0")
  @DecimalMax("99.9")
  @Digits(integer = 2, fraction = 1)
  @NotNull
  @Schema(description = "The average length of stay.", example = "8.2", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-AVG-LOS", value = "PIC 9(02)V9(01)")})})
  @FixedValue
  private BigDecimal averageLengthOfStay = BigDecimal.ZERO.setScale(1, RoundingMode.HALF_UP);
  @Max(9)
  @Min(1)
  @Schema(description = "The blend year.", example = "4", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-BLEND-YEAR", value = "PIC 9(01)")})})
  private int blendYear;
  @BigDecimalScale(scale = 3)
  @DecimalMin("0")
  @DecimalMax("9.999")
  @Digits(integer = 1, fraction = 3)
  @Schema(description = "The budget neutrality rate amount.", example = "6.999", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-BDGT-NEUT-RATE", value = "PIC 9(01)V9(03)")})})
  @FixedValue
  private BigDecimal budgetNeutralityRate = BigDecimal.ONE.setScale(3, RoundingMode.HALF_UP);
  @Pattern(regexp = "1", message = "must be `1` if present")
  @Schema(description = "The change of therapy indicator.", example = "1", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-COT", value = "PIC X(01)")})})
  private String changeOfTherapyIndicator;
  @BigDecimalScale
  @Schema(description = "The charge threshold payment amount.", example = "25953.12", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-CHRG-THRESHOLD", value = "PIC 9(07)V9(02)")})})
  @ValidDecimalOutputWithTwoFractionDigits
  private BigDecimal chargeThresholdAmount = BigDecimalUtils.ZERO;
  @BigDecimalScale(scale = 3)
  @DecimalMin("0")
  @DecimalMax("9.999")
  @Digits(integer = 1, fraction = 3)
  @Schema(description = "The cost-of-living adjustment of provider record.", example = "0.998", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-COLA", value = "PIC 9(01)V9(03)")})})
  @FixedValue
  private BigDecimal costOfLivingAdjustmentPercent = BigDecimal.ZERO.setScale(3, RoundingMode.HALF_UP);
  @BigDecimalScale(scale = 4)
  @DecimalMax("99999999999999999999.9999")
  @DecimalMin("-99999999999999999999.9999")
  @Digits(integer = 20, fraction = 4)
  @Schema(description = "The discharge payment percent amount.", example = "0.4215")
  private BigDecimal dischargePaymentPercentAmount = BigDecimal.ZERO.setScale(4, RoundingMode.HALF_UP);
  @BigDecimalScale(scale = 4)
  @DecimalMin("0")
  @DecimalMax("9.9999")
  @Digits(integer = 1, fraction = 4)
  @NotNull
  @Schema(description = "The diagnosis-related group (DRG) relative weight.", example = "5.2903", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-RELATIVE-WGT", value = "PIC 9(01)V9(04)")})})
  @FixedValue
  private BigDecimal drgRelativeWeight = BigDecimal.ZERO.setScale(4, RoundingMode.HALF_UP);
  @BigDecimalScale
  @Schema(description = "The facility costs.", example = "3256.90", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-FAC-COSTS", value = "PIC 9(07)V9(02)")})})
  @ValidDecimalOutputWithTwoFractionDigits
  private BigDecimal facilityCosts = BigDecimalUtils.ZERO;
  // this value is never set
  @BigDecimalScale
  @DecimalMin("0")
  @DecimalMax("9999999.99")
  @Digits(integer = 7, fraction = 2)
  @Schema(description = "The facility-specific rate.", example = "1902.25", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-NEW-FAC-SPEC-RATE", value = "PIC 9(07)V9(02)")})})
  @FixedValue
  private BigDecimal facilitySpecificRate = BigDecimalUtils.ZERO;
  @BigDecimalScale
  @DecimalMin("0")
  @DecimalMax("9999999.99")
  @Digits(integer = 7, fraction = 2)
  @Schema(description = "The federal payment.", example = "58399.00", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-FED-PAY-AMT", value = "PIC 9(07)V9(02)")})})
  @FixedValue
  private BigDecimal federalPayment = BigDecimalUtils.ZERO;
  @BigDecimalScale(scale = 5)
  @Schema(description = "The federal rate percent.", example = "0.59283")
  @ValidDecimalOutputWithFiveFractionDigits
  private BigDecimal federalRatePercent = BigDecimal.ZERO.setScale(5, RoundingMode.HALF_UP);
  // this is never set
  @BigDecimalScale(scale = 1)
  @DecimalMin("0")
  @DecimalMax("999.9")
  @Digits(integer = 3, fraction = 1)
  @Schema(description = "The inpatient threshold.", example = "253.9", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-IPTHRESH", value = "PIC 9(03)V9(01)")})})
  @FixedValue
  private BigDecimal inpatientThreshold = BigDecimal.ZERO.setScale(1, RoundingMode.HALF_UP);
  @Max(999)
  @Min(0)
  @Schema(description = "The length of stay (LOS).", example = "4", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-LOS", value = "PIC 9(03)")})})
  private int lengthOfStay;
  @Max(999)
  @Min(0)
  @Schema(description = "The number of lifetime reserve days used.", example = "12", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-LTR-DAYS-USED", value = "PIC 9(03)")})})
  private int lifetimeReserveDaysUsed;
  @BigDecimalScale(scale = 5)
  @DecimalMin("0")
  @DecimalMax("9.99999")
  @Digits(integer = 1, fraction = 5)
  @Schema(description = "The national labor percent.", example = "0.53226", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-NAT-LABOR-PCT", value = "PIC 9(01)V9(05)")})})
  @FixedValue
  private BigDecimal nationalLaborPercent = BigDecimal.ZERO.setScale(5, RoundingMode.HALF_UP);
  @BigDecimalScale(scale = 5)
  @DecimalMin("0")
  @DecimalMax("9.99999")
  @Digits(integer = 1, fraction = 5)
  @Schema(description = "The national non-labor percent.", example = "0.35232", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-NAT-NONLABOR-PCT", value = "PIC 9(01)V9(05)")})})
  @FixedValue
  private BigDecimal nationalNonLaborPercent = BigDecimal.ZERO.setScale(5, RoundingMode.HALF_UP);
  @BigDecimalScale
  @NotNull
  @Schema(description = "The outlier payment.", example = "9355.24", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-OUTLIER-PAY-AMT", value = "PIC 9(07)V9(02)")})})
  @ValidDecimalOutputWithTwoFractionDigits
  private BigDecimal outlierPayment = BigDecimalUtils.ZERO;
  @BigDecimalScale
  @NotNull
  @Schema(description = "The outlier threshold amount.", example = "55246.50", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-OUTLIER-THRESHOLD", value = "PIC 9(07)V9(02)")})})
  @ValidDecimalOutputWithTwoFractionDigits
  private BigDecimal outlierThresholdAmount = BigDecimalUtils.ZERO;
  @Max(999)
  @Min(0)
  @Schema(description = "The number of regular days used.", example = "30", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-REG-DAYS-USED", value = "PIC 9(03)")})})
  private int regularDaysUsed;
  @BigDecimalScale
  @Schema(description = "The site-neutral cost payment.", example = "15323.99", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-SITE-NEUTRAL-COST-PMT", value = "PIC 9(07)V99")})})
  @ValidDecimalOutputWithTwoFractionDigits
  private BigDecimal siteNeutralCostPayment = BigDecimalUtils.ZERO;
  @BigDecimalScale
  @Schema(description = "The site-neutral IPPS payment.", example = "5582.90", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-SITE-NEUTRAL-IPPS-PMT", value = "PIC 9(07)V99")})})
  @ValidDecimalOutputWithTwoFractionDigits
  private BigDecimal siteNeutralIppsPayment = BigDecimalUtils.ZERO;
  @BigDecimalScale
  @DecimalMin("0")
  @DecimalMax("9999999.99")
  @Digits(integer = 7, fraction = 2)
  @Schema(description = "The standard full payment.", example = "5883.00", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-STANDARD-FULL-PMT", value = "PIC 9(07)V99")})})
  @FixedValue
  private BigDecimal standardFullPayment = BigDecimalUtils.ZERO;
  @BigDecimalScale
  @DecimalMin("0")
  @DecimalMax("9999999.99")
  @Digits(integer = 7, fraction = 2)
  @Schema(description = "The standard short-stay outlier payment.", example = "35266.80", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-STANDARD-SSO-PMT", value = "PIC 9(07)V99")})})
  @FixedValue
  private BigDecimal standardShortStayOutlierPayment = BigDecimalUtils.ZERO;
  @ValidDiagnosisRelatedGroup
  @Schema(description = "The submitted diagnosis-related group.", example = "981", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-SUBM-DRG-CODE", value = "PIC X(03)")})})
  private String submittedDiagnosisRelatedGroup;

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getAdjustedPayment() {
    return this.adjustedPayment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getAverageLengthOfStay() {
    return this.averageLengthOfStay;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int getBlendYear() {
    return this.blendYear;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getBudgetNeutralityRate() {
    return this.budgetNeutralityRate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getChangeOfTherapyIndicator() {
    return this.changeOfTherapyIndicator;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getChargeThresholdAmount() {
    return this.chargeThresholdAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getCostOfLivingAdjustmentPercent() {
    return this.costOfLivingAdjustmentPercent;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getDischargePaymentPercentAmount() {
    return this.dischargePaymentPercentAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getDrgRelativeWeight() {
    return this.drgRelativeWeight;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getFacilityCosts() {
    return this.facilityCosts;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getFacilitySpecificRate() {
    return this.facilitySpecificRate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getFederalPayment() {
    return this.federalPayment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getFederalRatePercent() {
    return this.federalRatePercent;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getInpatientThreshold() {
    return this.inpatientThreshold;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int getLengthOfStay() {
    return this.lengthOfStay;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int getLifetimeReserveDaysUsed() {
    return this.lifetimeReserveDaysUsed;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getNationalLaborPercent() {
    return this.nationalLaborPercent;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getNationalNonLaborPercent() {
    return this.nationalNonLaborPercent;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getOutlierPayment() {
    return this.outlierPayment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getOutlierThresholdAmount() {
    return this.outlierThresholdAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int getRegularDaysUsed() {
    return this.regularDaysUsed;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getSiteNeutralCostPayment() {
    return this.siteNeutralCostPayment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getSiteNeutralIppsPayment() {
    return this.siteNeutralIppsPayment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getStandardFullPayment() {
    return this.standardFullPayment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getStandardShortStayOutlierPayment() {
    return this.standardShortStayOutlierPayment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getSubmittedDiagnosisRelatedGroup() {
    return this.submittedDiagnosisRelatedGroup;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAdjustedPayment(final BigDecimal adjustedPayment) {
    this.adjustedPayment = adjustedPayment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAverageLengthOfStay(final BigDecimal averageLengthOfStay) {
    this.averageLengthOfStay = averageLengthOfStay;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setBlendYear(final int blendYear) {
    this.blendYear = blendYear;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setBudgetNeutralityRate(final BigDecimal budgetNeutralityRate) {
    this.budgetNeutralityRate = budgetNeutralityRate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setChangeOfTherapyIndicator(final String changeOfTherapyIndicator) {
    this.changeOfTherapyIndicator = changeOfTherapyIndicator;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setChargeThresholdAmount(final BigDecimal chargeThresholdAmount) {
    this.chargeThresholdAmount = chargeThresholdAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCostOfLivingAdjustmentPercent(final BigDecimal costOfLivingAdjustmentPercent) {
    this.costOfLivingAdjustmentPercent = costOfLivingAdjustmentPercent;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDischargePaymentPercentAmount(final BigDecimal dischargePaymentPercentAmount) {
    this.dischargePaymentPercentAmount = dischargePaymentPercentAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDrgRelativeWeight(final BigDecimal drgRelativeWeight) {
    this.drgRelativeWeight = drgRelativeWeight;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setFacilityCosts(final BigDecimal facilityCosts) {
    this.facilityCosts = facilityCosts;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setFacilitySpecificRate(final BigDecimal facilitySpecificRate) {
    this.facilitySpecificRate = facilitySpecificRate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setFederalPayment(final BigDecimal federalPayment) {
    this.federalPayment = federalPayment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setFederalRatePercent(final BigDecimal federalRatePercent) {
    this.federalRatePercent = federalRatePercent;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setInpatientThreshold(final BigDecimal inpatientThreshold) {
    this.inpatientThreshold = inpatientThreshold;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLengthOfStay(final int lengthOfStay) {
    this.lengthOfStay = lengthOfStay;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLifetimeReserveDaysUsed(final int lifetimeReserveDaysUsed) {
    this.lifetimeReserveDaysUsed = lifetimeReserveDaysUsed;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setNationalLaborPercent(final BigDecimal nationalLaborPercent) {
    this.nationalLaborPercent = nationalLaborPercent;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setNationalNonLaborPercent(final BigDecimal nationalNonLaborPercent) {
    this.nationalNonLaborPercent = nationalNonLaborPercent;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOutlierPayment(final BigDecimal outlierPayment) {
    this.outlierPayment = outlierPayment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOutlierThresholdAmount(final BigDecimal outlierThresholdAmount) {
    this.outlierThresholdAmount = outlierThresholdAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setRegularDaysUsed(final int regularDaysUsed) {
    this.regularDaysUsed = regularDaysUsed;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setSiteNeutralCostPayment(final BigDecimal siteNeutralCostPayment) {
    this.siteNeutralCostPayment = siteNeutralCostPayment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setSiteNeutralIppsPayment(final BigDecimal siteNeutralIppsPayment) {
    this.siteNeutralIppsPayment = siteNeutralIppsPayment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setStandardFullPayment(final BigDecimal standardFullPayment) {
    this.standardFullPayment = standardFullPayment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setStandardShortStayOutlierPayment(final BigDecimal standardShortStayOutlierPayment) {
    this.standardShortStayOutlierPayment = standardShortStayOutlierPayment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setSubmittedDiagnosisRelatedGroup(final String submittedDiagnosisRelatedGroup) {
    this.submittedDiagnosisRelatedGroup = submittedDiagnosisRelatedGroup;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof LtchPaymentData)) return false;
    final LtchPaymentData other = (LtchPaymentData) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    if (!super.equals(o)) return false;
    if (this.getBlendYear() != other.getBlendYear()) return false;
    if (this.getLengthOfStay() != other.getLengthOfStay()) return false;
    if (this.getLifetimeReserveDaysUsed() != other.getLifetimeReserveDaysUsed()) return false;
    if (this.getRegularDaysUsed() != other.getRegularDaysUsed()) return false;
    final java.lang.Object this$adjustedPayment = this.getAdjustedPayment();
    final java.lang.Object other$adjustedPayment = other.getAdjustedPayment();
    if (this$adjustedPayment == null ? other$adjustedPayment != null : !this$adjustedPayment.equals(other$adjustedPayment)) return false;
    final java.lang.Object this$averageLengthOfStay = this.getAverageLengthOfStay();
    final java.lang.Object other$averageLengthOfStay = other.getAverageLengthOfStay();
    if (this$averageLengthOfStay == null ? other$averageLengthOfStay != null : !this$averageLengthOfStay.equals(other$averageLengthOfStay)) return false;
    final java.lang.Object this$budgetNeutralityRate = this.getBudgetNeutralityRate();
    final java.lang.Object other$budgetNeutralityRate = other.getBudgetNeutralityRate();
    if (this$budgetNeutralityRate == null ? other$budgetNeutralityRate != null : !this$budgetNeutralityRate.equals(other$budgetNeutralityRate)) return false;
    final java.lang.Object this$changeOfTherapyIndicator = this.getChangeOfTherapyIndicator();
    final java.lang.Object other$changeOfTherapyIndicator = other.getChangeOfTherapyIndicator();
    if (this$changeOfTherapyIndicator == null ? other$changeOfTherapyIndicator != null : !this$changeOfTherapyIndicator.equals(other$changeOfTherapyIndicator)) return false;
    final java.lang.Object this$chargeThresholdAmount = this.getChargeThresholdAmount();
    final java.lang.Object other$chargeThresholdAmount = other.getChargeThresholdAmount();
    if (this$chargeThresholdAmount == null ? other$chargeThresholdAmount != null : !this$chargeThresholdAmount.equals(other$chargeThresholdAmount)) return false;
    final java.lang.Object this$costOfLivingAdjustmentPercent = this.getCostOfLivingAdjustmentPercent();
    final java.lang.Object other$costOfLivingAdjustmentPercent = other.getCostOfLivingAdjustmentPercent();
    if (this$costOfLivingAdjustmentPercent == null ? other$costOfLivingAdjustmentPercent != null : !this$costOfLivingAdjustmentPercent.equals(other$costOfLivingAdjustmentPercent)) return false;
    final java.lang.Object this$dischargePaymentPercentAmount = this.getDischargePaymentPercentAmount();
    final java.lang.Object other$dischargePaymentPercentAmount = other.getDischargePaymentPercentAmount();
    if (this$dischargePaymentPercentAmount == null ? other$dischargePaymentPercentAmount != null : !this$dischargePaymentPercentAmount.equals(other$dischargePaymentPercentAmount)) return false;
    final java.lang.Object this$drgRelativeWeight = this.getDrgRelativeWeight();
    final java.lang.Object other$drgRelativeWeight = other.getDrgRelativeWeight();
    if (this$drgRelativeWeight == null ? other$drgRelativeWeight != null : !this$drgRelativeWeight.equals(other$drgRelativeWeight)) return false;
    final java.lang.Object this$facilityCosts = this.getFacilityCosts();
    final java.lang.Object other$facilityCosts = other.getFacilityCosts();
    if (this$facilityCosts == null ? other$facilityCosts != null : !this$facilityCosts.equals(other$facilityCosts)) return false;
    final java.lang.Object this$facilitySpecificRate = this.getFacilitySpecificRate();
    final java.lang.Object other$facilitySpecificRate = other.getFacilitySpecificRate();
    if (this$facilitySpecificRate == null ? other$facilitySpecificRate != null : !this$facilitySpecificRate.equals(other$facilitySpecificRate)) return false;
    final java.lang.Object this$federalPayment = this.getFederalPayment();
    final java.lang.Object other$federalPayment = other.getFederalPayment();
    if (this$federalPayment == null ? other$federalPayment != null : !this$federalPayment.equals(other$federalPayment)) return false;
    final java.lang.Object this$federalRatePercent = this.getFederalRatePercent();
    final java.lang.Object other$federalRatePercent = other.getFederalRatePercent();
    if (this$federalRatePercent == null ? other$federalRatePercent != null : !this$federalRatePercent.equals(other$federalRatePercent)) return false;
    final java.lang.Object this$inpatientThreshold = this.getInpatientThreshold();
    final java.lang.Object other$inpatientThreshold = other.getInpatientThreshold();
    if (this$inpatientThreshold == null ? other$inpatientThreshold != null : !this$inpatientThreshold.equals(other$inpatientThreshold)) return false;
    final java.lang.Object this$nationalLaborPercent = this.getNationalLaborPercent();
    final java.lang.Object other$nationalLaborPercent = other.getNationalLaborPercent();
    if (this$nationalLaborPercent == null ? other$nationalLaborPercent != null : !this$nationalLaborPercent.equals(other$nationalLaborPercent)) return false;
    final java.lang.Object this$nationalNonLaborPercent = this.getNationalNonLaborPercent();
    final java.lang.Object other$nationalNonLaborPercent = other.getNationalNonLaborPercent();
    if (this$nationalNonLaborPercent == null ? other$nationalNonLaborPercent != null : !this$nationalNonLaborPercent.equals(other$nationalNonLaborPercent)) return false;
    final java.lang.Object this$outlierPayment = this.getOutlierPayment();
    final java.lang.Object other$outlierPayment = other.getOutlierPayment();
    if (this$outlierPayment == null ? other$outlierPayment != null : !this$outlierPayment.equals(other$outlierPayment)) return false;
    final java.lang.Object this$outlierThresholdAmount = this.getOutlierThresholdAmount();
    final java.lang.Object other$outlierThresholdAmount = other.getOutlierThresholdAmount();
    if (this$outlierThresholdAmount == null ? other$outlierThresholdAmount != null : !this$outlierThresholdAmount.equals(other$outlierThresholdAmount)) return false;
    final java.lang.Object this$siteNeutralCostPayment = this.getSiteNeutralCostPayment();
    final java.lang.Object other$siteNeutralCostPayment = other.getSiteNeutralCostPayment();
    if (this$siteNeutralCostPayment == null ? other$siteNeutralCostPayment != null : !this$siteNeutralCostPayment.equals(other$siteNeutralCostPayment)) return false;
    final java.lang.Object this$siteNeutralIppsPayment = this.getSiteNeutralIppsPayment();
    final java.lang.Object other$siteNeutralIppsPayment = other.getSiteNeutralIppsPayment();
    if (this$siteNeutralIppsPayment == null ? other$siteNeutralIppsPayment != null : !this$siteNeutralIppsPayment.equals(other$siteNeutralIppsPayment)) return false;
    final java.lang.Object this$standardFullPayment = this.getStandardFullPayment();
    final java.lang.Object other$standardFullPayment = other.getStandardFullPayment();
    if (this$standardFullPayment == null ? other$standardFullPayment != null : !this$standardFullPayment.equals(other$standardFullPayment)) return false;
    final java.lang.Object this$standardShortStayOutlierPayment = this.getStandardShortStayOutlierPayment();
    final java.lang.Object other$standardShortStayOutlierPayment = other.getStandardShortStayOutlierPayment();
    if (this$standardShortStayOutlierPayment == null ? other$standardShortStayOutlierPayment != null : !this$standardShortStayOutlierPayment.equals(other$standardShortStayOutlierPayment)) return false;
    final java.lang.Object this$submittedDiagnosisRelatedGroup = this.getSubmittedDiagnosisRelatedGroup();
    final java.lang.Object other$submittedDiagnosisRelatedGroup = other.getSubmittedDiagnosisRelatedGroup();
    if (this$submittedDiagnosisRelatedGroup == null ? other$submittedDiagnosisRelatedGroup != null : !this$submittedDiagnosisRelatedGroup.equals(other$submittedDiagnosisRelatedGroup)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof LtchPaymentData;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = super.hashCode();
    result = result * PRIME + this.getBlendYear();
    result = result * PRIME + this.getLengthOfStay();
    result = result * PRIME + this.getLifetimeReserveDaysUsed();
    result = result * PRIME + this.getRegularDaysUsed();
    final java.lang.Object $adjustedPayment = this.getAdjustedPayment();
    result = result * PRIME + ($adjustedPayment == null ? 43 : $adjustedPayment.hashCode());
    final java.lang.Object $averageLengthOfStay = this.getAverageLengthOfStay();
    result = result * PRIME + ($averageLengthOfStay == null ? 43 : $averageLengthOfStay.hashCode());
    final java.lang.Object $budgetNeutralityRate = this.getBudgetNeutralityRate();
    result = result * PRIME + ($budgetNeutralityRate == null ? 43 : $budgetNeutralityRate.hashCode());
    final java.lang.Object $changeOfTherapyIndicator = this.getChangeOfTherapyIndicator();
    result = result * PRIME + ($changeOfTherapyIndicator == null ? 43 : $changeOfTherapyIndicator.hashCode());
    final java.lang.Object $chargeThresholdAmount = this.getChargeThresholdAmount();
    result = result * PRIME + ($chargeThresholdAmount == null ? 43 : $chargeThresholdAmount.hashCode());
    final java.lang.Object $costOfLivingAdjustmentPercent = this.getCostOfLivingAdjustmentPercent();
    result = result * PRIME + ($costOfLivingAdjustmentPercent == null ? 43 : $costOfLivingAdjustmentPercent.hashCode());
    final java.lang.Object $dischargePaymentPercentAmount = this.getDischargePaymentPercentAmount();
    result = result * PRIME + ($dischargePaymentPercentAmount == null ? 43 : $dischargePaymentPercentAmount.hashCode());
    final java.lang.Object $drgRelativeWeight = this.getDrgRelativeWeight();
    result = result * PRIME + ($drgRelativeWeight == null ? 43 : $drgRelativeWeight.hashCode());
    final java.lang.Object $facilityCosts = this.getFacilityCosts();
    result = result * PRIME + ($facilityCosts == null ? 43 : $facilityCosts.hashCode());
    final java.lang.Object $facilitySpecificRate = this.getFacilitySpecificRate();
    result = result * PRIME + ($facilitySpecificRate == null ? 43 : $facilitySpecificRate.hashCode());
    final java.lang.Object $federalPayment = this.getFederalPayment();
    result = result * PRIME + ($federalPayment == null ? 43 : $federalPayment.hashCode());
    final java.lang.Object $federalRatePercent = this.getFederalRatePercent();
    result = result * PRIME + ($federalRatePercent == null ? 43 : $federalRatePercent.hashCode());
    final java.lang.Object $inpatientThreshold = this.getInpatientThreshold();
    result = result * PRIME + ($inpatientThreshold == null ? 43 : $inpatientThreshold.hashCode());
    final java.lang.Object $nationalLaborPercent = this.getNationalLaborPercent();
    result = result * PRIME + ($nationalLaborPercent == null ? 43 : $nationalLaborPercent.hashCode());
    final java.lang.Object $nationalNonLaborPercent = this.getNationalNonLaborPercent();
    result = result * PRIME + ($nationalNonLaborPercent == null ? 43 : $nationalNonLaborPercent.hashCode());
    final java.lang.Object $outlierPayment = this.getOutlierPayment();
    result = result * PRIME + ($outlierPayment == null ? 43 : $outlierPayment.hashCode());
    final java.lang.Object $outlierThresholdAmount = this.getOutlierThresholdAmount();
    result = result * PRIME + ($outlierThresholdAmount == null ? 43 : $outlierThresholdAmount.hashCode());
    final java.lang.Object $siteNeutralCostPayment = this.getSiteNeutralCostPayment();
    result = result * PRIME + ($siteNeutralCostPayment == null ? 43 : $siteNeutralCostPayment.hashCode());
    final java.lang.Object $siteNeutralIppsPayment = this.getSiteNeutralIppsPayment();
    result = result * PRIME + ($siteNeutralIppsPayment == null ? 43 : $siteNeutralIppsPayment.hashCode());
    final java.lang.Object $standardFullPayment = this.getStandardFullPayment();
    result = result * PRIME + ($standardFullPayment == null ? 43 : $standardFullPayment.hashCode());
    final java.lang.Object $standardShortStayOutlierPayment = this.getStandardShortStayOutlierPayment();
    result = result * PRIME + ($standardShortStayOutlierPayment == null ? 43 : $standardShortStayOutlierPayment.hashCode());
    final java.lang.Object $submittedDiagnosisRelatedGroup = this.getSubmittedDiagnosisRelatedGroup();
    result = result * PRIME + ($submittedDiagnosisRelatedGroup == null ? 43 : $submittedDiagnosisRelatedGroup.hashCode());
    return result;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public java.lang.String toString() {
    return "LtchPaymentData(adjustedPayment=" + this.getAdjustedPayment() + ", averageLengthOfStay=" + this.getAverageLengthOfStay() + ", blendYear=" + this.getBlendYear() + ", budgetNeutralityRate=" + this.getBudgetNeutralityRate() + ", changeOfTherapyIndicator=" + this.getChangeOfTherapyIndicator() + ", chargeThresholdAmount=" + this.getChargeThresholdAmount() + ", costOfLivingAdjustmentPercent=" + this.getCostOfLivingAdjustmentPercent() + ", dischargePaymentPercentAmount=" + this.getDischargePaymentPercentAmount() + ", drgRelativeWeight=" + this.getDrgRelativeWeight() + ", facilityCosts=" + this.getFacilityCosts() + ", facilitySpecificRate=" + this.getFacilitySpecificRate() + ", federalPayment=" + this.getFederalPayment() + ", federalRatePercent=" + this.getFederalRatePercent() + ", inpatientThreshold=" + this.getInpatientThreshold() + ", lengthOfStay=" + this.getLengthOfStay() + ", lifetimeReserveDaysUsed=" + this.getLifetimeReserveDaysUsed() + ", nationalLaborPercent=" + this.getNationalLaborPercent() + ", nationalNonLaborPercent=" + this.getNationalNonLaborPercent() + ", outlierPayment=" + this.getOutlierPayment() + ", outlierThresholdAmount=" + this.getOutlierThresholdAmount() + ", regularDaysUsed=" + this.getRegularDaysUsed() + ", siteNeutralCostPayment=" + this.getSiteNeutralCostPayment() + ", siteNeutralIppsPayment=" + this.getSiteNeutralIppsPayment() + ", standardFullPayment=" + this.getStandardFullPayment() + ", standardShortStayOutlierPayment=" + this.getStandardShortStayOutlierPayment() + ", submittedDiagnosisRelatedGroup=" + this.getSubmittedDiagnosisRelatedGroup() + ")";
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public LtchPaymentData() {
  }
}
