*BIN/PCN (All Changes);

options pageno=1 PS=64 LS=130 nocenter;

data BINPCN;

length
  contract_id             $5
  plan_id                 $3
  contract_year           $4
  effective_start_date    $10 
  effective_end_date      $10
  bin                     $8
  pcn                     $10
  created_date            $22
  created_by              $60;

infile '.\BIN_PCN_2023.txt' delimiter = '09'x
        dsd lrecl = 500 firstobs = 2 missover;

input
  contract_id	
  plan_id	
  contract_year	
  effective_start_date	
  effective_end_date	
  bin	
  pcn	
  created_date	
  created_by;

Label
  contract_id           = 'Contract ID'
  plan_id               = 'Plan ID'
  contract_year         = 'Contract Year'
  effective_start_date  = 'Effective Start Date'        
  effective_end_date    = 'Effective End Date'
  bin                   = 'Part D Sponsor NCPDP Processor ID Number'
  pcn                   = 'Part D Sponsor Processor Control Number'  
  created_date          = 'Creation Date'	
  created_by            = 'Created By';
run;

proc sort data = BINPCN;
by contract_id plan_id bin pcn created_date;
run;

proc print data = BINPCN (obs = 25);
title 'BIN/PCN (All Changes)';
run;

proc contents data = BINPCN;
title 'BIN/PCN (All Changes)';
run;
