/*
 * Decompiled with CFR 0.152.
 */
package com.mmm.his.cer.foundation.utility;

import com.mmm.his.cer.foundation.ComponentName;
import com.mmm.his.cer.foundation.ComponentPackage;
import com.mmm.his.cer.foundation.ComponentVersion;
import com.mmm.his.cer.foundation.exception.FoundationRuntimeException;

public final class ComponentClassUtil {
    public static final String PACKAGE_SEPARATOR = ".";
    private static final String COMPONENT_NAME_LOCATION = "%s";
    private static final String COMPONENT_VERSION_LOCATION = "%s";
    private static final String COMPONENT_NAME_AND_VERSION_LOCATION = "%s.%s";
    public static final ComponentPackage DEFAULT_BASE_PACKAGE_CONFIG = new ComponentPackage(){

        @Override
        public String getBasePackagePath() {
            return "com.mmm.his.cer";
        }
    };
    public static final String COMPONENT_CLASS_POSTFIX = "Component";
    public static final String VERSION_CLASS_POSTFIX = "Version";

    private ComponentClassUtil() {
    }

    public static final String getComponentClassPackagePath(ComponentName componentName, ComponentVersion componentVersion) {
        ComponentPackage basePackageConfig = ComponentClassUtil.getBasePackageConfig(componentName, componentVersion);
        String basePackage = basePackageConfig.getBasePackagePath();
        if (!basePackage.endsWith(PACKAGE_SEPARATOR)) {
            basePackage = basePackage + PACKAGE_SEPARATOR;
        }
        basePackage = basePackage + COMPONENT_NAME_AND_VERSION_LOCATION;
        return String.format(basePackage, componentName.getName(), componentVersion.getPackageValue()).toLowerCase();
    }

    public static final String getVersionClassPackagePath(ComponentName componentName) {
        ComponentPackage basePackageConfig = ComponentClassUtil.getBasePackageConfig(componentName, null);
        String basePackage = basePackageConfig.getBasePackagePath();
        if (!basePackage.endsWith(PACKAGE_SEPARATOR)) {
            basePackage = basePackage + PACKAGE_SEPARATOR;
        }
        basePackage = basePackage + "%s";
        return String.format(basePackage, componentName.getName()).toLowerCase();
    }

    public static final String getFullyQualifiedComponentClassPath(ComponentName componentName, ComponentVersion componentVersion) {
        return ComponentClassUtil.getComponentClassPackagePath(componentName, componentVersion) + PACKAGE_SEPARATOR + ComponentClassUtil.getClassName(componentName, COMPONENT_CLASS_POSTFIX);
    }

    public static final String getFullyQualifiedComponentVersionClassPath(ComponentName componentName) {
        return ComponentClassUtil.getVersionClassPackagePath(componentName) + PACKAGE_SEPARATOR + ComponentClassUtil.getClassName(componentName, VERSION_CLASS_POSTFIX);
    }

    public static final String getClassName(ComponentName componentName, String postfix) {
        String format = "%s%s";
        return String.format(format, componentName.getName(), postfix);
    }

    private static final ComponentPackage getBasePackageConfig(ComponentName componentName, ComponentVersion componentVersion) {
        ComponentPackage fromName = null;
        if (componentName instanceof ComponentPackage) {
            fromName = (ComponentPackage)((Object)componentName);
        }
        ComponentPackage fromVersion = null;
        if (componentVersion instanceof ComponentPackage) {
            fromVersion = (ComponentPackage)((Object)componentVersion);
        }
        if (fromName != null && fromVersion != null && !fromName.getBasePackagePath().equalsIgnoreCase(fromVersion.getBasePackagePath())) {
            throw new FoundationRuntimeException("The base package path implementations " + ComponentPackage.class.getName() + " for " + fromName.getClass().getName() + " and " + fromVersion.getClass().getName() + " do not match.");
        }
        if (fromName != null) {
            return fromName;
        }
        if (fromVersion != null) {
            return fromVersion;
        }
        return DEFAULT_BASE_PACKAGE_CONFIG;
    }
}

