/*
 * Decompiled with CFR 0.152.
 */
package com.mmm.his.cer.utility.farser.lexer;

import com.mmm.his.cer.utility.farser.lexer.CommonTokenType;
import com.mmm.his.cer.utility.farser.lexer.TokenTypeLookup;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;

public interface TokenType<T extends Enum<T>> {
    public String name();

    public Optional<String> getValue();

    public Optional<CommonTokenType> getCommonTokenType();

    public static <T extends TokenType<?>> Optional<T> getForCommonType(Class<T> tokenTypeClass, CommonTokenType commonType) {
        Map<CommonTokenType, T> lookup = TokenTypeLookup.getCommonTypeLookupMap(tokenTypeClass);
        if (!lookup.containsKey((Object)commonType)) {
            return Optional.empty();
        }
        return Optional.ofNullable((TokenType)lookup.get((Object)commonType));
    }

    public static <T extends TokenType<?>> T getForCommonTypeMandatory(Class<T> tokenTypeClass, CommonTokenType commonType) {
        Optional<T> tokenTypeTmp = TokenType.getForCommonType(tokenTypeClass, commonType);
        if (!tokenTypeTmp.isPresent()) {
            throw new IllegalArgumentException("No implementation with " + ((Object)((Object)commonType)).getClass().getSimpleName() + "." + commonType.name() + " found in " + tokenTypeClass.getSimpleName());
        }
        return (T)((TokenType)tokenTypeTmp.get());
    }

    public static <T extends TokenType<?>> Optional<T> getForValue(Class<T> tokenTypeClass, String value) {
        Map<String, T> lookup = TokenTypeLookup.getValueLookupMap(tokenTypeClass);
        if (!lookup.containsKey(value)) {
            return Optional.empty();
        }
        return Optional.ofNullable((TokenType)lookup.get(value));
    }

    public static <T extends TokenType<?>> T[] values(Class<T> tokenTypeClass) {
        if (!tokenTypeClass.isEnum()) {
            throw new IllegalArgumentException(tokenTypeClass.getName() + " has to be an enumeration");
        }
        return (TokenType[])tokenTypeClass.getEnumConstants();
    }

    public static Pattern createTokenPattern(Class<? extends TokenType<?>> enumClass) {
        return TokenTypeLookup.getPattern(enumClass);
    }
}

