/*
 * Decompiled with CFR 0.152.
 */
package com.mmm.his.cer.utility.farser.lexer;

import com.mmm.his.cer.utility.farser.lexer.CommonTokenType;
import com.mmm.his.cer.utility.farser.lexer.FarserException;
import com.mmm.his.cer.utility.farser.lexer.TokenType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TokenTypeLookup {
    private static final Map<Class<?>, Map<String, TokenType<?>>> valueLookupMap = new HashMap();
    private static final Map<Class<TokenType<?>>, Map<CommonTokenType, TokenType<?>>> commonTypeLookupMap = new HashMap();
    private static final Map<Class<TokenType<?>>, Pattern> patternLookupMap = new HashMap();
    private static final Pattern wordCharPattern = Pattern.compile("\\w");

    private TokenTypeLookup() {
    }

    protected static <T extends TokenType<?>> Map<String, T> getValueLookupMap(Class<T> enumClass) {
        Map<String, T> lookupMap;
        if (!enumClass.isEnum()) {
            throw new IllegalArgumentException(enumClass.getName() + " has to be an enumeration");
        }
        if (valueLookupMap.containsKey(enumClass)) {
            Map<String, TokenType<?>> lookupMap2 = valueLookupMap.get(enumClass);
            return lookupMap2;
        }
        Map<String, T> lookupMapTmp = lookupMap = TokenTypeLookup.buildValueLookupMap(enumClass);
        Class<T> enumClassTmp = enumClass;
        valueLookupMap.put(enumClassTmp, Collections.unmodifiableMap(lookupMapTmp));
        return lookupMap;
    }

    private static <T extends TokenType<?>> Map<String, T> buildValueLookupMap(Class<T> enumClass) {
        HashMap<String, TokenType> lookupMap = new HashMap<String, TokenType>();
        for (TokenType enumConst : (TokenType[])enumClass.getEnumConstants()) {
            Optional<String> value = enumConst.getValue();
            if (!value.isPresent()) continue;
            String key = value.get();
            if (lookupMap.containsKey(key)) {
                throw new FarserException("Duplicate keys are not allowed. Key '" + key + "' alredy exists for " + ((TokenType)lookupMap.get(key)).getClass().getName() + "." + enumConst.name());
            }
            lookupMap.put(key, enumConst);
        }
        return lookupMap;
    }

    protected static <T extends TokenType<?>> Map<CommonTokenType, T> getCommonTypeLookupMap(Class<T> enumClass) {
        if (!enumClass.isEnum()) {
            throw new IllegalArgumentException(enumClass.getName() + " has to be an enumeration");
        }
        if (commonTypeLookupMap.containsKey(enumClass)) {
            Map<CommonTokenType, TokenType<?>> lookupMap = commonTypeLookupMap.get(enumClass);
            return lookupMap;
        }
        Map<CommonTokenType, T> lookupMap = TokenTypeLookup.buildCommonTypeLookupMap(enumClass);
        TokenTypeLookup.validateCommonTypeLookupMap(enumClass, lookupMap);
        Map<CommonTokenType, T> lookupMapTmp = lookupMap;
        Class<T> enumClassTmp = enumClass;
        commonTypeLookupMap.put(enumClassTmp, Collections.unmodifiableMap(lookupMapTmp));
        return lookupMap;
    }

    private static <T extends TokenType<?>> Map<CommonTokenType, T> buildCommonTypeLookupMap(Class<T> enumClass) {
        EnumMap<CommonTokenType, TokenType> lookupMap = new EnumMap<CommonTokenType, TokenType>(CommonTokenType.class);
        for (TokenType enumConst : (TokenType[])enumClass.getEnumConstants()) {
            Optional<CommonTokenType> commonType = enumConst.getCommonTokenType();
            if (!commonType.isPresent()) continue;
            CommonTokenType key = commonType.get();
            if (lookupMap.containsKey((Object)key)) {
                throw new FarserException("Duplicate keys are not allowed. Key '" + (Object)((Object)key) + "' alredy exists for " + ((TokenType)lookupMap.get((Object)key)).getClass().getName() + "." + enumConst.name());
            }
            lookupMap.put(key, enumConst);
        }
        return lookupMap;
    }

    private static <T extends TokenType<?>> void validateCommonTypeLookupMap(Class<T> enumClass, Map<CommonTokenType, T> lookupMap) {
        for (CommonTokenType commonType : CommonTokenType.values()) {
            if (!commonType.isMandatory() || lookupMap.containsKey((Object)commonType)) continue;
            throw new FarserException(((Object)((Object)commonType)).getClass().getName() + "." + commonType.name() + " is mandatory. No token found in " + enumClass.getName() + " which is marked with this mandatory common type.");
        }
    }

    public static Pattern getPattern(Class<? extends TokenType<?>> enumClass) {
        if (!enumClass.isEnum()) {
            throw new IllegalArgumentException(enumClass.getName() + " has to be an enumeration");
        }
        if (patternLookupMap.containsKey(enumClass)) {
            return patternLookupMap.get(enumClass);
        }
        Pattern pattern = TokenTypeLookup.buildPattern(enumClass);
        Class<TokenType<?>> enumClassTmp = enumClass;
        patternLookupMap.put(enumClassTmp, pattern);
        return pattern;
    }

    private static Pattern buildPattern(Class<? extends TokenType<?>> enumClass) {
        ArrayList delimiters = new ArrayList();
        for (TokenType<?> enumConst : enumClass.getEnumConstants()) {
            Optional<CommonTokenType> commonType = enumConst.getCommonTokenType();
            if (commonType.isPresent() && (commonType.get() == CommonTokenType.ATOM || commonType.get() == CommonTokenType.SPACE)) continue;
            Optional<String> value = enumConst.getValue();
            value.ifPresent(delimiters::add);
        }
        delimiters.sort((o1, o2) -> -o1.compareTo((String)o2));
        StringJoiner sjSymbol = new StringJoiner("|", "(", ")");
        StringJoiner sjCharacters = new StringJoiner("|", "\\b(", ")\\b");
        int symbolCount = 0;
        int charCount = 0;
        sjSymbol.add("(?: )+");
        ++symbolCount;
        for (String token : delimiters) {
            if (TokenTypeLookup.containsWordChar(token)) {
                sjCharacters.add(Pattern.quote(token));
                ++charCount;
                continue;
            }
            sjSymbol.add(Pattern.quote(token));
            ++symbolCount;
        }
        StringJoiner sjPattern = new StringJoiner("|");
        if (symbolCount > 0) {
            sjPattern.add(sjSymbol.toString());
        }
        if (charCount > 0) {
            sjPattern.add(sjCharacters.toString());
        }
        return Pattern.compile(sjPattern.toString(), 2);
    }

    private static boolean containsWordChar(String str) {
        Matcher matcher = wordCharPattern.matcher(str);
        return matcher.find();
    }
}

