/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.mainframe.utility.v310.format;

import gov.agency.mainframe.utility.v310.util.ValueAlignment;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

public final class FixedWidthField<D> {
    public static final int FIRST_CHARACTER_POSITION = 1;
    private static final ValueAlignment DEFAULT_ALIGNMENT = ValueAlignment.RIGHT;
    private final String name;
    private final int startCharacterPosition;
    private final int endCharacterPosition;
    private final ValueAlignment alignment;
    private final Character fill;
    private final Class<D> dataType;
    private final Function<String, D> fromInputStringConversion;
    private final Function<D, String> toOutputStringConversion;

    private FixedWidthField(String name, int startCharacterPosition, int endCharacterPosition, ValueAlignment alignment, Character fill, Class<D> dataType, Function<String, D> fromInputStringConversion, Function<D, String> toOutputStringConversion) {
        Objects.requireNonNull(name, "A field name is required");
        Objects.requireNonNull(alignment, "A value alignment has to be provided");
        this.name = name;
        if (startCharacterPosition <= 0) {
            throw new IllegalArgumentException("Character position " + startCharacterPosition + " is not valid. First character starts with " + 1);
        }
        if (endCharacterPosition < startCharacterPosition) {
            throw new IllegalArgumentException("End character position " + endCharacterPosition + " has to be after start character position " + startCharacterPosition);
        }
        this.startCharacterPosition = startCharacterPosition;
        this.endCharacterPosition = endCharacterPosition;
        this.alignment = alignment;
        this.fill = fill;
        if (dataType != null && !String.class.isAssignableFrom(dataType) && fromInputStringConversion == null && toOutputStringConversion == null) {
            throw new IllegalArgumentException("For a data type other than " + String.class.getName() + ", a input and output string conversion function needs to be provided.");
        }
        this.dataType = dataType;
        this.fromInputStringConversion = fromInputStringConversion;
        this.toOutputStringConversion = toOutputStringConversion;
    }

    public FixedWidthField(String name, int startCharacterPosition, int endCharacterPosition) {
        this(name, startCharacterPosition, endCharacterPosition, DEFAULT_ALIGNMENT, null, null, null, null);
    }

    public FixedWidthField(String name, int startCharacterPosition, int endCharacterPosition, ValueAlignment alignment, Character fill) {
        this(name, startCharacterPosition, endCharacterPosition, alignment, fill, null, null, null);
    }

    public static FixedWidthFieldBuilder<String> builder() {
        return new FixedWidthFieldBuilder<String>();
    }

    public static <D> FixedWidthFieldBuilder<D> builder(Class<D> dataType) {
        return new FixedWidthFieldBuilder<D>(dataType);
    }

    public FixedWidthFieldBuilder<D> toBuilder() {
        return new FixedWidthFieldBuilder(this);
    }

    public String getName() {
        return this.name;
    }

    public int getStartCharacterPosition() {
        return this.startCharacterPosition;
    }

    public int getEndCharacterPosition() {
        return this.endCharacterPosition;
    }

    public int getFieldWidth() {
        return this.endCharacterPosition - this.startCharacterPosition + 1;
    }

    public ValueAlignment getAlignment() {
        return this.alignment;
    }

    public Optional<Character> getFill() {
        return Optional.ofNullable(this.fill);
    }

    public Class<D> getDataType() {
        return this.dataType;
    }

    public Function<String, D> getFromInputStringConversion() {
        return this.fromInputStringConversion;
    }

    public Function<D, String> getToOutputStringConversion() {
        return this.toOutputStringConversion;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.startCharacterPosition, this.endCharacterPosition, this.alignment, this.fill, this.dataType, this.fromInputStringConversion, this.toOutputStringConversion});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!(obj instanceof FixedWidthField)) {
            return false;
        }
        FixedWidthField fieldObj = (FixedWidthField)obj;
        return Objects.equals(this.name, fieldObj.name) && Objects.equals(this.startCharacterPosition, fieldObj.startCharacterPosition) && Objects.equals(this.endCharacterPosition, fieldObj.endCharacterPosition) && Objects.equals((Object)this.alignment, (Object)fieldObj.alignment) && Objects.equals(this.fill, fieldObj.fill) && Objects.equals(this.dataType, fieldObj.dataType) && Objects.equals(this.fromInputStringConversion, fieldObj.fromInputStringConversion) && Objects.equals(this.toOutputStringConversion, fieldObj.toOutputStringConversion);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name);
        sb.append(": ");
        if (this.dataType != null) {
            sb.append("<");
            sb.append(this.dataType.getSimpleName());
            sb.append("> ");
        }
        sb.append(this.startCharacterPosition);
        sb.append("->");
        sb.append(this.endCharacterPosition);
        sb.append(" (");
        sb.append(this.getFieldWidth());
        sb.append(")");
        return sb.toString();
    }

    static /* synthetic */ ValueAlignment access$000() {
        return DEFAULT_ALIGNMENT;
    }

    public static class OrderedByStart
    implements Comparator<FixedWidthField<?>> {
        @Override
        public int compare(FixedWidthField<?> o1, FixedWidthField<?> o2) {
            if (((FixedWidthField)o1).startCharacterPosition > ((FixedWidthField)o2).startCharacterPosition) {
                return 1;
            }
            if (((FixedWidthField)o1).startCharacterPosition < ((FixedWidthField)o2).startCharacterPosition) {
                return -1;
            }
            return 0;
        }
    }

    public static class FixedWidthFieldBuilder<D> {
        private String name;
        private int startCharacterPosition;
        private int endCharacterPosition;
        private ValueAlignment alignment = FixedWidthField.access$000();
        private Character fill;
        private Class<D> dataType;
        private Function<String, D> fromInputStringConversion;
        private Function<D, String> toOutputStringConversion;

        protected FixedWidthFieldBuilder() {
        }

        protected FixedWidthFieldBuilder(Class<D> dataType) {
            this.dataType = dataType;
        }

        protected FixedWidthFieldBuilder(FixedWidthField<D> copy) {
            if (copy != null) {
                this.name = ((FixedWidthField)copy).name;
                this.startCharacterPosition = ((FixedWidthField)copy).startCharacterPosition;
                this.endCharacterPosition = ((FixedWidthField)copy).endCharacterPosition;
                this.alignment = ((FixedWidthField)copy).alignment;
                this.fill = ((FixedWidthField)copy).fill;
                this.dataType = ((FixedWidthField)copy).dataType;
                this.fromInputStringConversion = ((FixedWidthField)copy).fromInputStringConversion;
                this.toOutputStringConversion = ((FixedWidthField)copy).toOutputStringConversion;
            }
        }

        public FixedWidthFieldBuilder<D> withName(String name) {
            this.name = name;
            return this;
        }

        public FixedWidthFieldBuilder<D> withCharacterPosition(int startCharacterPosition, int endCharacterPosition) {
            this.startCharacterPosition = startCharacterPosition;
            this.endCharacterPosition = endCharacterPosition;
            return this;
        }

        public FixedWidthFieldBuilder<D> withFieldWidth(int startCharacterPosition, int fieldWidth) {
            this.startCharacterPosition = startCharacterPosition;
            this.endCharacterPosition = startCharacterPosition + fieldWidth - 1;
            return this;
        }

        public FixedWidthFieldBuilder<D> withStartCharacterPosition(int startCharacterPosition) {
            this.startCharacterPosition = startCharacterPosition;
            return this;
        }

        public FixedWidthFieldBuilder<D> withEndCharacterPosition(int endCharacterPosition) {
            this.endCharacterPosition = endCharacterPosition;
            return this;
        }

        public FixedWidthFieldBuilder<D> withAlignment(ValueAlignment alignment) {
            this.alignment = alignment;
            return this;
        }

        public FixedWidthFieldBuilder<D> withFill(Character fill) {
            this.fill = fill;
            return this;
        }

        public FixedWidthFieldBuilder<D> withFromInputStringConversion(Function<String, D> fromInputStringConversion) {
            this.fromInputStringConversion = fromInputStringConversion;
            return this;
        }

        public FixedWidthFieldBuilder<D> withToOutputStringConversion(Function<D, String> toOutputStringConversion) {
            this.toOutputStringConversion = toOutputStringConversion;
            return this;
        }

        public FixedWidthField<D> build() {
            return new FixedWidthField(this.name, this.startCharacterPosition, this.endCharacterPosition, this.alignment, this.fill, this.dataType, this.fromInputStringConversion, this.toOutputStringConversion);
        }
    }
}

