/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.mainframe.utility.v310.format;

import gov.agency.mainframe.utility.v310.format.FixedWidthField;
import gov.agency.mainframe.utility.v310.format.FixedWidthFormatFailure;
import gov.agency.mainframe.utility.v310.util.StringUtilities;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;

public final class FormatUtilities {
    private static final Comparator<FixedWidthField<?>> FIELD_ORDER_ASCENDING = new FixedWidthField.OrderedByStart();
    private static final Function<Object, String> DEFAULT_TO_OUTPUT_CONVERSION = String::valueOf;

    private FormatUtilities() {
    }

    private static <D> D convertFromInputString(FixedWidthField<D> field, String inputString) {
        return FormatUtilities.convertFromInputString(field.getName(), field.getDataType(), field.getFromInputStringConversion(), inputString);
    }

    private static <D> D convertFromInputString(String fieldName, Class<D> dataType, Function<String, D> fromInputStringConversion, String inputString) {
        if (fromInputStringConversion == null) {
            if (dataType != null && !dataType.isAssignableFrom(String.class)) {
                throw new FixedWidthFormatFailure("Field '" + fieldName + "' is defined as type " + dataType.getName() + " and requires a input string conversion function");
            }
            String out = inputString;
            return (D)out;
        }
        try {
            return fromInputStringConversion.apply(inputString);
        }
        catch (Exception exc) {
            throw new FixedWidthFormatFailure("Failed to convert input string from field '" + fieldName + "': '" + inputString + "'", exc);
        }
    }

    private static <D> String convertToOutputString(FixedWidthField<D> field, D value) {
        return FormatUtilities.convertToOutputString(field.getName(), field.getToOutputStringConversion(), value);
    }

    private static <D> String convertToOutputString(String fieldName, Function<D, String> toOutputStringConversion, D value) {
        if (toOutputStringConversion == null) {
            if (value instanceof String) {
                return (String)value;
            }
            if (value == null) {
                return null;
            }
            return DEFAULT_TO_OUTPUT_CONVERSION.apply(value);
        }
        try {
            return toOutputStringConversion.apply(value);
        }
        catch (Exception exc) {
            throw new FixedWidthFormatFailure("Failed to convert value from field '" + fieldName + "': " + value, exc);
        }
    }

    private static <D> String convertAnyTypeToOutputString(FixedWidthField<D> field, Object value) {
        return FormatUtilities.convertAnyTypeToOutputString(field.getName(), field.getDataType(), field.getToOutputStringConversion(), value);
    }

    private static <D> String convertAnyTypeToOutputString(String fieldName, Class<D> dataType, Function<D, String> toOutputStringConversion, Object value) {
        if (value == null) {
            return FormatUtilities.convertToOutputString(fieldName, toOutputStringConversion, null);
        }
        if (dataType != null && !dataType.isAssignableFrom(value.getClass())) {
            throw new FixedWidthFormatFailure("The value in field '" + fieldName + "' is not of a type applicable to the field definition. Type of value is " + value.getClass().getName() + ", value is '" + value + "', type of field definition is " + dataType.getName());
        }
        Object tmp = value;
        return FormatUtilities.convertToOutputString(fieldName, toOutputStringConversion, tmp);
    }

    public static <D> D parseValue(FixedWidthField<D> fieldDefinition, String value) {
        return FormatUtilities.convertFromInputString(fieldDefinition, value);
    }

    public static String formatGenericValue(FixedWidthField<?> fieldDefinition, Object value) {
        String str = FormatUtilities.convertAnyTypeToOutputString(fieldDefinition, value);
        return StringUtilities.formatValue(str, fieldDefinition.getFieldWidth(), fieldDefinition.getAlignment(), fieldDefinition.getFill().orElse(null));
    }

    public static Optional<String> formatValue(FixedWidthField<?> fieldDefinition, Map<String, Object> data) {
        String fieldName = fieldDefinition.getName();
        if (data.containsKey(fieldName)) {
            Object value = data.get(fieldName);
            String formattedValue = FormatUtilities.formatGenericValue(fieldDefinition, value);
            return Optional.of(formattedValue);
        }
        return Optional.empty();
    }

    public static <D> String formatValue(FixedWidthField<D> fieldDefinition, D value) {
        String str = FormatUtilities.convertToOutputString(fieldDefinition, value);
        return StringUtilities.formatValue(str, fieldDefinition.getFieldWidth(), fieldDefinition.getAlignment(), fieldDefinition.getFill().orElse(null));
    }

    public static String formatFixedWidthString(FixedWidthField<?>[] fields, Map<String, Object> data) {
        return FormatUtilities.formatFixedWidthString(Arrays.asList(fields), null, data);
    }

    public static String formatFixedWidthString(FixedWidthField<?>[] fields, Integer maxCharacterWidth, Map<String, Object> data) {
        return FormatUtilities.formatFixedWidthString(Arrays.asList(fields), maxCharacterWidth, data);
    }

    public static String formatFixedWidthString(List<FixedWidthField<?>> fields, Map<String, Object> data) {
        return FormatUtilities.formatFixedWidthString(fields, null, data);
    }

    public static String formatFixedWidthString(List<FixedWidthField<?>> fields, Integer maxCharacterWidth, Map<String, Object> data) {
        if (maxCharacterWidth == null) {
            Optional<FixedWidthField<?>> mayBeMax = fields.stream().max(FIELD_ORDER_ASCENDING);
            if (!mayBeMax.isPresent()) {
                return "";
            }
            maxCharacterWidth = mayBeMax.get().getEndCharacterPosition();
        }
        StringBuilder formatted = StringUtilities.newBlankBuilder(maxCharacterWidth);
        for (FixedWidthField<?> field : fields) {
            Optional<String> mayBeValue = FormatUtilities.formatValue(field, data);
            if (!mayBeValue.isPresent()) continue;
            int start = field.getStartCharacterPosition();
            int end = field.getEndCharacterPosition();
            StringUtilities.setBoundedBufferValue(formatted, mayBeValue.get(), start, end);
        }
        return formatted.toString();
    }

    public static Map<String, Object> parseFixedWidthString(FixedWidthField<?>[] fields, String fixedWidthRecord) {
        return FormatUtilities.parseFixedWidthString(Arrays.asList(fields), fixedWidthRecord);
    }

    public static Map<String, Object> parseFixedWidthString(List<FixedWidthField<?>> fields, String fixedWidthRecord) {
        LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
        for (FixedWidthField<?> field : fields) {
            String fieldName = field.getName();
            Object value = FormatUtilities.extractFixedWidthValue(field, fixedWidthRecord);
            data.put(fieldName, value);
        }
        return data;
    }

    public static String extractFixedWidthStringValue(FixedWidthField<?> fieldDefinition, String fixedWidthRecord) {
        if (fixedWidthRecord == null) {
            return "";
        }
        int start = fieldDefinition.getStartCharacterPosition() - 1;
        int end = Math.min(fieldDefinition.getEndCharacterPosition(), fixedWidthRecord.length());
        return fixedWidthRecord.substring(start, end);
    }

    public static String extractFixedWidthStringValueTrimmed(FixedWidthField<?> fieldDefinition, String fixedWidthRecord) {
        String value = FormatUtilities.extractFixedWidthStringValue(fieldDefinition, fixedWidthRecord);
        Optional<Character> mayBeFiller = fieldDefinition.getFill();
        if (mayBeFiller.isPresent()) {
            return StringUtilities.trim(value, fieldDefinition.getAlignment(), mayBeFiller.get().charValue());
        }
        return value;
    }

    public static <D> D extractFixedWidthValue(FixedWidthField<D> fieldDefinition, String fixedWidthRecord) {
        String value = FormatUtilities.extractFixedWidthStringValueTrimmed(fieldDefinition, fixedWidthRecord);
        return FormatUtilities.parseValue(fieldDefinition, value);
    }
}

