/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.mainframe.utility.v310.util;

import gov.agency.mainframe.utility.v310.util.ValueAlignment;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;

public final class StringUtilities {
    public static final int FIRST_CHARACTER_POSITION = 1;

    private StringUtilities() {
    }

    public static void setBoundedBufferValue(StringBuilder target, String value, int startCharacterPosition, int endCharacterPosition) {
        int startIndex;
        int endIndex;
        Objects.requireNonNull(target, "Target buffer can not be NULL");
        if (value == null || value.isEmpty()) {
            return;
        }
        if (startCharacterPosition < 1) {
            throw new StringIndexOutOfBoundsException("First character position is 1. Provided: " + startCharacterPosition);
        }
        if (startCharacterPosition > target.length()) {
            throw new StringIndexOutOfBoundsException("First character position (" + startCharacterPosition + ") exceeds buffer size (" + target.length() + ")");
        }
        if (endCharacterPosition > target.length()) {
            endCharacterPosition = target.length();
        }
        if ((endIndex = Math.min(endCharacterPosition, (startIndex = startCharacterPosition - 1) + value.length())) >= startIndex) {
            int fillWidth = endIndex - startIndex;
            if (value.length() > fillWidth) {
                value = value.substring(0, fillWidth);
            }
        }
        target.replace(startIndex, endIndex, value);
    }

    public static StringBuilder newBlankBuilder(int size) {
        return StringUtilities.newBlankBuilder(null, size);
    }

    public static StringBuilder newBlankBuilder(String startString, int totalSize) {
        StringBuilder sb = new StringBuilder(totalSize);
        if (startString == null) {
            startString = "";
        } else {
            if (startString.length() > totalSize) {
                throw new IllegalArgumentException("Start string (" + startString.length() + ") can not be longer than max size (" + totalSize + ")");
            }
            sb.append(startString);
        }
        char[] blanks = new char[totalSize - startString.length()];
        Arrays.fill(blanks, ' ');
        sb.append(blanks);
        return sb;
    }

    public static String formatValue(String value, int valueWidth, ValueAlignment alignment, Character fill) {
        String stringValue;
        String string = stringValue = value != null ? value : "";
        if (stringValue.length() > valueWidth) {
            return stringValue.substring(0, valueWidth);
        }
        if (fill == null) {
            fill = Character.valueOf(' ');
        }
        if (alignment == null || alignment == ValueAlignment.RIGHT) {
            return StringUtilities.padLeft(stringValue, valueWidth, fill);
        }
        if (alignment == ValueAlignment.LEFT) {
            return StringUtilities.padRight(stringValue, valueWidth, fill);
        }
        throw new IllegalArgumentException("Not implemented for alignment " + (Object)((Object)alignment));
    }

    public static String padLeft(String value, int valueWidth, Character fill) {
        String stringValue;
        String string = stringValue = value != null ? value : "";
        if (stringValue.length() == valueWidth) {
            return stringValue;
        }
        StringBuilder formattedValue = new StringBuilder(valueWidth);
        if (fill != null) {
            for (int spaceToFill = valueWidth - stringValue.length(); spaceToFill > 0; --spaceToFill) {
                formattedValue.append(fill);
            }
        }
        formattedValue.append(stringValue);
        return formattedValue.toString();
    }

    public static String padRight(String value, int valueWidth, Character fill) {
        String stringValue;
        String string = stringValue = value != null ? value : "";
        if (stringValue.length() == valueWidth) {
            return stringValue;
        }
        StringBuilder formattedValue = new StringBuilder(valueWidth);
        formattedValue.append(stringValue);
        if (fill != null) {
            for (int spaceToFill = valueWidth - stringValue.length(); spaceToFill > 0; --spaceToFill) {
                formattedValue.append(fill);
            }
        }
        return formattedValue.toString();
    }

    public static String trim(String value, ValueAlignment valueAlignment, char trimChar) {
        if (valueAlignment == ValueAlignment.RIGHT) {
            return StringUtilities.trimLeft(value, 1, trimChar);
        }
        if (valueAlignment == ValueAlignment.LEFT) {
            return StringUtilities.trimRight(value, 1, trimChar);
        }
        return value;
    }

    public static String trimLeft(String stringToTrim, int preserveNumChars, char trimChar) {
        char charFromValueToTrim;
        int charIndex;
        if (stringToTrim == null) {
            return null;
        }
        for (charIndex = 0; charIndex < stringToTrim.length() && stringToTrim.length() - charIndex > preserveNumChars && (charFromValueToTrim = stringToTrim.charAt(charIndex)) == trimChar; ++charIndex) {
        }
        return stringToTrim.substring(charIndex);
    }

    public static String trimRight(String stringToTrim, int preserveNumChars, char trimChar) {
        char charFromValueToTrim;
        int charIndex;
        if (stringToTrim == null) {
            return null;
        }
        for (charIndex = stringToTrim.length() - 1; charIndex >= 0 && charIndex >= preserveNumChars && (charFromValueToTrim = stringToTrim.charAt(charIndex)) == trimChar; --charIndex) {
        }
        return stringToTrim.substring(0, charIndex + 1);
    }

    public static boolean isNullOrEmpty(String str) {
        return str == null || str.trim().isEmpty();
    }

    public static String trimWithNullCheck(String str) {
        return str == null ? "" : str.trim();
    }

    public static String toStringWithNullCheck(Object obj) {
        return obj == null ? "" : String.valueOf(obj);
    }

    public static Optional<Integer> parseAsInteger(String stringToConvert) {
        if (stringToConvert == null) {
            return Optional.empty();
        }
        try {
            Integer convertedInt = Integer.parseInt(stringToConvert.trim());
            return Optional.of(convertedInt);
        }
        catch (NumberFormatException exc) {
            return Optional.empty();
        }
    }

    public static List<String> splitFixedWidthValues(String fixedWidthString, int valueWidth) {
        return StringUtilities.splitFixedWidthValues(fixedWidthString, valueWidth, (index, value) -> value.trim());
    }

    public static <R> List<R> splitFixedWidthValues(String fixedWidthString, int valueWidth, BiFunction<Integer, String, R> valueProcessor) {
        if (fixedWidthString == null || fixedWidthString.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<R> data = new ArrayList<R>();
        for (int valueIndex = 0; valueIndex < fixedWidthString.length(); valueIndex += valueWidth) {
            int endIndex = valueIndex + valueWidth;
            String value = endIndex <= fixedWidthString.length() ? fixedWidthString.substring(valueIndex, endIndex) : fixedWidthString.substring(valueIndex);
            R processed = valueProcessor.apply(valueIndex, value);
            data.add(processed);
        }
        return data;
    }

    public static String joinFixedWidthValues(List<String> values, int valueWidth) {
        return StringUtilities.joinFixedWidthValues(values, valueWidth, (index, val) -> StringUtilities.toStringWithNullCheck(val));
    }

    public static <R> String joinFixedWidthValues(List<R> values, int valueWidth, BiFunction<Integer, R, String> valueProcessor) {
        if (values == null || values.isEmpty()) {
            return "";
        }
        int totalWidth = values.size() * valueWidth;
        StringBuilder joined = StringUtilities.newBlankBuilder(totalWidth);
        int currentStartPosition = 1;
        for (int valueIndex = 0; valueIndex < values.size(); ++valueIndex) {
            String stringValue = valueProcessor.apply(valueIndex, values.get(valueIndex));
            int end = currentStartPosition + valueWidth;
            StringUtilities.setBoundedBufferValue(joined, stringValue, currentStartPosition, end);
            currentStartPosition = end;
        }
        return joined.toString();
    }

    public static String convertFromCharacterSet(String buffer, Charset charSet) {
        if (buffer == null || charSet == null) {
            return buffer;
        }
        return new String(buffer.getBytes(), charSet);
    }
}

