/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.msdrg.model;

import com.mmm.his.cer.foundation.model.GfcPoa;
import gov.agency.msdrg.model.Attribute;
import gov.agency.msdrg.model.MsdrgCode;
import gov.agency.msdrg.model.MsdrgHac;
import gov.agency.msdrg.model.enumeration.MsdrgCodeSeverityFlag;
import gov.agency.msdrg.model.enumeration.MsdrgDischargeStatus;
import gov.agency.msdrg.model.enumeration.MsdrgGroupingImpact;
import gov.agency.msdrg.model.enumeration.MsdrgHacUsage;
import gov.agency.msdrg.model.enumeration.MsdrgMaskBuildingConditions;
import gov.agency.msdrg.model.enumeration.MsdrgPoaErrorCode;
import gov.agency.msdrg.model.enumeration.MsdrgSeverity;
import gov.agency.msdrg.model.transfer.MsdrgInputDxCode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;

public class MsdrgDiagnosisCode
implements MsdrgCode {
    private final MsdrgInputDxCode inputDxCode;
    private boolean affectDrg;
    private boolean isExcluded;
    private boolean isValidCode;
    private Set<Attribute> attributes = new HashSet<Attribute>();
    private Set<Attribute> dxCatAttributes = new HashSet<Attribute>();
    private Set<Attribute> hacAttributes = new HashSet<Attribute>();
    private MsdrgSeverity severity;
    private List<MsdrgHac> hacs = new ArrayList<MsdrgHac>();
    private List<MsdrgHac> hacsFlags = new ArrayList<MsdrgHac>();
    private Integer mdc;
    private boolean limitedSeverityTrauma;
    private boolean limitedSeverityHiv;
    private boolean sexConflict;
    private boolean downgradeSeverityDueToSuppression;
    private MsdrgGroupingImpact drgImpact = MsdrgGroupingImpact.NONE;
    private MsdrgCodeSeverityFlag initialSeverityFlag = MsdrgCodeSeverityFlag.NEITHER;
    private MsdrgCodeSeverityFlag finalSeverityFlag = MsdrgCodeSeverityFlag.NEITHER;
    private boolean isInitialMarked = false;
    private boolean isFinalMarked = false;
    private Integer clinicalSignificanceRank;
    private boolean isSigTrauma = false;
    private MsdrgPoaErrorCode poaErrorCodeFlag = MsdrgPoaErrorCode.POA_NOT_CHECKED;
    private boolean isOnShowList = false;
    private boolean isDeathExclusion = false;
    private Attribute attributeMarkedFor;

    public MsdrgDiagnosisCode(MsdrgInputDxCode inputDxCode) {
        Objects.requireNonNull(inputDxCode, "Input dx code cannot be null");
        this.inputDxCode = inputDxCode;
    }

    public MsdrgInputDxCode getInputDxCode() {
        return this.inputDxCode;
    }

    public Attribute getAttributeMarkedFor() {
        return this.attributeMarkedFor;
    }

    public void setAttributeMarkedFor(Attribute attributeMarkedFor) {
        this.attributeMarkedFor = attributeMarkedFor;
    }

    public boolean isDowngradeSeverityDueToSuppression() {
        return this.downgradeSeverityDueToSuppression;
    }

    public void setDowngradeSeverityDueToSuppression(boolean downgradeSeverityDueToSuppression) {
        this.downgradeSeverityDueToSuppression = downgradeSeverityDueToSuppression;
    }

    public List<MsdrgHac> getHacsFlags() {
        return this.hacsFlags;
    }

    public void setHacsFlags(List<MsdrgHac> hacsFlags) {
        this.hacsFlags = hacsFlags;
    }

    public boolean isValidCode() {
        return this.isValidCode;
    }

    public void setValidCode(boolean isValidCode) {
        this.isValidCode = isValidCode;
    }

    public boolean isDeathExclusion() {
        return this.isDeathExclusion;
    }

    public void setDeathExclusion(boolean deathExclusion) {
        this.isDeathExclusion = deathExclusion;
    }

    public boolean isExcluded() {
        return this.isExcluded;
    }

    public void setExcluded(boolean isExcluded) {
        this.isExcluded = isExcluded;
    }

    public int getMdc() {
        return this.mdc;
    }

    public void setMdc(Integer mdc) {
        this.mdc = mdc;
    }

    public List<MsdrgHac> getHacs() {
        return this.hacs;
    }

    public void setHacs(List<MsdrgHac> hacs) {
        this.hacs = hacs;
    }

    public boolean isAffectDrg() {
        return this.affectDrg;
    }

    public void setAffectDrg(boolean affectDrg) {
        this.affectDrg = affectDrg;
    }

    public MsdrgSeverity getSeverity() {
        return this.severity;
    }

    public void setSeverity(MsdrgSeverity severity) {
        this.severity = severity;
    }

    public boolean isSigTrauma() {
        return this.isSigTrauma;
    }

    public void setSigTrauma(boolean sigTrauma) {
        this.isSigTrauma = sigTrauma;
    }

    public GfcPoa getPoa() {
        return this.inputDxCode.getPoa();
    }

    public boolean hasHacs() {
        for (MsdrgHac hac : this.getHacsFlags()) {
            if (hac.getHacStatus() != MsdrgHacUsage.HAC_CRITERIA_MET) continue;
            return true;
        }
        return false;
    }

    public boolean isLimitedSeverityHiv() {
        return this.limitedSeverityHiv;
    }

    public void setLimitedSeverityHiv(boolean limitedSeverityHiv) {
        this.limitedSeverityHiv = limitedSeverityHiv;
    }

    public boolean isLimitedSeverityTrauma() {
        return this.limitedSeverityTrauma;
    }

    public void setLimitedSeverityTrauma(boolean limitedSeverityTrauma) {
        this.limitedSeverityTrauma = limitedSeverityTrauma;
    }

    public boolean isSexConflict() {
        return this.sexConflict;
    }

    public void setSexConflict(boolean sexConflict) {
        this.sexConflict = sexConflict;
    }

    @Override
    public MsdrgGroupingImpact getDrgImpact() {
        return this.drgImpact;
    }

    @Override
    public void setDrgImpact(MsdrgGroupingImpact drgImpact) {
        this.drgImpact = drgImpact;
    }

    public MsdrgCodeSeverityFlag getInitialSeverityFlag() {
        return this.initialSeverityFlag;
    }

    public void markSeverityFlag(MsdrgMaskBuildingConditions conditions) {
        if (conditions != MsdrgMaskBuildingConditions.INITIAL && conditions != MsdrgMaskBuildingConditions.FINAL) {
            return;
        }
        Consumer<MsdrgCodeSeverityFlag> setMethod = conditions == MsdrgMaskBuildingConditions.INITIAL ? this::setInitialSeverityFlag : this::setFinalSeverityFlag;
        if (this.isDeathExclusion() && !this.isExcluded()) {
            setMethod.accept(MsdrgCodeSeverityFlag.NEITHER);
        } else if (this.isDeathExclusion() && this.isExcluded() && this.getSeverity() == MsdrgSeverity.MCC) {
            setMethod.accept(MsdrgCodeSeverityFlag.MCC_EXCLUDED);
        } else if (this.isDeathExclusion() && this.isExcluded() && this.getSeverity() == MsdrgSeverity.CC) {
            setMethod.accept(MsdrgCodeSeverityFlag.CC_EXCLUDED);
        } else if (this.isExcluded() && this.getSeverity() == MsdrgSeverity.MCC) {
            setMethod.accept(MsdrgCodeSeverityFlag.MCC_EXCLUDED);
        } else if (this.isExcluded() && this.getSeverity() == MsdrgSeverity.CC) {
            setMethod.accept(MsdrgCodeSeverityFlag.CC_EXCLUDED);
        } else if (!this.isExcluded() && this.getSeverity() == MsdrgSeverity.MCC) {
            setMethod.accept(MsdrgCodeSeverityFlag.MCC);
        } else if (!this.isExcluded() && this.getSeverity() == MsdrgSeverity.CC) {
            setMethod.accept(MsdrgCodeSeverityFlag.CC);
        } else {
            setMethod.accept(MsdrgCodeSeverityFlag.NEITHER);
        }
        if (conditions == MsdrgMaskBuildingConditions.FINAL && this.hasHacs()) {
            this.setFinalSeverityFlag(MsdrgCodeSeverityFlag.NEITHER);
        }
    }

    public void processSeverityFlag(MsdrgDischargeStatus dischargeStatus) {
        if (this.isExcluded()) {
            if (this.getSeverity() == MsdrgSeverity.MCC) {
                this.setFinalSeverityFlag(MsdrgCodeSeverityFlag.MCC_EXCLUDED);
            } else if (this.getSeverity() == MsdrgSeverity.CC) {
                this.setFinalSeverityFlag(MsdrgCodeSeverityFlag.CC_EXCLUDED);
            }
        } else if (this.hasHacs()) {
            this.setFinalSeverityFlag(MsdrgCodeSeverityFlag.NEITHER);
        } else if (this.hasAttribute("mccalive") && dischargeStatus == MsdrgDischargeStatus.DIED) {
            this.setFinalSeverityFlag(MsdrgCodeSeverityFlag.NEITHER);
        } else if (this.getSeverity() == MsdrgSeverity.MCC) {
            this.setFinalSeverityFlag(MsdrgCodeSeverityFlag.MCC);
        } else if (this.getSeverity() == MsdrgSeverity.CC) {
            this.setFinalSeverityFlag(MsdrgCodeSeverityFlag.CC);
        }
    }

    public void setSeverityFlag(MsdrgMaskBuildingConditions condition) {
        if (condition == MsdrgMaskBuildingConditions.INITIAL) {
            this.setInitialSeverityFlag(MsdrgCodeSeverityFlag.NEITHER);
        } else {
            this.setFinalSeverityFlag(MsdrgCodeSeverityFlag.NEITHER);
        }
    }

    public void setInitialSeverityFlag(MsdrgCodeSeverityFlag initialSeverityFlag) {
        this.initialSeverityFlag = initialSeverityFlag;
    }

    public MsdrgCodeSeverityFlag getFinalSeverityFlag() {
        return this.finalSeverityFlag;
    }

    public void setFinalSeverityFlag(MsdrgCodeSeverityFlag finalSeverityFlag) {
        this.finalSeverityFlag = finalSeverityFlag;
    }

    public boolean isInitialMarked() {
        return this.isInitialMarked;
    }

    @Override
    public void setInitialMarked(boolean initialMarked) {
        this.isInitialMarked = initialMarked;
    }

    public boolean isFinalMarked() {
        return this.isFinalMarked;
    }

    @Override
    public void setFinalMarked(boolean finalMarked) {
        this.isFinalMarked = finalMarked;
    }

    public Integer getClinicalSignificanceRank() {
        return this.clinicalSignificanceRank;
    }

    public void setClinicalSignificanceRank(Integer clinicalSignificanceRank) {
        this.clinicalSignificanceRank = clinicalSignificanceRank;
    }

    public Set<Attribute> getDxCatAttributes() {
        return this.dxCatAttributes;
    }

    public void setDxCatAttributes(Set<Attribute> dxCatAttributes) {
        this.dxCatAttributes = dxCatAttributes;
    }

    public Set<Attribute> getHacAttributes() {
        return this.hacAttributes;
    }

    public void setHacAttributes(Set<Attribute> hacAttributes) {
        this.hacAttributes = hacAttributes;
    }

    public boolean hasAttribute(String attributeName) {
        block3: {
            block2: {
                if (this.attributes == null) break block2;
                for (Attribute attribute : this.attributes) {
                    if (!attribute.getListName().equalsIgnoreCase(attributeName)) continue;
                    return true;
                }
                break block3;
            }
            if (this.dxCatAttributes == null) break block3;
            for (Attribute attribute : this.dxCatAttributes) {
                if (!attribute.getListName().equalsIgnoreCase(attributeName)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isOnShowList() {
        return this.isOnShowList;
    }

    public void setOnShowList(boolean onShowList) {
        this.isOnShowList = onShowList;
    }

    public MsdrgPoaErrorCode getPoaErrorCodeFlag() {
        return this.poaErrorCodeFlag;
    }

    public void setPoaErrorCodeFlag(MsdrgPoaErrorCode poaErrorCodeFlag) {
        this.poaErrorCodeFlag = poaErrorCodeFlag;
    }

    @Override
    public Set<Attribute> getAttributes() {
        return this.attributes;
    }

    @Override
    public void setAttributes(Set<Attribute> attributes) {
        this.attributes = attributes;
    }

    @Override
    public String getValue() {
        return this.inputDxCode.getValue();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.affectDrg, this.isExcluded, this.isValidCode, this.attributes, this.severity, this.hacs, this.mdc, this.limitedSeverityTrauma, this.limitedSeverityHiv, this.sexConflict, this.drgImpact, this.initialSeverityFlag, this.finalSeverityFlag, this.isInitialMarked, this.isFinalMarked, this.clinicalSignificanceRank, this.isSigTrauma, this.hacAttributes, this.dxCatAttributes, this.poaErrorCodeFlag, this.isOnShowList});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MsdrgDiagnosisCode)) {
            return false;
        }
        MsdrgDiagnosisCode that = (MsdrgDiagnosisCode)obj;
        return this.affectDrg == that.affectDrg && this.isExcluded == that.isExcluded && this.isValidCode == that.isValidCode && this.limitedSeverityTrauma == that.limitedSeverityTrauma && this.limitedSeverityHiv == that.limitedSeverityHiv && this.sexConflict == that.sexConflict && this.downgradeSeverityDueToSuppression == that.downgradeSeverityDueToSuppression && this.isInitialMarked == that.isInitialMarked && this.isFinalMarked == that.isFinalMarked && this.isSigTrauma == that.isSigTrauma && this.isOnShowList == that.isOnShowList && this.isDeathExclusion == that.isDeathExclusion && Objects.equals(this.attributes, that.attributes) && Objects.equals(this.dxCatAttributes, that.dxCatAttributes) && Objects.equals(this.hacAttributes, that.hacAttributes) && this.severity == that.severity && Objects.equals(this.hacs, that.hacs) && Objects.equals(this.hacsFlags, that.hacsFlags) && Objects.equals(this.mdc, that.mdc) && this.drgImpact == that.drgImpact && this.initialSeverityFlag == that.initialSeverityFlag && this.finalSeverityFlag == that.finalSeverityFlag && Objects.equals(this.clinicalSignificanceRank, that.clinicalSignificanceRank) && this.poaErrorCodeFlag == that.poaErrorCodeFlag && Objects.equals(this.attributeMarkedFor, that.attributeMarkedFor);
    }
}

