/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.msdrg.model.enumeration;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum MsdrgDischargeStatus {
    NONE(-1, "invalid_dstat"),
    HOME_SELFCARE_ROUTINE(1),
    SHORT_TERM_HOSPITAL(2),
    SNF(3),
    CUST_SUPP_CARE(4),
    CANC_CHILD_HOSP(5),
    HOME_HEALTH_SERVICE(6),
    LEFT_AGAINST_MEDICAL_ADVICE(7, "AMA"),
    DIED(20, "DIED"),
    COURT_LAW_ENFRC(21),
    STILL_A_PATIENT(30),
    FEDERAL_HOSPITAL(43),
    HOSPICE_HOME(50),
    HOSPICE_MEDICAL_FACILITY(51),
    SWING_BED(61),
    REHAB_FACILITY_REHAB_UNIT(62),
    LONG_TERM_CARE_HOSPITAL(63),
    NURSING_FACILITY_MEDICAID_CERTIFIED(64),
    PSYCH_HOSP_UNIT(65),
    CRIT_ACC_HOSP(66),
    DESIGNATED_DISASTER_ALTERNATIVE_CARE_SITE(69),
    OTH_INSTITUTION(70),
    HOME_SELF_CARE_W_PLANNED_READMISSION(81),
    SHORT_TERM_HOSPITAL_W_PLANNED_READMISSION(82),
    SNF_W_PLANNED_READMISSION(83),
    CUST_SUPP_CARE_W_PLANNED_READMISSION(84),
    CANC_CHILD_HOSP_W_PLANNED_READMISSION(85),
    HOME_HEALTH_SERVICE_W_PLANNED_READMISSION(86),
    COURT_LAW_ENFRC_W_PLANNED_READMISSION(87),
    FEDERAL_HOSPITAL_W_PLANNED_READMISSION(88),
    SWING_BED_W_PLANNED_READMISSION(89),
    REHAB_FACILITY_UNIT_W_PLANNED_READMISSION(90),
    LTCH_W_PLANNED_READMISSION(91),
    NURSG_FAC_MEDICAID_CERT_W_PLANNED_READMISSION(92),
    PSYCH_HOSP_UNIT_W_PLANNED_READMISSION(93),
    CRIT_ACC_HOSP_W_PLANNED_READMISSION(94),
    OTH_INSTITUTION_W_PLANNED_READMISSION(95);

    public static final String ALIVE_STRING = "ALIVE";
    private final int dischargeStatus;
    private final String formulaString;
    private static final Map<Integer, MsdrgDischargeStatus> map;

    private MsdrgDischargeStatus(int dischargeStatus) {
        this.dischargeStatus = dischargeStatus;
        this.formulaString = "";
    }

    private MsdrgDischargeStatus(int dischargeStatus, String formulaString) {
        this.dischargeStatus = dischargeStatus;
        this.formulaString = formulaString;
    }

    public int intValue() {
        return this.dischargeStatus;
    }

    public int getDischargeStatus() {
        return this.dischargeStatus;
    }

    public String getFormulaString() {
        return this.formulaString;
    }

    public boolean hasFormulaString() {
        return !this.formulaString.isEmpty();
    }

    public static MsdrgDischargeStatus getEnumFromInt(int dischargeStatusInt) {
        return map.get(dischargeStatusInt);
    }

    static {
        map = Arrays.stream(MsdrgDischargeStatus.values()).collect(Collectors.toMap(dischargeStatus -> dischargeStatus.dischargeStatus, dischargeStatus -> dischargeStatus));
    }
}

