/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.msdrg.model.transfer;

import gov.agency.msdrg.model.enumeration.MsdrgGrouperReturnCode;
import gov.agency.msdrg.model.enumeration.MsdrgMedSurgType;
import gov.agency.msdrg.model.enumeration.MsdrgSeverity;
import java.util.Objects;

public class MsdrgGrouperResult {
    private final MsdrgGrouperReturnCode returnCode;
    private final int mdc;
    private final String mdcDescription;
    private final int drg;
    private final String drgDescription;
    private final MsdrgMedSurgType medicalOrSurgical;
    private final int baseDrg;
    private final String baseDrgDescription;
    private final MsdrgSeverity severity;

    private MsdrgGrouperResult(MsdrgGrouperReturnCode returnCode, Integer mdc, String mdcDescription, Integer drg, String drgDescription, MsdrgMedSurgType medicalOrSurgical, Integer baseDrg, String baseDrgDescription, MsdrgSeverity severity) {
        this.returnCode = Objects.requireNonNull(returnCode, "Grouper return code is required.");
        this.mdc = Objects.requireNonNull(mdc, "MDC is required.");
        this.mdcDescription = Objects.requireNonNull(mdcDescription, "MDC description is required.");
        this.drg = Objects.requireNonNull(drg, "DRG is required.");
        this.drgDescription = Objects.requireNonNull(drgDescription, "DRG description is required.");
        this.medicalOrSurgical = Objects.requireNonNull(medicalOrSurgical, "MedSurg type is required.");
        this.baseDrg = Objects.requireNonNull(baseDrg, "Base DRG is required.");
        this.baseDrgDescription = Objects.requireNonNull(baseDrgDescription, "Base DRG description is required.");
        this.severity = Objects.requireNonNull(severity, "Severity is required.");
    }

    public MsdrgGrouperReturnCode getReturnCode() {
        return this.returnCode;
    }

    public int getMdc() {
        return this.mdc;
    }

    public String getMdcDescription() {
        return this.mdcDescription;
    }

    public int getDrg() {
        return this.drg;
    }

    public String getDrgDescription() {
        return this.drgDescription;
    }

    public MsdrgMedSurgType getMedicalOrSurgical() {
        return this.medicalOrSurgical;
    }

    public int getBaseDrg() {
        return this.baseDrg;
    }

    public String getBaseDrgDescription() {
        return this.baseDrgDescription;
    }

    public MsdrgSeverity getSeverity() {
        return this.severity;
    }

    public static MsdrgGrouperResultBuilder builder() {
        return new MsdrgGrouperResultBuilder();
    }

    public MsdrgGrouperResultBuilder toBuilder() {
        return new MsdrgGrouperResultBuilder(this);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.returnCode, this.mdc, this.drg, this.medicalOrSurgical, this.baseDrg, this.severity});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MsdrgGrouperResult)) {
            return false;
        }
        MsdrgGrouperResult that = (MsdrgGrouperResult)obj;
        return this.mdc == that.mdc && this.drg == that.drg && this.baseDrg == that.baseDrg && this.returnCode == that.returnCode && Objects.equals(this.mdcDescription, that.mdcDescription) && Objects.equals(this.drgDescription, that.drgDescription) && this.medicalOrSurgical == that.medicalOrSurgical && Objects.equals(this.baseDrgDescription, that.baseDrgDescription) && this.severity == that.severity;
    }

    public static final class MsdrgGrouperResultBuilder {
        private MsdrgGrouperReturnCode returnCode;
        private int mdc;
        private String mdcDescription;
        private int drg;
        private String drgDescription;
        private MsdrgMedSurgType medicalOrSurgical;
        private int baseDrg;
        private String baseDrgDescription;
        private MsdrgSeverity severity;

        private MsdrgGrouperResultBuilder() {
        }

        private MsdrgGrouperResultBuilder(MsdrgGrouperResult other) {
            this.returnCode = other.returnCode;
            this.mdc = other.mdc;
            this.mdcDescription = other.mdcDescription;
            this.drg = other.drg;
            this.drgDescription = other.drgDescription;
            this.medicalOrSurgical = other.medicalOrSurgical;
            this.baseDrg = other.baseDrg;
            this.baseDrgDescription = other.baseDrgDescription;
            this.severity = other.severity;
        }

        public MsdrgGrouperResultBuilder withReturnCode(MsdrgGrouperReturnCode returnCode) {
            this.returnCode = returnCode;
            return this;
        }

        public MsdrgGrouperResultBuilder withMdc(int mdc) {
            this.mdc = mdc;
            return this;
        }

        public MsdrgGrouperResultBuilder withMdcDescription(String mdcDescription) {
            this.mdcDescription = mdcDescription;
            return this;
        }

        public MsdrgGrouperResultBuilder withDrg(int drg) {
            this.drg = drg;
            return this;
        }

        public MsdrgGrouperResultBuilder withDrgDescription(String drgDescription) {
            this.drgDescription = drgDescription;
            return this;
        }

        public MsdrgGrouperResultBuilder withMedicalOrSurgical(MsdrgMedSurgType medicalOrSurgical) {
            this.medicalOrSurgical = medicalOrSurgical;
            return this;
        }

        public MsdrgGrouperResultBuilder withBaseDrg(int baseDrg) {
            this.baseDrg = baseDrg;
            return this;
        }

        public MsdrgGrouperResultBuilder withBaseDrgDescription(String baseDrgDescription) {
            this.baseDrgDescription = baseDrgDescription;
            return this;
        }

        public MsdrgGrouperResultBuilder withSeverity(MsdrgSeverity severity) {
            this.severity = severity;
            return this;
        }

        public MsdrgGrouperResult build() {
            return new MsdrgGrouperResult(this.returnCode, this.mdc, this.mdcDescription, this.drg, this.drgDescription, this.medicalOrSurgical, this.baseDrg, this.baseDrgDescription, this.severity);
        }
    }
}

