/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.msdrg.model.transfer;

import gov.agency.msdrg.model.MsdrgDiagnosisFlag;
import gov.agency.msdrg.model.MsdrgHac;
import gov.agency.msdrg.model.enumeration.MsdrgCodeSeverityFlag;
import gov.agency.msdrg.model.enumeration.MsdrgGroupingImpact;
import gov.agency.msdrg.model.enumeration.MsdrgPoaErrorCode;
import gov.agency.msdrg.model.transfer.MsdrgInputDxCode;
import java.util.List;
import java.util.Objects;

public class MsdrgOutputDxCode {
    private final MsdrgInputDxCode inputDxCode;
    private final MsdrgDiagnosisFlag flags;

    public MsdrgOutputDxCode(MsdrgInputDxCode inputDxCode, MsdrgDiagnosisFlag flags) {
        this.inputDxCode = inputDxCode;
        this.flags = flags;
    }

    public MsdrgInputDxCode getInputDxCode() {
        return this.inputDxCode;
    }

    public boolean isDiagnosisRecognizedByGrouper() {
        return this.flags.isDiagnosisRecognizedByGrouper();
    }

    public MsdrgGroupingImpact getDiagnosisAffectsDrg() {
        return this.flags.getDiagnosisAffectsDrg();
    }

    public MsdrgCodeSeverityFlag getFinalSeverityUsage() {
        return this.flags.getFinalSeverityUsage();
    }

    public MsdrgCodeSeverityFlag getInitialSeverityUsage() {
        return this.flags.getInitialSeverityUsage();
    }

    public MsdrgPoaErrorCode getPoaErrorCode() {
        return this.flags.getPoaErrorCode();
    }

    public List<MsdrgHac> getHacs() {
        return this.flags.getHacs();
    }

    public String getLegacyFlagString() {
        return this.flags.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MsdrgOutputDxCode)) {
            return false;
        }
        MsdrgOutputDxCode that = (MsdrgOutputDxCode)obj;
        return Objects.equals(this.inputDxCode, that.inputDxCode) && Objects.equals(this.flags, that.flags);
    }

    public int hashCode() {
        return Objects.hash(this.inputDxCode, this.flags);
    }
}

