/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.msdrg.model.v2;

import gov.agency.msdrg.model.v2.enumeration.MsdrgGroupingImpact;
import gov.agency.msdrg.model.v2.enumeration.MsdrgProcedureHacUsage;
import java.util.Collections;
import java.util.Set;

public class MsdrgProcedureFlag {
    private final boolean procedureRecognizedByGrouper;
    private final MsdrgGroupingImpact procedureAffectsDrg;
    private final boolean procedureIsOperatingRoomProcedure;
    private final Set<MsdrgProcedureHacUsage> hacUsage;

    public MsdrgProcedureFlag() {
        this.procedureRecognizedByGrouper = false;
        this.procedureAffectsDrg = MsdrgGroupingImpact.NONE;
        this.procedureIsOperatingRoomProcedure = false;
        this.hacUsage = Collections.emptySet();
    }

    public MsdrgProcedureFlag(boolean procedureRecognizedByGrouper, MsdrgGroupingImpact procedureAffectsDrg, boolean procedureIsOperatingRoomProcedure, Set<MsdrgProcedureHacUsage> hacUsage) {
        this.procedureRecognizedByGrouper = procedureRecognizedByGrouper;
        this.procedureAffectsDrg = procedureAffectsDrg;
        this.procedureIsOperatingRoomProcedure = procedureIsOperatingRoomProcedure;
        this.hacUsage = hacUsage;
    }

    public boolean isProcedureRecognizedByGrouper() {
        return this.procedureRecognizedByGrouper;
    }

    public MsdrgGroupingImpact getProcedureAffectsDrg() {
        return this.procedureAffectsDrg;
    }

    public boolean isProcedureIsOperatingRoomProcedure() {
        return this.procedureIsOperatingRoomProcedure;
    }

    public Set<MsdrgProcedureHacUsage> getHacUsage() {
        return this.hacUsage;
    }

    public String toString() {
        int[] procFlags = new int[20];
        if (!this.procedureRecognizedByGrouper) {
            return "0                   ";
        }
        procFlags[0] = 1;
        procFlags[1] = this.getProcedureAffectsDrg().intValue();
        procFlags[2] = this.procedureIsOperatingRoomProcedure ? 1 : 0;
        procFlags[3] = 0;
        procFlags[4] = 0;
        procFlags[5] = 0;
        int index = 6;
        if (!this.hacUsage.isEmpty()) {
            for (MsdrgProcedureHacUsage hacUsage : this.hacUsage) {
                procFlags[index] = hacUsage.getIntValue();
                ++index;
            }
        } else {
            for (int j = index; j < 11; ++j) {
                procFlags[j] = 0;
            }
        }
        for (int i = 11; i <= 19; ++i) {
            procFlags[i] = 0;
        }
        StringBuilder str = new StringBuilder();
        for (int procFlag : procFlags) {
            str.append(procFlag);
        }
        return str.toString();
    }
}

