/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.msdrg.model.v2.transfer.input;

import gov.agency.msdrg.model.v2.enumeration.MsdrgDischargeStatus;
import gov.agency.msdrg.model.v2.enumeration.MsdrgSex;
import gov.agency.msdrg.model.v2.transfer.DataBuilder;
import gov.agency.msdrg.model.v2.transfer.input.MsdrgInputData;
import gov.agency.msdrg.model.v2.transfer.input.MsdrgInputDxCode;
import gov.agency.msdrg.model.v2.transfer.input.MsdrgInputPrCode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class MsdrgInput
implements MsdrgInputData,
DataBuilder<MsdrgInputBuilder> {
    private final MsdrgInputDxCode admissionDiagnosisCode;
    private final MsdrgInputDxCode principalDiagnosisCode;
    private final int ageInYears;
    private final MsdrgDischargeStatus dischargeStatus;
    private final int ageDaysAdmit;
    private final int ageDaysDischarge;
    private final MsdrgSex sex;
    private final List<MsdrgInputDxCode> secondaryDiagnosisCodes;
    private final List<MsdrgInputPrCode> procedureCodes;

    private MsdrgInput(MsdrgInputDxCode admissionDiagnosisCode, MsdrgInputDxCode principalDiagnosisCode, int ageInYears, MsdrgDischargeStatus dischargeStatus, int ageDaysAdmit, int ageDaysDischarge, MsdrgSex sex, List<MsdrgInputDxCode> secondaryDiagnosisCodes, List<MsdrgInputPrCode> procedureCodes) {
        this.admissionDiagnosisCode = admissionDiagnosisCode;
        this.principalDiagnosisCode = principalDiagnosisCode;
        this.ageInYears = ageInYears;
        this.dischargeStatus = dischargeStatus;
        this.ageDaysAdmit = ageDaysAdmit;
        this.ageDaysDischarge = ageDaysDischarge;
        this.sex = sex;
        this.secondaryDiagnosisCodes = secondaryDiagnosisCodes == null ? new ArrayList<MsdrgInputDxCode>() : new ArrayList<MsdrgInputDxCode>(secondaryDiagnosisCodes);
        this.procedureCodes = procedureCodes == null ? new ArrayList<MsdrgInputPrCode>() : new ArrayList<MsdrgInputPrCode>(procedureCodes);
    }

    @Override
    public Optional<MsdrgInputDxCode> getAdmissionDiagnosisCode() {
        return Optional.ofNullable(this.admissionDiagnosisCode);
    }

    @Override
    public Optional<MsdrgInputDxCode> getPrincipalDiagnosisCode() {
        return Optional.ofNullable(this.principalDiagnosisCode);
    }

    @Override
    public int getAgeInYears() {
        return this.ageInYears;
    }

    @Override
    public Optional<MsdrgDischargeStatus> getDischargeStatus() {
        return Optional.ofNullable(this.dischargeStatus);
    }

    @Override
    public int getAgeDaysAdmit() {
        return this.ageDaysAdmit;
    }

    @Override
    public int getAgeDaysDischarge() {
        return this.ageDaysDischarge;
    }

    @Override
    public Optional<MsdrgSex> getSex() {
        return Optional.ofNullable(this.sex);
    }

    @Override
    public List<MsdrgInputDxCode> getSecondaryDiagnosisCodes() {
        return Collections.unmodifiableList(this.secondaryDiagnosisCodes);
    }

    @Override
    public List<MsdrgInputPrCode> getProcedureCodes() {
        return Collections.unmodifiableList(this.procedureCodes);
    }

    public static MsdrgInputBuilder builder() {
        return new MsdrgInputBuilder();
    }

    @Override
    public MsdrgInputBuilder toBuilder() {
        return new MsdrgInputBuilder(this);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.principalDiagnosisCode, this.ageInYears, this.dischargeStatus, this.ageDaysAdmit, this.ageDaysDischarge, this.sex, this.secondaryDiagnosisCodes, this.procedureCodes});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MsdrgInput that = (MsdrgInput)obj;
        return this.ageInYears == that.ageInYears && this.ageDaysAdmit == that.ageDaysAdmit && this.ageDaysDischarge == that.ageDaysDischarge && Objects.equals(this.principalDiagnosisCode, that.principalDiagnosisCode) && this.dischargeStatus == that.dischargeStatus && this.sex == that.sex && Objects.equals(this.secondaryDiagnosisCodes, that.secondaryDiagnosisCodes) && Objects.equals(this.procedureCodes, that.procedureCodes);
    }

    public static final class MsdrgInputBuilder {
        private MsdrgInputDxCode admissionDiagnosisCode;
        private MsdrgInputDxCode principalDiagnosisCode;
        private int ageInYears;
        private MsdrgDischargeStatus dischargeStatus;
        private int ageDaysAdmit;
        private int ageDaysDischarge;
        private MsdrgSex sex;
        private List<MsdrgInputDxCode> secondaryDiagnosisCodes;
        private List<MsdrgInputPrCode> procedureCodes;

        private MsdrgInputBuilder() {
        }

        private MsdrgInputBuilder(MsdrgInput other) {
            this.admissionDiagnosisCode = other.admissionDiagnosisCode;
            this.principalDiagnosisCode = other.principalDiagnosisCode;
            this.ageInYears = other.ageInYears;
            this.dischargeStatus = other.dischargeStatus;
            this.ageDaysAdmit = other.ageDaysAdmit;
            this.ageDaysDischarge = other.ageDaysDischarge;
            this.sex = other.sex;
            this.secondaryDiagnosisCodes = other.secondaryDiagnosisCodes;
            this.procedureCodes = other.procedureCodes;
        }

        public MsdrgInputBuilder withAdmissionDiagnosisCode(MsdrgInputDxCode admissionDiagnosisCode) {
            this.admissionDiagnosisCode = admissionDiagnosisCode;
            return this;
        }

        public MsdrgInputBuilder withPrincipalDiagnosisCode(MsdrgInputDxCode principalDiagnosisCode) {
            this.principalDiagnosisCode = principalDiagnosisCode;
            return this;
        }

        public MsdrgInputBuilder withAgeInYears(int ageInYears) {
            this.ageInYears = ageInYears;
            return this;
        }

        public MsdrgInputBuilder withDischargeStatus(MsdrgDischargeStatus dischargeStatus) {
            this.dischargeStatus = dischargeStatus;
            return this;
        }

        public MsdrgInputBuilder withAgeDaysAdmit(int ageDaysAdmit) {
            this.ageDaysAdmit = ageDaysAdmit;
            return this;
        }

        public MsdrgInputBuilder withAgeDaysDischarge(int ageDaysDischarge) {
            this.ageDaysDischarge = ageDaysDischarge;
            return this;
        }

        public MsdrgInputBuilder withSex(MsdrgSex sex) {
            this.sex = sex;
            return this;
        }

        public MsdrgInputBuilder withSecondaryDiagnosisCodes(List<MsdrgInputDxCode> secondaryDiagnosisCodes) {
            this.secondaryDiagnosisCodes = secondaryDiagnosisCodes;
            return this;
        }

        public MsdrgInputBuilder withProcedureCodes(List<MsdrgInputPrCode> procedureCodes) {
            this.procedureCodes = procedureCodes;
            return this;
        }

        public MsdrgInput build() {
            return new MsdrgInput(this.admissionDiagnosisCode, this.principalDiagnosisCode, this.ageInYears, this.dischargeStatus, this.ageDaysAdmit, this.ageDaysDischarge, this.sex, this.secondaryDiagnosisCodes, this.procedureCodes);
        }
    }
}

