/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.msdrg.model.v2.transfer.output;

import com.mmm.his.cer.foundation.exception.FoundationException;
import gov.agency.msdrg.model.v2.MsdrgGrouperFlags;
import gov.agency.msdrg.model.v2.MsdrgGrouperResult;
import gov.agency.msdrg.model.v2.MsdrgValue;
import gov.agency.msdrg.model.v2.enumeration.MsdrgGrouperReturnCode;
import gov.agency.msdrg.model.v2.enumeration.MsdrgHacStatus;
import gov.agency.msdrg.model.v2.enumeration.MsdrgMedSurgType;
import gov.agency.msdrg.model.v2.enumeration.MsdrgSeverity;
import gov.agency.msdrg.model.v2.transfer.output.MsdrgOutputData;
import gov.agency.msdrg.model.v2.transfer.output.MsdrgOutputDxCode;
import gov.agency.msdrg.model.v2.transfer.output.MsdrgOutputPrCode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class MsdrgOutput
implements MsdrgOutputData {
    private final MsdrgGrouperResult initialGrouperResult;
    private final MsdrgGrouperResult finalGrouperResult;
    private final MsdrgGrouperFlags grouperFlags;
    private final List<String> sdxCodesOnClaimThatAreExclusions;
    private final MsdrgOutputDxCode pdxOutput;
    private final List<MsdrgOutputDxCode> sdxOutput;
    private final List<MsdrgOutputPrCode> procOutput;
    private final MsdrgValue<Integer> initialBaseDrg;
    private final MsdrgValue<Integer> initialDrg;
    private final MsdrgValue<Integer> initialMdc;
    private final MsdrgValue<Integer> finalBaseDrg;
    private final MsdrgValue<Integer> finalDrg;
    private final MsdrgValue<Integer> finalMdc;

    private MsdrgOutput(MsdrgGrouperResult initialGrouperResult, MsdrgGrouperResult finalGrouperResult, MsdrgGrouperFlags grouperFlags, List<String> sdxCodesOnClaimThatAreExclusions, MsdrgOutputDxCode pdxOutput, List<MsdrgOutputDxCode> sdxOutput, List<MsdrgOutputPrCode> procOutput) {
        this.initialGrouperResult = Objects.requireNonNull(initialGrouperResult, "Initial grouping results is required.");
        this.finalGrouperResult = Objects.requireNonNull(finalGrouperResult, "Final grouping results is required.");
        this.grouperFlags = Objects.requireNonNull(grouperFlags, "Grouper flags are required.");
        this.pdxOutput = Objects.requireNonNull(pdxOutput, "PDX output is required.");
        this.sdxCodesOnClaimThatAreExclusions = sdxCodesOnClaimThatAreExclusions != null ? Collections.unmodifiableList(new ArrayList<String>(sdxCodesOnClaimThatAreExclusions)) : Collections.unmodifiableList(new ArrayList());
        this.sdxOutput = sdxOutput != null ? Collections.unmodifiableList(new ArrayList<MsdrgOutputDxCode>(sdxOutput)) : Collections.unmodifiableList(new ArrayList());
        this.procOutput = procOutput != null ? Collections.unmodifiableList(new ArrayList<MsdrgOutputPrCode>(procOutput)) : Collections.unmodifiableList(new ArrayList());
        this.initialBaseDrg = new MsdrgValue<Integer>(initialGrouperResult.getBaseDrg(), initialGrouperResult.getBaseDrgDescription());
        this.initialDrg = new MsdrgValue<Integer>(initialGrouperResult.getDrg(), initialGrouperResult.getDrgDescription());
        this.initialMdc = new MsdrgValue<Integer>(initialGrouperResult.getMdc(), initialGrouperResult.getMdcDescription());
        this.finalBaseDrg = new MsdrgValue<Integer>(finalGrouperResult.getBaseDrg(), finalGrouperResult.getBaseDrgDescription());
        this.finalDrg = new MsdrgValue<Integer>(finalGrouperResult.getDrg(), finalGrouperResult.getDrgDescription());
        this.finalMdc = new MsdrgValue<Integer>(finalGrouperResult.getMdc(), finalGrouperResult.getMdcDescription());
    }

    @Override
    public MsdrgGrouperFlags getGrouperFlags() {
        return this.grouperFlags;
    }

    @Override
    public MsdrgGrouperReturnCode getInitialGrc() {
        return this.initialGrouperResult.getReturnCode();
    }

    @Override
    public MsdrgValue<Integer> getInitialMdc() {
        return this.initialMdc;
    }

    @Override
    public MsdrgValue<Integer> getInitialDrg() {
        return this.initialDrg;
    }

    @Override
    public MsdrgMedSurgType getInitialMedSugType() {
        return this.initialGrouperResult.getMedicalOrSurgical();
    }

    @Override
    public MsdrgValue<Integer> getInitialBaseDrg() {
        return this.initialBaseDrg;
    }

    @Override
    public MsdrgGrouperReturnCode getFinalGrc() {
        return this.finalGrouperResult.getReturnCode();
    }

    @Override
    public MsdrgValue<Integer> getFinalMdc() {
        return this.finalMdc;
    }

    @Override
    public MsdrgValue<Integer> getFinalDrg() {
        return this.finalDrg;
    }

    @Override
    public MsdrgMedSurgType getFinalMedSugType() {
        return this.finalGrouperResult.getMedicalOrSurgical();
    }

    @Override
    public MsdrgOutputDxCode getPdxOutput() {
        return this.pdxOutput;
    }

    @Override
    public MsdrgValue<Integer> getFinalBaseDrg() {
        return this.finalBaseDrg;
    }

    @Override
    public MsdrgSeverity getFinalDrgSdxSeverity() {
        return this.grouperFlags.isFinalDrgSecondaryDxCcMcc();
    }

    @Override
    public MsdrgSeverity getInitialDrgSdxSeverity() {
        return this.grouperFlags.isInitialDrgSecondaryDxCcMcc();
    }

    @Override
    public int getNumHacCategoriesSatisfied() {
        return this.grouperFlags.getNumHacCategoriesSatisfied();
    }

    @Override
    public MsdrgHacStatus getHacStatus() {
        return this.grouperFlags.getHacStatusValue();
    }

    @Override
    public List<MsdrgOutputDxCode> getSdxOutput() {
        return this.sdxOutput;
    }

    @Override
    public MsdrgOutputDxCode getSdxOutput(int sdxCodeIndex) throws FoundationException {
        MsdrgOutputDxCode outputDxCode;
        try {
            outputDxCode = this.sdxOutput.get(sdxCodeIndex);
        }
        catch (IndexOutOfBoundsException exc) {
            throw new FoundationException("Index given did not correspond to sdx output.", exc);
        }
        return outputDxCode;
    }

    @Override
    public List<MsdrgOutputPrCode> getProcOutput() {
        return this.procOutput;
    }

    @Override
    public MsdrgOutputPrCode getProcOutput(int procCodeIndex) throws FoundationException {
        MsdrgOutputPrCode outputPrCode;
        try {
            outputPrCode = this.procOutput.get(procCodeIndex);
        }
        catch (IndexOutOfBoundsException exc) {
            throw new FoundationException("Index given did not correspond to proc output.", exc);
        }
        return outputPrCode;
    }

    @Override
    public MsdrgSeverity getFinalSeverity() {
        return this.finalGrouperResult.getSeverity();
    }

    @Override
    public MsdrgSeverity getInitialSeverity() {
        return this.initialGrouperResult.getSeverity();
    }

    public static MsdrgOutputBuilder builder() {
        return MsdrgOutputBuilder.builder();
    }

    public MsdrgOutputBuilder toBuilder() {
        return MsdrgOutputBuilder.builder(this);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MsdrgOutput)) {
            return false;
        }
        MsdrgOutput output = (MsdrgOutput)obj;
        return Objects.equals(this.initialGrouperResult, output.initialGrouperResult) && Objects.equals(this.finalGrouperResult, output.finalGrouperResult) && Objects.equals(this.grouperFlags, output.grouperFlags) && Objects.equals(this.sdxCodesOnClaimThatAreExclusions, output.sdxCodesOnClaimThatAreExclusions) && Objects.equals(this.pdxOutput, output.pdxOutput) && Objects.equals(this.sdxOutput, output.sdxOutput) && Objects.equals(this.procOutput, output.procOutput) && Objects.equals(this.initialBaseDrg, output.initialBaseDrg) && Objects.equals(this.initialDrg, output.initialDrg) && Objects.equals(this.initialMdc, output.initialMdc) && Objects.equals(this.finalBaseDrg, output.finalBaseDrg) && Objects.equals(this.finalDrg, output.finalDrg) && Objects.equals(this.finalMdc, output.finalMdc);
    }

    public int hashCode() {
        return Objects.hash(this.initialGrouperResult, this.finalGrouperResult, this.grouperFlags, this.sdxCodesOnClaimThatAreExclusions, this.pdxOutput, this.sdxOutput, this.procOutput, this.initialBaseDrg, this.initialDrg, this.initialMdc, this.finalBaseDrg, this.finalDrg, this.finalMdc);
    }

    public static class MsdrgOutputBuilder {
        private MsdrgGrouperResult initialGrouperResult;
        private MsdrgGrouperResult finalGrouperResult;
        private MsdrgGrouperFlags grouperFlags;
        private List<String> excludedSdxCodes;
        private MsdrgOutputDxCode pdxOutput;
        private List<MsdrgOutputDxCode> diagnosisFlags;
        private List<MsdrgOutputPrCode> procedureFlags;

        private static MsdrgOutputBuilder builder() {
            return new MsdrgOutputBuilder();
        }

        private static MsdrgOutputBuilder builder(MsdrgOutput objectToCopy) {
            MsdrgOutputBuilder newBuilder = new MsdrgOutputBuilder();
            newBuilder.initialGrouperResult = objectToCopy.initialGrouperResult;
            newBuilder.finalGrouperResult = objectToCopy.finalGrouperResult;
            newBuilder.grouperFlags = objectToCopy.grouperFlags;
            newBuilder.excludedSdxCodes = objectToCopy.sdxCodesOnClaimThatAreExclusions;
            newBuilder.pdxOutput = objectToCopy.pdxOutput;
            newBuilder.diagnosisFlags = objectToCopy.sdxOutput;
            newBuilder.procedureFlags = objectToCopy.procOutput;
            return newBuilder;
        }

        public MsdrgOutputBuilder withInitialGrouperResult(MsdrgGrouperResult initialGrouperResult) {
            this.initialGrouperResult = initialGrouperResult;
            return this;
        }

        public MsdrgOutputBuilder withFinalGrouperResult(MsdrgGrouperResult finalGrouperResult) {
            this.finalGrouperResult = finalGrouperResult;
            return this;
        }

        public MsdrgOutputBuilder withGrouperFlags(MsdrgGrouperFlags grouperFlags) {
            this.grouperFlags = grouperFlags;
            return this;
        }

        public MsdrgOutputBuilder withExcludedSdxCodes(List<String> excludedSdxCodes) {
            this.excludedSdxCodes = excludedSdxCodes;
            return this;
        }

        public MsdrgOutputBuilder withPdxOutput(MsdrgOutputDxCode principalDxFlag) {
            this.pdxOutput = principalDxFlag;
            return this;
        }

        public MsdrgOutputBuilder withSdxOutput(List<MsdrgOutputDxCode> diagnosisFlags) {
            this.diagnosisFlags = diagnosisFlags;
            return this;
        }

        public MsdrgOutputBuilder withProcOutput(List<MsdrgOutputPrCode> procedureFlags) {
            this.procedureFlags = procedureFlags;
            return this;
        }

        public MsdrgOutput build() {
            return new MsdrgOutput(this.initialGrouperResult, this.finalGrouperResult, this.grouperFlags, this.excludedSdxCodes, this.pdxOutput, this.diagnosisFlags, this.procedureFlags);
        }
    }
}

