/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.msdrg.v390.logic;

import com.mmm.his.cer.utility.farser.ast.node.type.NodeSupplier;
import com.mmm.his.cer.utility.farser.ast.parser.ExpressionResult;
import com.mmm.his.cer.utility.farser.lexer.drg.DrgLexerToken;
import gov.agency.msdrg.model.Attribute;
import gov.agency.msdrg.model.MsdrgDiagnosisCode;
import gov.agency.msdrg.model.MsdrgMaskAttributes;
import gov.agency.msdrg.model.MsdrgMatchedDrgFormula;
import gov.agency.msdrg.model.MsdrgSeverityResults;
import gov.agency.msdrg.model.enumeration.MsdrgAffectDrgOptionFlag;
import gov.agency.msdrg.model.enumeration.MsdrgHospitalStatusOptionFlag;
import gov.agency.msdrg.model.enumeration.MsdrgMaskBuildingConditions;
import gov.agency.msdrg.model.enumeration.MsdrgSeverity;
import gov.agency.msdrg.v390.access.MsdrgInteractionDao;
import gov.agency.msdrg.v390.access.pojo.MsdrgDrgFormulas;
import gov.agency.msdrg.v390.logic.FormulaEvaluator;
import gov.agency.msdrg.v390.logic.MsdrgSeverityProcessor;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MsdrgFormulaEvaluation
extends FormulaEvaluator {
    private static final Logger logger = LoggerFactory.getLogger(MsdrgFormulaEvaluation.class);
    private MsdrgInteractionDao dbAccess;

    public MsdrgFormulaEvaluation(MsdrgInteractionDao dbAccess) {
        this.dbAccess = dbAccess;
    }

    public EvalContainer evaluateFormulas(List<MsdrgDiagnosisCode> sdxCodes, MsdrgMaskBuildingConditions initialOrFinal, int mdc, MsdrgMaskAttributes mask, MsdrgAffectDrgOptionFlag computeAffectDrg, MsdrgHospitalStatusOptionFlag hospitalStatus) {
        logger.debug("Begin evaluating formulas for mdc: " + mdc);
        MsdrgMatchedDrgFormula matchedFormula = new MsdrgMatchedDrgFormula();
        List<MsdrgDrgFormulas> databaseRows = this.fetchFormulaRowsByMdc(mdc);
        long start = System.currentTimeMillis();
        boolean grouperReturnCode = false;
        MsdrgSeverity severity = MsdrgSeverity.NONE;
        for (MsdrgDrgFormulas drgFormula : databaseRows) {
            severity = this.calculateSeverity(sdxCodes, initialOrFinal, computeAffectDrg, drgFormula.getSeveritySuppressionOperand(), hospitalStatus);
            MsdrgMaskAttributes maskWithNewSeverity = new MsdrgMaskAttributes();
            maskWithNewSeverity.addAllToMask(mask.getMask());
            maskWithNewSeverity.addToMask(new Attribute(severity.toString()));
            ExpressionResult<Attribute> evaluation = this.evaluateFormula(maskWithNewSeverity, drgFormula.getFormula(), mdc);
            if (grouperReturnCode) {
                matchedFormula = new MsdrgMatchedDrgFormula(drgFormula.getBaseDrg(), drgFormula.getDrg(), drgFormula.getSurgical(), drgFormula.getReRouteMdcId(), drgFormula.getFormula(), evaluation.getMatches(), maskWithNewSeverity);
                return new EvalContainer(matchedFormula, severity);
            }
            if (!evaluation.isMatched()) continue;
            if (drgFormula.getDrg() == 0 && drgFormula.getReRouteMdcId() == 0) {
                grouperReturnCode = true;
                continue;
            }
            matchedFormula = new MsdrgMatchedDrgFormula(drgFormula.getBaseDrg(), drgFormula.getDrg(), drgFormula.getSurgical(), drgFormula.getReRouteMdcId(), drgFormula.getFormula(), evaluation.getMatches(), maskWithNewSeverity);
            break;
        }
        logger.debug("Formula eval took: {} ms", (Object)(System.currentTimeMillis() - start));
        return new EvalContainer(matchedFormula, severity);
    }

    public List<MsdrgDrgFormulas> fetchFormulaRowsByMdc(int mdc) {
        return this.dbAccess.getAllFormulaRowsByMdc(mdc);
    }

    public MsdrgSeverity calculateSeverity(List<MsdrgDiagnosisCode> sdxCodes, MsdrgMaskBuildingConditions initialOrFinal, MsdrgAffectDrgOptionFlag computeAffectDrg, Set<String> severityOperandSuppression, MsdrgHospitalStatusOptionFlag hospitalStatus) {
        MsdrgSeverityProcessor severityProcessor = new MsdrgSeverityProcessor();
        MsdrgSeverityResults severity = severityProcessor.processClaimSeverity(sdxCodes, initialOrFinal, severityOperandSuppression, computeAffectDrg, hospitalStatus);
        return severity.getSeverity();
    }

    @Override
    public void setSuppliers(Map<String, NodeSupplier<DrgLexerToken, Attribute>> suppliers) {
        super.setSuppliers(suppliers);
    }

    public static class EvalContainer {
        private final MsdrgMatchedDrgFormula matchedDrgFormula;
        private final MsdrgSeverity severity;

        public EvalContainer(MsdrgMatchedDrgFormula matchedDrgFormula, MsdrgSeverity severity) {
            Objects.requireNonNull(matchedDrgFormula, "Formula cannot be null");
            Objects.requireNonNull(severity, "Severity cannot be null");
            this.matchedDrgFormula = matchedDrgFormula;
            this.severity = severity;
        }

        public MsdrgMatchedDrgFormula getMatchedDrgFormula() {
            return this.matchedDrgFormula;
        }

        public MsdrgSeverity getSeverity() {
            return this.severity;
        }
    }
}

