/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.msdrg.v390.logic;

import gov.agency.msdrg.model.Attribute;
import gov.agency.msdrg.model.MsdrgDiagnosisCode;
import gov.agency.msdrg.model.MsdrgGrouperFlags;
import gov.agency.msdrg.model.MsdrgHac;
import gov.agency.msdrg.model.MsdrgMatchedDrgFormula;
import gov.agency.msdrg.model.enumeration.MsdrgAdmitDxGrouperFlag;
import gov.agency.msdrg.model.enumeration.MsdrgAffectDrgOptionFlag;
import gov.agency.msdrg.model.enumeration.MsdrgHacStatus;
import gov.agency.msdrg.model.enumeration.MsdrgHacUsage;
import gov.agency.msdrg.model.enumeration.MsdrgHospitalStatusOptionFlag;
import gov.agency.msdrg.model.enumeration.MsdrgSeverity;
import gov.agency.msdrg.v390.MsdrgComponent;
import gov.agency.msdrg.v390.ProcessingData;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class MsdrgGrouperFlagsResult {
    public static MsdrgGrouperFlags createGrouperFlags(ProcessingData processingData, MsdrgHospitalStatusOptionFlag hospitalStatusOptionFlag, MsdrgAffectDrgOptionFlag affectDrgOptionFlag, MsdrgMatchedDrgFormula initialMatchedFormula, MsdrgMatchedDrgFormula finalMatchedFormula) {
        MsdrgGrouperFlags grouperFlags = new MsdrgGrouperFlags();
        MsdrgDiagnosisCode admitDx = processingData.getAdmitDx();
        grouperFlags.setAdmitDxGrouperFlag(MsdrgGrouperFlagsResult.validateAdmitDx(admitDx));
        if (affectDrgOptionFlag == MsdrgAffectDrgOptionFlag.COMPUTE) {
            grouperFlags.setInitialDrgSecondaryDxCcMcc(MsdrgGrouperFlagsResult.getDrgSeverity(initialMatchedFormula));
            grouperFlags.setFinalDrgSecondaryDxCcMcc(MsdrgGrouperFlagsResult.getDrgSeverity(finalMatchedFormula));
        }
        int numHacCategoriesSatisfied = MsdrgGrouperFlagsResult.numHacCategoriesSatisfied(processingData.getSdxCodes());
        int initialDrg = processingData.getInitialResult().getDrg();
        int finalDrg = processingData.getFinalResult().getDrg();
        grouperFlags.setNumHacCategoriesSatisfied(numHacCategoriesSatisfied);
        grouperFlags.setHacStatusValue(MsdrgGrouperFlagsResult.hacStatusValue(initialDrg, finalDrg, hospitalStatusOptionFlag, numHacCategoriesSatisfied));
        return grouperFlags;
    }

    private static MsdrgAdmitDxGrouperFlag validateAdmitDx(MsdrgDiagnosisCode admitDx) {
        MsdrgAdmitDxGrouperFlag result = MsdrgAdmitDxGrouperFlag.DX_NOT_GIVEN;
        if (!MsdrgComponent.NULL_CODE_VALUE.equalsIgnoreCase(admitDx.getValue()) && !admitDx.getValue().isEmpty()) {
            if (admitDx.isValidCode()) {
                result = MsdrgAdmitDxGrouperFlag.DX_VALID;
            } else if (!admitDx.isValidCode()) {
                result = MsdrgAdmitDxGrouperFlag.DX_INVALID;
            }
        }
        return result;
    }

    private static MsdrgSeverity getDrgSeverity(MsdrgMatchedDrgFormula matchedDrgFormula) {
        if (matchedDrgFormula != null) {
            for (Attribute attr : matchedDrgFormula.getMatchedAttributes()) {
                if (attr.getListName().equals("MCC")) {
                    return MsdrgSeverity.MCC;
                }
                if (!attr.getListName().equals("CC")) continue;
                return MsdrgSeverity.CC;
            }
        }
        return MsdrgSeverity.NON_CC;
    }

    private static int numHacCategoriesSatisfied(List<MsdrgDiagnosisCode> sdxCodes) {
        Set hacsSatisfied = sdxCodes.stream().filter(code -> !code.getHacsFlags().isEmpty()).flatMap(code -> code.getHacsFlags().stream()).filter(hac -> hac.getHacStatus() == MsdrgHacUsage.HAC_CRITERIA_MET).map(MsdrgHac::getHacNumber).collect(Collectors.toSet());
        return hacsSatisfied.size();
    }

    private static MsdrgHacStatus hacStatusValue(int initialDrg, int finalDrg, MsdrgHospitalStatusOptionFlag hospitalStatusPoa, int numHacCategoriesSatisfied) {
        MsdrgHacStatus result = MsdrgHacStatus.NOT_APPLICABLE;
        if (hospitalStatusPoa != MsdrgHospitalStatusOptionFlag.EXEMPT) {
            if (numHacCategoriesSatisfied >= 1 && initialDrg == finalDrg) {
                result = MsdrgHacStatus.FINAL_DRG_NO_CHANGE;
            } else if (numHacCategoriesSatisfied >= 1 && finalDrg == 999) {
                result = MsdrgHacStatus.FINAL_DRG_UNGROUPABLE;
            } else if (numHacCategoriesSatisfied >= 1) {
                result = MsdrgHacStatus.FINAL_DRG_CHANGES;
            }
        }
        return result;
    }
}

