/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.msdrg.v390.logic;

import com.mmm.his.cer.foundation.model.GfcPoa;
import com.mmm.his.cer.utility.farser.ast.parser.ExpressionResult;
import gov.agency.msdrg.model.Attribute;
import gov.agency.msdrg.model.MsdrgDiagnosisCode;
import gov.agency.msdrg.model.MsdrgHac;
import gov.agency.msdrg.model.MsdrgMaskAttributes;
import gov.agency.msdrg.model.MsdrgProcedureCode;
import gov.agency.msdrg.model.RuntimeOptions;
import gov.agency.msdrg.model.enumeration.MsdrgChainContext;
import gov.agency.msdrg.model.enumeration.MsdrgCodeSeverityFlag;
import gov.agency.msdrg.model.enumeration.MsdrgGrouperReturnCode;
import gov.agency.msdrg.model.enumeration.MsdrgHacUsage;
import gov.agency.msdrg.model.enumeration.MsdrgHospitalStatusOptionFlag;
import gov.agency.msdrg.model.enumeration.MsdrgPoaErrorCode;
import gov.agency.msdrg.model.enumeration.MsdrgProcedureHacUsage;
import gov.agency.msdrg.model.transfer.MsdrgGrouperResult;
import gov.agency.msdrg.v390.ProcessingData;
import gov.agency.msdrg.v390.access.MsdrgInteractionDao;
import gov.agency.msdrg.v390.access.blob.dto.HacFormula;
import gov.agency.msdrg.v390.chain.Link;
import gov.agency.msdrg.v390.chain.ProcessingContext;
import gov.agency.msdrg.v390.logic.FormulaEvaluator;
import gov.agency.msdrg.v390.logic.MsdrgMaskBuilder;
import gov.agency.msdrg.v390.logic.MsdrgUtility;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MsdrgHacProcessor
extends FormulaEvaluator
implements Link {
    private static final Logger logger = LoggerFactory.getLogger(MsdrgHacProcessor.class);
    private MsdrgInteractionDao dataAccess;
    private static final Set<Integer> HAC_NUMS_PROCS = new HashSet<Integer>(Arrays.asList(8, 10, 11, 12, 13, 14));

    @Override
    public boolean execute(ProcessingContext context) {
        Map suppliers = (Map)context.get(MsdrgChainContext.AST_SUPPLIER_MAP);
        this.setSuppliers(suppliers);
        this.dataAccess = (MsdrgInteractionDao)context.get(MsdrgChainContext.ACCESS);
        RuntimeOptions runtimeOptions = (RuntimeOptions)context.get(MsdrgChainContext.RUNTIME_OPTIONS);
        ProcessingData processingData = (ProcessingData)context.get(MsdrgChainContext.PROCESSING_DATA);
        logger.debug("Begin HAC processing (This does not do severity only just seeing if a hac formula is met)");
        if (runtimeOptions.getPoaReportingExempt() != MsdrgHospitalStatusOptionFlag.EXEMPT) {
            processingData = this.processHospitalAcquiredCondition(processingData, processingData.getSdxCodes(), processingData.getProcedureCodes(), runtimeOptions.getPoaReportingExempt());
        } else if (runtimeOptions.getPoaReportingExempt() == MsdrgHospitalStatusOptionFlag.EXEMPT) {
            for (MsdrgDiagnosisCode code : processingData.getSdxCodes()) {
                if (code.getHacs().isEmpty()) continue;
                code.setPoaErrorCodeFlag(MsdrgPoaErrorCode.HOSPITAL_EXEMPT);
                for (MsdrgHac hac : code.getHacs()) {
                    hac.setHacStatus(MsdrgHacUsage.HAC_NOT_APPLICABLE_EXEMPT);
                }
            }
            this.updateHacListAfterEvaluation(processingData.getPrincipalDx(), processingData.getSdxCodes());
        }
        MsdrgGrouperReturnCode returnCode = null;
        if (processingData.getFinalResult() != null) {
            returnCode = processingData.getFinalResult().getReturnCode();
        }
        if (returnCode != null && returnCode != MsdrgGrouperReturnCode.OK) {
            context.put(MsdrgChainContext.PROCESSING_DATA, processingData);
            return false;
        }
        context.put(MsdrgChainContext.PROCESSING_DATA, processingData);
        logger.debug("HAC processing finished");
        return true;
    }

    private ProcessingData processHospitalAcquiredCondition(ProcessingData processingData, List<MsdrgDiagnosisCode> sdxCodes, List<MsdrgProcedureCode> procedureCodes, MsdrgHospitalStatusOptionFlag hospitalStatus) {
        HashMap codesWithHacs = new HashMap();
        String codeOnHac6ButNotShowList = null;
        boolean hasInvalidPoaOnClaim = false;
        for (MsdrgDiagnosisCode msdrgDiagnosisCode : sdxCodes) {
            if (msdrgDiagnosisCode.getHacs().isEmpty()) continue;
            for (MsdrgHac hac : msdrgDiagnosisCode.getHacs()) {
                if (msdrgDiagnosisCode.getPoa() == GfcPoa.Y || msdrgDiagnosisCode.getPoa() == GfcPoa.W) {
                    hac.setHacStatus(MsdrgHacUsage.HAC_CRITERIA_NOT_MET);
                    msdrgDiagnosisCode.setPoaErrorCodeFlag(this.getPoaErrorCode(msdrgDiagnosisCode.getPoa()));
                    continue;
                }
                if (msdrgDiagnosisCode.isExcluded()) {
                    hac.setHacStatus(MsdrgHacUsage.HAC_NOT_APPLICABLE_EXCLUSION);
                    msdrgDiagnosisCode.setPoaErrorCodeFlag(this.getPoaErrorCode(msdrgDiagnosisCode.getPoa()));
                    continue;
                }
                MsdrgHacUsage status = this.evaluateHacConditions(processingData, hac);
                hac.setHacStatus(status);
                msdrgDiagnosisCode.setPoaErrorCodeFlag(this.getPoaErrorCode(msdrgDiagnosisCode.getPoa()));
                if (msdrgDiagnosisCode.getPoa() == GfcPoa.E || msdrgDiagnosisCode.getPoa() == GfcPoa.BLANK || msdrgDiagnosisCode.getPoa() == GfcPoa.ONE || msdrgDiagnosisCode.getPoa() == GfcPoa.INVALID) {
                    hasInvalidPoaOnClaim = true;
                }
                if (status != MsdrgHacUsage.HAC_CRITERIA_MET) continue;
                if (hac.getHacNumber() == 6 && !msdrgDiagnosisCode.isOnShowList()) {
                    codeOnHac6ButNotShowList = msdrgDiagnosisCode.getValue();
                }
                List<MsdrgDiagnosisCode> dxCodes = codesWithHacs.containsKey(hac.getHacNumber()) ? (List)codesWithHacs.get(hac.getHacNumber()) : new ArrayList<MsdrgDiagnosisCode>();
                dxCodes.add(msdrgDiagnosisCode);
                codesWithHacs.put(hac.getHacNumber(), dxCodes);
            }
        }
        if (codeOnHac6ButNotShowList == null) {
            for (MsdrgDiagnosisCode msdrgDiagnosisCode : sdxCodes) {
                if (msdrgDiagnosisCode.getHacs().isEmpty()) continue;
                for (MsdrgHac hac : msdrgDiagnosisCode.getHacs()) {
                    if (!hac.getHacList().equals("hac06_show")) continue;
                    hac.setHacStatus(MsdrgHacUsage.HAC_CRITERIA_NOT_MET);
                }
            }
        }
        for (MsdrgDiagnosisCode msdrgDiagnosisCode : sdxCodes) {
            if (msdrgDiagnosisCode.getHacs().isEmpty()) continue;
            for (MsdrgHac hac : msdrgDiagnosisCode.getHacs()) {
                if (!HAC_NUMS_PROCS.contains(hac.getHacNumber()) || hac.getHacStatus() != MsdrgHacUsage.HAC_CRITERIA_MET) continue;
                for (MsdrgProcedureCode procCode : procedureCodes) {
                    int hacNumber = hac.getHacNumber();
                    for (Attribute attr : procCode.getAttributes()) {
                        if (hacNumber < 10) {
                            if (!attr.getListName().contains("hac0" + hacNumber + "_proc")) continue;
                            procCode.getHacUsageFlag().add(MsdrgProcedureHacUsage.fromInt(hacNumber));
                            continue;
                        }
                        if (!attr.getListName().contains("hac" + hacNumber + "_proc")) continue;
                        procCode.getHacUsageFlag().add(MsdrgProcedureHacUsage.fromInt(hacNumber));
                    }
                }
            }
        }
        boolean markUngroupable = false;
        if (!codesWithHacs.isEmpty() && hospitalStatus == MsdrgHospitalStatusOptionFlag.NON_EXEMPT) {
            Iterator iterator = codesWithHacs.keySet().iterator();
            while (iterator.hasNext()) {
                int hacNumber = (Integer)iterator.next();
                List dxCodes = (List)codesWithHacs.get(hacNumber);
                if (hacNumber == 6) {
                    if (codeOnHac6ButNotShowList == null) continue;
                    for (MsdrgDiagnosisCode dxCode : dxCodes) {
                        if (dxCode.getPoa() != GfcPoa.E && dxCode.getPoa() != GfcPoa.BLANK && dxCode.getPoa() != GfcPoa.ONE && dxCode.getPoa() != GfcPoa.INVALID) continue;
                        markUngroupable = true;
                    }
                    continue;
                }
                for (MsdrgDiagnosisCode dxCode2 : dxCodes) {
                    if (dxCode2.getPoa() != GfcPoa.E && dxCode2.getPoa() != GfcPoa.BLANK && dxCode2.getPoa() != GfcPoa.ONE && dxCode2.getPoa() != GfcPoa.INVALID || !dxCode2.hasHacs()) continue;
                    markUngroupable = true;
                }
                if (!hasInvalidPoaOnClaim) continue;
                markUngroupable = true;
            }
            if (markUngroupable) {
                MsdrgGrouperResult msdrgGrouperResult = MsdrgUtility.setUngroupable(MsdrgGrouperReturnCode.HAC_MISSING_ONE_POA, this.dataAccess);
                this.updateHacListAfterEvaluation(processingData.getPrincipalDx(), processingData.getSdxCodes());
                return processingData.toBuilder().withFinalResult(msdrgGrouperResult).build();
            }
        } else if (hospitalStatus == MsdrgHospitalStatusOptionFlag.UNKNOWN && !codesWithHacs.isEmpty()) {
            for (MsdrgDiagnosisCode code : sdxCodes) {
                if (code.getHacs().isEmpty()) continue;
                for (MsdrgHac hac : code.getHacs()) {
                    MsdrgGrouperResult grouperResult;
                    int poaCounter = 0;
                    for (MsdrgDiagnosisCode dxCode : sdxCodes) {
                        if (dxCode.getPoa() == GfcPoa.Y && dxCode.getPoa() == GfcPoa.W) continue;
                        ++poaCounter;
                    }
                    if (poaCounter >= 2) {
                        grouperResult = MsdrgUtility.setUngroupable(MsdrgGrouperReturnCode.HAC_STATUS_INVALID_MULT_HACS_POA_NOT_Y_W, this.dataAccess);
                        code.setFinalSeverityFlag(MsdrgCodeSeverityFlag.NEITHER);
                        this.updateHacListAfterEvaluation(processingData.getPrincipalDx(), processingData.getSdxCodes());
                        return processingData.toBuilder().withFinalResult(grouperResult).build();
                    }
                    if (code.getPoa() == GfcPoa.N || code.getPoa() == GfcPoa.U) {
                        grouperResult = MsdrgUtility.setUngroupable(MsdrgGrouperReturnCode.HAC_STATUS_INVALID_POA_N_OR_U, this.dataAccess);
                        code.setFinalSeverityFlag(MsdrgCodeSeverityFlag.NEITHER);
                        this.updateHacListAfterEvaluation(processingData.getPrincipalDx(), processingData.getSdxCodes());
                        return processingData.toBuilder().withFinalResult(grouperResult).build();
                    }
                    if (code.getPoa() != GfcPoa.INVALID && code.getPoa() != GfcPoa.ONE && code.getPoa() != GfcPoa.BLANK && code.getPoa() != GfcPoa.E) continue;
                    grouperResult = MsdrgUtility.setUngroupable(MsdrgGrouperReturnCode.HAC_STATUS_INVALID_POA_INVALID_OR_1, this.dataAccess);
                    code.setFinalSeverityFlag(MsdrgCodeSeverityFlag.NEITHER);
                    this.updateHacListAfterEvaluation(processingData.getPrincipalDx(), processingData.getSdxCodes());
                    return processingData.toBuilder().withFinalResult(grouperResult).build();
                }
            }
        }
        this.updateHacListAfterEvaluation(processingData.getPrincipalDx(), processingData.getSdxCodes());
        return processingData.toBuilder().build();
    }

    private void updateHacListAfterEvaluation(MsdrgDiagnosisCode pdx, List<MsdrgDiagnosisCode> sdxCodes) {
        for (MsdrgDiagnosisCode msdrgDiagnosisCode : sdxCodes) {
            MsdrgHac hac;
            boolean containsSix = false;
            boolean criteriaMet = false;
            ArrayList<MsdrgHac> updateHacList = new ArrayList<MsdrgHac>();
            if (msdrgDiagnosisCode.getHacs().isEmpty()) continue;
            Iterator<MsdrgHac> iterator = msdrgDiagnosisCode.getHacs().iterator();
            while (iterator.hasNext()) {
                hac = iterator.next();
                if (hac.getHacStatus() == MsdrgHacUsage.HAC_CRITERIA_MET && (msdrgDiagnosisCode.getPoa() != GfcPoa.W || msdrgDiagnosisCode.getPoa() != GfcPoa.Y)) {
                    if (hac.getHacNumber() == 6 && !containsSix) {
                        updateHacList.add(hac);
                        containsSix = true;
                    } else {
                        if (hac.getHacNumber() == 6 && containsSix) continue;
                        updateHacList.add(hac);
                    }
                    criteriaMet = true;
                    continue;
                }
                if (hac.getHacStatus() == MsdrgHacUsage.HAC_CRITERIA_NOT_MET && (msdrgDiagnosisCode.getPoa() == GfcPoa.W || msdrgDiagnosisCode.getPoa() == GfcPoa.Y)) {
                    hac.setHacNumber(0);
                    updateHacList.add(hac);
                    criteriaMet = true;
                    break;
                }
                if (hac.getHacStatus() == MsdrgHacUsage.HAC_NOT_APPLICABLE_EXCLUSION) {
                    updateHacList.add(hac);
                    criteriaMet = true;
                    continue;
                }
                if (hac.getHacStatus() != MsdrgHacUsage.HAC_NOT_APPLICABLE_EXEMPT) continue;
                hac.setHacNumber(0);
                updateHacList.add(hac);
                criteriaMet = true;
            }
            if (!criteriaMet && (iterator = msdrgDiagnosisCode.getHacs().iterator()).hasNext()) {
                hac = iterator.next();
                hac.setHacNumber(0);
                updateHacList.add(hac);
            }
            msdrgDiagnosisCode.setHacsFlags(updateHacList);
        }
        boolean hac11present = false;
        if (!pdx.getHacs().isEmpty()) {
            block2: for (MsdrgDiagnosisCode dxCode : sdxCodes) {
                if (dxCode.getHacsFlags().isEmpty()) continue;
                for (MsdrgHac hac : dxCode.getHacsFlags()) {
                    if (hac.getHacNumber() != 11 || hac.getHacStatus() != MsdrgHacUsage.HAC_CRITERIA_MET) continue;
                    hac11present = true;
                    continue block2;
                }
            }
        }
        if (hac11present) {
            MsdrgHac msdrgHac = new MsdrgHac();
            msdrgHac.setHacNumber(11);
            msdrgHac.setDescription(this.dataAccess.getHacDescription(11));
            pdx.setHacsFlags(Collections.singletonList(msdrgHac));
        }
    }

    private MsdrgPoaErrorCode getPoaErrorCode(GfcPoa poa) {
        if (poa == GfcPoa.Y || poa == GfcPoa.W) {
            return MsdrgPoaErrorCode.POA_RECOGNIZED_YES_POA;
        }
        if (poa == GfcPoa.N || poa == GfcPoa.U) {
            return MsdrgPoaErrorCode.POA_RECOGNIZED_NOT_POA;
        }
        if (poa == GfcPoa.INVALID || poa == GfcPoa.BLANK || poa == GfcPoa.E || poa == GfcPoa.ONE) {
            return MsdrgPoaErrorCode.POA_NOT_RECOGNIZED;
        }
        return MsdrgPoaErrorCode.POA_NOT_RECOGNIZED;
    }

    public MsdrgHacUsage evaluateHacConditions(ProcessingData processingData, MsdrgHac hac) {
        MsdrgHacUsage hacStatus = MsdrgHacUsage.HAC_CRITERIA_NOT_MET;
        MsdrgMaskBuilder maskBuilder = new MsdrgMaskBuilder();
        MsdrgMaskAttributes mask = maskBuilder.buildMask(processingData);
        List<HacFormula> hacRows = this.dataAccess.getFormulasForHacList(hac.getHacNumber());
        if (!hacRows.isEmpty()) {
            for (HacFormula hacFormula : hacRows) {
                ExpressionResult<Attribute> evaluation = this.evaluateFormulaWithoutSuppression(mask, hacFormula.getFormula());
                if (!evaluation.isMatched()) continue;
                hacStatus = MsdrgHacUsage.HAC_CRITERIA_MET;
                break;
            }
        }
        return hacStatus;
    }

    public static boolean isHac(MsdrgDiagnosisCode code, MsdrgHospitalStatusOptionFlag hospitalStatus) {
        boolean isHac = false;
        for (MsdrgHac hac : code.getHacs()) {
            if (!MsdrgHacUsage.HAC_CRITERIA_MET.equals((Object)hac.getHacStatus()) || hospitalStatus == MsdrgHospitalStatusOptionFlag.EXEMPT) continue;
            isHac = true;
            break;
        }
        return isHac;
    }
}

