/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.msdrg.v390.logic;

import gov.agency.msdrg.model.MsdrgDiagnosisCode;
import gov.agency.msdrg.model.MsdrgSeverityResults;
import gov.agency.msdrg.model.enumeration.MsdrgAffectDrgOptionFlag;
import gov.agency.msdrg.model.enumeration.MsdrgCodeSeverityFlag;
import gov.agency.msdrg.model.enumeration.MsdrgHospitalStatusOptionFlag;
import gov.agency.msdrg.model.enumeration.MsdrgMaskBuildingConditions;
import gov.agency.msdrg.model.enumeration.MsdrgSeverity;
import gov.agency.msdrg.v390.logic.MsdrgHacProcessor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class MsdrgSeverityProcessor {
    public MsdrgSeverityResults processClaimSeverity(List<MsdrgDiagnosisCode> diagnosisCodes, MsdrgMaskBuildingConditions processHac, Set<String> severitySuppressionOperands, MsdrgAffectDrgOptionFlag affectDrgOptionFlag, MsdrgHospitalStatusOptionFlag hospitalStatus) {
        MsdrgSeverityResults severityResults = new MsdrgSeverityResults();
        HashMap severityMap = new HashMap();
        severityMap.put(MsdrgSeverity.MCC, new HashSet());
        severityMap.put(MsdrgSeverity.CC, new HashSet());
        for (MsdrgDiagnosisCode dxCode : diagnosisCodes) {
            boolean marked = false;
            if (dxCode.isDowngradeSeverityDueToSuppression()) {
                dxCode.setDowngradeSeverityDueToSuppression(false);
            }
            for (String severitySuppressionOperand : severitySuppressionOperands) {
                if (!dxCode.hasAttribute(severitySuppressionOperand)) continue;
                if (affectDrgOptionFlag == MsdrgAffectDrgOptionFlag.COMPUTE) {
                    this.markSeverityFlag(dxCode, processHac);
                }
                dxCode.setDowngradeSeverityDueToSuppression(true);
                marked = true;
                break;
            }
            if (marked) continue;
            if (processHac == MsdrgMaskBuildingConditions.FINAL && dxCode.getSeverity() != MsdrgSeverity.NON_CC && !dxCode.isExcluded() && !dxCode.isDeathExclusion() && MsdrgHacProcessor.isHac(dxCode, hospitalStatus)) {
                if (affectDrgOptionFlag != MsdrgAffectDrgOptionFlag.COMPUTE) continue;
                this.markSeverityFlag(dxCode, processHac);
                continue;
            }
            if (processHac == MsdrgMaskBuildingConditions.FINAL && dxCode.isExcluded() && !dxCode.isDeathExclusion()) {
                if (affectDrgOptionFlag != MsdrgAffectDrgOptionFlag.COMPUTE) continue;
                this.markSeverityFlag(dxCode, processHac);
                continue;
            }
            if (!dxCode.isExcluded() && !dxCode.isDeathExclusion() && dxCode.getSeverity() != MsdrgSeverity.NON_CC) {
                if (affectDrgOptionFlag == MsdrgAffectDrgOptionFlag.COMPUTE) {
                    this.markSeverityFlag(dxCode, processHac);
                }
                ((Set)severityMap.get((Object)dxCode.getSeverity())).add(dxCode);
            }
            if (processHac == MsdrgMaskBuildingConditions.FINAL && (dxCode.isExcluded() || dxCode.isDeathExclusion()) && dxCode.getSeverity() != MsdrgSeverity.NON_CC) {
                if (affectDrgOptionFlag != MsdrgAffectDrgOptionFlag.COMPUTE) continue;
                this.markSeverityFlag(dxCode, processHac);
                continue;
            }
            if (processHac != MsdrgMaskBuildingConditions.INITIAL || !dxCode.isExcluded() && !dxCode.isDeathExclusion() || dxCode.getSeverity() == MsdrgSeverity.NON_CC || affectDrgOptionFlag != MsdrgAffectDrgOptionFlag.COMPUTE) continue;
            this.markSeverityFlag(dxCode, processHac);
        }
        if (((Set)severityMap.get((Object)MsdrgSeverity.MCC)).size() >= 1) {
            severityResults.setSeverity(MsdrgSeverity.MCC);
            severityResults.setDxCodes((Set)severityMap.get((Object)MsdrgSeverity.MCC));
        } else if (((Set)severityMap.get((Object)MsdrgSeverity.CC)).size() >= 1) {
            severityResults.setSeverity(MsdrgSeverity.CC);
            severityResults.setDxCodes((Set)severityMap.get((Object)MsdrgSeverity.CC));
        } else {
            severityResults.setSeverity(MsdrgSeverity.NON_CC);
            severityResults.setDxCodes(new HashSet<MsdrgDiagnosisCode>());
        }
        return severityResults;
    }

    private void markSeverityFlag(MsdrgDiagnosisCode code, MsdrgMaskBuildingConditions conditions) {
        if (MsdrgMaskBuildingConditions.INITIAL == conditions) {
            if (code.isDeathExclusion() && !code.isExcluded()) {
                code.setInitialSeverityFlag(MsdrgCodeSeverityFlag.NEITHER);
            } else if (code.isDeathExclusion() && code.isExcluded() && code.getSeverity() == MsdrgSeverity.MCC) {
                code.setInitialSeverityFlag(MsdrgCodeSeverityFlag.MCC_EXCLUDED);
            } else if (code.isDeathExclusion() && code.isExcluded() && code.getSeverity() == MsdrgSeverity.CC) {
                code.setInitialSeverityFlag(MsdrgCodeSeverityFlag.CC_EXCLUDED);
            } else if (code.isExcluded() && code.getSeverity() == MsdrgSeverity.MCC) {
                code.setInitialSeverityFlag(MsdrgCodeSeverityFlag.MCC_EXCLUDED);
            } else if (code.isExcluded() && code.getSeverity() == MsdrgSeverity.CC) {
                code.setInitialSeverityFlag(MsdrgCodeSeverityFlag.CC_EXCLUDED);
            } else if (!code.isExcluded() && code.getSeverity() == MsdrgSeverity.MCC) {
                code.setInitialSeverityFlag(MsdrgCodeSeverityFlag.MCC);
            } else if (!code.isExcluded() && code.getSeverity() == MsdrgSeverity.CC) {
                code.setInitialSeverityFlag(MsdrgCodeSeverityFlag.CC);
            } else {
                code.setInitialSeverityFlag(MsdrgCodeSeverityFlag.NEITHER);
            }
        } else if (MsdrgMaskBuildingConditions.FINAL == conditions) {
            if (code.isDeathExclusion() && !code.isExcluded()) {
                code.setFinalSeverityFlag(MsdrgCodeSeverityFlag.NEITHER);
            } else if (code.isDeathExclusion() && code.isExcluded() && code.getSeverity() == MsdrgSeverity.MCC) {
                code.setFinalSeverityFlag(MsdrgCodeSeverityFlag.MCC_EXCLUDED);
            } else if (code.isDeathExclusion() && code.isExcluded() && code.getSeverity() == MsdrgSeverity.CC) {
                code.setFinalSeverityFlag(MsdrgCodeSeverityFlag.CC_EXCLUDED);
            } else if (code.isExcluded() && code.getSeverity() == MsdrgSeverity.MCC) {
                code.setFinalSeverityFlag(MsdrgCodeSeverityFlag.MCC_EXCLUDED);
            } else if (code.isExcluded() && code.getSeverity() == MsdrgSeverity.CC) {
                code.setFinalSeverityFlag(MsdrgCodeSeverityFlag.CC_EXCLUDED);
            } else if (code.hasHacs()) {
                code.setFinalSeverityFlag(MsdrgCodeSeverityFlag.NEITHER);
            } else if (!code.isExcluded() && code.getSeverity() == MsdrgSeverity.MCC) {
                code.setFinalSeverityFlag(MsdrgCodeSeverityFlag.MCC);
            } else if (!code.isExcluded() && code.getSeverity() == MsdrgSeverity.CC) {
                code.setFinalSeverityFlag(MsdrgCodeSeverityFlag.CC);
            } else {
                code.setFinalSeverityFlag(MsdrgCodeSeverityFlag.NEITHER);
            }
        }
    }
}

