/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.msdrg.v390.logic;

import gov.agency.msdrg.model.RuntimeOptions;
import gov.agency.msdrg.model.enumeration.MarkingLogicTieBreaker;
import gov.agency.msdrg.model.enumeration.MsdrgAffectDrgOptionFlag;
import gov.agency.msdrg.model.enumeration.MsdrgHospitalStatusOptionFlag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuntimeDataValidation {
    private static final Logger logger = LoggerFactory.getLogger(RuntimeDataValidation.class);

    public static RuntimeOptions execute(RuntimeOptions runtimeOptions) {
        logger.debug("Begin validating runtime options");
        if (runtimeOptions == null) {
            runtimeOptions = new RuntimeOptions();
            runtimeOptions.setMarkingLogicTieBreaker(MarkingLogicTieBreaker.CLINICAL_SIGNIFICANCE);
            runtimeOptions.setPoaReportingExempt(MsdrgHospitalStatusOptionFlag.UNKNOWN);
            runtimeOptions.setComputeAffectDrg(MsdrgAffectDrgOptionFlag.COMPUTE);
        }
        if (runtimeOptions.getMarkingLogicTieBreaker() == null) {
            runtimeOptions.setMarkingLogicTieBreaker(MarkingLogicTieBreaker.CLINICAL_SIGNIFICANCE);
        }
        if (runtimeOptions.getPoaReportingExempt() == null) {
            runtimeOptions.setPoaReportingExempt(MsdrgHospitalStatusOptionFlag.UNKNOWN);
        }
        if (runtimeOptions.getComputeAffectDrg() == null) {
            runtimeOptions.setComputeAffectDrg(MsdrgAffectDrgOptionFlag.COMPUTE);
        }
        return runtimeOptions;
    }
}

