/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.msdrg.v390.logic.ast;

import com.mmm.his.cer.utility.farser.ast.node.type.BooleanExpression;
import com.mmm.his.cer.utility.farser.ast.node.type.NodeSupplier;
import com.mmm.his.cer.utility.farser.lexer.drg.DrgLexerToken;
import gov.agency.msdrg.model.Attribute;
import gov.agency.msdrg.model.enumeration.MsdrgAttributePrefix;
import java.util.BitSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class SuppressionContainsNode
implements BooleanExpression<Attribute> {
    private Attribute value;

    public SuppressionContainsNode(Attribute value) {
        this.value = value;
    }

    @Override
    public boolean evaluate(List<Attribute> values, Set<Attribute> accumulator) {
        int bound = values.size();
        List matches = IntStream.range(0, bound).filter(i -> ((Attribute)values.get(i)).equals(this.value) && !((Attribute)values.get(i)).getMdcSuppression().intersects(this.value.getMdcSuppression())).boxed().collect(Collectors.toList());
        if (matches.isEmpty()) {
            return false;
        }
        accumulator.add(this.value);
        return true;
    }

    public static class SuppressionNodeSupplier
    implements NodeSupplier<DrgLexerToken, Attribute> {
        private BitSet mdcRestrictions;

        public void setRestrictions(int restrictions) {
            this.mdcRestrictions = new BitSet(32);
            this.mdcRestrictions.set(restrictions);
        }

        @Override
        public BooleanExpression<Attribute> createNode(DrgLexerToken token) {
            String prefix = token.getPrefix().orElse("NONE");
            Attribute operand = new Attribute(MsdrgAttributePrefix.getPrefixFromString(prefix), token.getValue());
            operand.setMdcSuppression(this.mdcRestrictions);
            return new SuppressionContainsNode(operand);
        }
    }
}

